/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.c.enums.CEnumRuntimeData;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public class CInterfaceEnumTool {
    private final AnalysisMethod enumToBooleanMethod;
    private final AnalysisMethod enumToByteMethod;
    private final AnalysisMethod enumToShortMethod;
    private final AnalysisMethod enumToCharMethod;
    private final AnalysisMethod enumToIntMethod;
    private final AnalysisMethod enumToLongMethod;
    private final AnalysisMethod enumToUnsignedWordMethod;
    private final AnalysisMethod enumToSignedWordMethod;
    private final AnalysisMethod longToEnumMethod;

    CInterfaceEnumTool(AnalysisMetaAccess metaAccess) {
        try {
            this.enumToBooleanMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToBoolean", Enum.class));
            this.enumToByteMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToByte", Enum.class));
            this.enumToShortMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToShort", Enum.class));
            this.enumToCharMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToChar", Enum.class));
            this.enumToIntMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToInt", Enum.class));
            this.enumToLongMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToLong", Enum.class));
            this.enumToSignedWordMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToSignedWord", Enum.class));
            this.enumToUnsignedWordMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("enumToUnsignedWord", Enum.class));
            this.longToEnumMethod = metaAccess.lookupJavaMethod((Executable)CEnumRuntimeData.class.getDeclaredMethod("longToEnum", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public static CInterfaceEnumTool singleton() {
        return (CInterfaceEnumTool)ImageSingletons.lookup(CInterfaceEnumTool.class);
    }

    public ValueNode createInvokeEnumToValue(HostedGraphKit kit, EnumInfo enumInfo, AnalysisType returnType, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.createInvokeEnumToValue((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, returnType, arg);
        return kit.createInvokeWithExceptionAndUnwind(callTarget, kit.getFrameState(), invokeBci);
    }

    public ValueNode startInvokeWithExceptionEnumToValue(HostedGraphKit kit, EnumInfo enumInfo, AnalysisType returnType, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.createInvokeEnumToValue((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, returnType, arg);
        return kit.startInvokeWithException((CallTargetNode)callTarget, kit.getFrameState(), invokeBci);
    }

    private MethodCallTargetNode createInvokeEnumToValue(GraphBuilderTool b, CallTargetFactory callTargetFactory, int bci, EnumInfo enumInfo, AnalysisType returnType, ValueNode arg) {
        AnalysisMethod method = this.getEnumToValueMethod(b, returnType);
        assert (!Modifier.isStatic(method.getModifiers()) && method.getSignature().getParameterCount(true) == 2);
        ValueNode[] args = new ValueNode[]{ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)enumInfo.getRuntimeData()), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()), arg};
        WordTypes wordTypes = b.getWordTypes();
        StampPair returnStamp = wordTypes.isWord((JavaType)returnType) ? StampPair.createSingle((Stamp)wordTypes.getWordStamp((ResolvedJavaType)returnType)) : StampFactory.forDeclaredType(null, (JavaType)returnType, (boolean)false);
        return (MethodCallTargetNode)b.append((Node)callTargetFactory.createMethodCallTarget(CallTargetNode.InvokeKind.Special, method, args, returnStamp, bci));
    }

    private AnalysisMethod getEnumToValueMethod(GraphBuilderTool b, AnalysisType returnType) {
        if (b.getWordTypes().isWord((JavaType)returnType)) {
            assert (!b.getMetaAccess().lookupJavaType(PointerBase.class).isAssignableFrom((ResolvedJavaType)returnType)) : "only integer types are allowed";
            if (b.getMetaAccess().lookupJavaType(UnsignedWord.class).isAssignableFrom((ResolvedJavaType)returnType)) {
                return this.enumToUnsignedWordMethod;
            }
            if (b.getMetaAccess().lookupJavaType(SignedWord.class).isAssignableFrom((ResolvedJavaType)returnType)) {
                return this.enumToSignedWordMethod;
            }
            throw VMError.shouldNotReachHere("Unexpected return type: " + String.valueOf(returnType));
        }
        JavaKind returnKind = returnType.getJavaKind();
        return switch (returnKind) {
            case JavaKind.Boolean -> this.enumToBooleanMethod;
            case JavaKind.Byte -> this.enumToByteMethod;
            case JavaKind.Short -> this.enumToShortMethod;
            case JavaKind.Char -> this.enumToCharMethod;
            case JavaKind.Int -> this.enumToIntMethod;
            case JavaKind.Long -> this.enumToLongMethod;
            default -> throw VMError.shouldNotReachHere("Unexpected return kind: " + String.valueOf(returnKind));
        };
    }

    public ValueNode createInvokeLookupEnum(HostedGraphKit kit, AnalysisType enumType, EnumInfo enumInfo, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.createInvokeLongToEnum((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, arg);
        InvokeWithExceptionNode invoke = kit.createInvokeWithExceptionAndUnwind(callTarget, kit.getFrameState(), invokeBci);
        LogicNode instanceOfNode = (LogicNode)kit.append((Node)InstanceOfNode.createAllowNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)enumType), (ValueNode)invoke, null, null));
        ConstantNode enumClass = kit.createConstant((Constant)kit.getConstantReflection().asJavaClass((ResolvedJavaType)enumType), JavaKind.Object);
        GuardingNode guard = kit.createCheckThrowingBytecodeException(instanceOfNode, false, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{invoke, enumClass});
        ObjectStamp resultStamp = StampFactory.object((TypeReference)TypeReference.create(null, (ResolvedJavaType)enumType), (boolean)false);
        return kit.unique((FloatingNode)new PiNode((ValueNode)invoke, (Stamp)resultStamp, guard.asNode()));
    }

    private MethodCallTargetNode createInvokeLongToEnum(GraphBuilderTool b, CallTargetFactory callTargetFactory, int bci, EnumInfo enumInfo, ValueNode arg) {
        assert (!Modifier.isStatic(this.longToEnumMethod.getModifiers()) && this.longToEnumMethod.getSignature().getParameterCount(false) == 1);
        StructuredGraph graph = b.getGraph();
        ValueNode[] args = new ValueNode[]{ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)enumInfo.getRuntimeData()), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)graph), (ValueNode)graph.unique((Node)new ZeroExtendNode(arg, 64))};
        AnalysisType enumReturnType = (AnalysisType)this.longToEnumMethod.getSignature().getReturnType();
        StampPair returnStamp = StampFactory.forDeclaredType(null, (JavaType)enumReturnType, (boolean)false);
        return (MethodCallTargetNode)b.append((Node)callTargetFactory.createMethodCallTarget(CallTargetNode.InvokeKind.Special, this.longToEnumMethod, args, returnStamp, bci));
    }

    public static boolean isPrimitiveOrWord(AnalysisType type) {
        return type.getStorageKind().isPrimitive();
    }

    public static AnalysisType getCEnumValueType(EnumInfo enumInfo, AnalysisMetaAccess metaAccess) {
        int sizeInBytes = enumInfo.getSizeInBytes();
        return switch (sizeInBytes) {
            case 1 -> metaAccess.lookupJavaType(Byte.TYPE);
            case 2 -> metaAccess.lookupJavaType(Short.TYPE);
            case 4 -> metaAccess.lookupJavaType(Integer.TYPE);
            case 8 -> metaAccess.lookupJavaType(Long.TYPE);
            default -> throw VMError.shouldNotReachHere("CEnum has unexpected size: " + sizeInBytes);
        };
    }

    static interface CallTargetFactory {
        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind var1, AnalysisMethod var2, ValueNode[] var3, StampPair var4, int var5);

        public static CallTargetFactory from(BytecodeParser p) {
            return (invokeKind, targetMethod, args, returnStamp, bci) -> p.createMethodCallTarget(invokeKind, (ResolvedJavaMethod)targetMethod, args, returnStamp, null);
        }

        public static CallTargetFactory from(HostedGraphKit kit) {
            return kit::createMethodCallTarget;
        }
    }
}

