/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.methodhandles.InjectedInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.methodhandles.InjectedInvokerSubstitutionType;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class StableInjectedInvokerNameFeature
implements InternalFeature {
    StableInjectedInvokerNameFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        InjectedInvokerRenamingSubstitutionProcessor injectedInvokerSubst = new InjectedInvokerRenamingSubstitutionProcessor();
        access.registerSubstitutionProcessor(injectedInvokerSubst);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        assert (StableInjectedInvokerNameFeature.checkInjectedInvokerNames(((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse().getTypes()));
    }

    private static boolean checkInjectedInvokerNames(List<AnalysisType> types) {
        if (!SubstrateUtil.assertionsEnabled()) {
            throw new AssertionError((Object)"Expensive check: should only run with assertions enabled.");
        }
        if (types.stream().anyMatch(type -> InjectedInvokerRenamingSubstitutionProcessor.isInjectedInvokerType((ResolvedJavaType)type) && type.getWrapped().getClass() != InjectedInvokerSubstitutionType.class && type.getWrapped().getClass() != BaseLayerType.class)) {
            throw new AssertionError((Object)"All injected invoker should be substituted.");
        }
        HashSet injectedInvokerNames = new HashSet();
        types.stream().map(AnalysisType::getName).filter(x -> x.contains("$$InjectedInvoker")).forEach(name -> {
            if (injectedInvokerNames.contains(name)) {
                throw new AssertionError((Object)("Duplicate injected invoker name: " + name));
            }
            injectedInvokerNames.add(name);
        });
        return true;
    }
}

