/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class HostedType
extends HostedElement
implements SharedType,
WrappedJavaType,
OriginalClassProvider {
    public static final HostedType[] EMPTY_ARRAY = new HostedType[0];
    protected final HostedUniverse universe;
    protected final AnalysisType wrapped;
    private final JavaKind kind;
    private final JavaKind storageKind;
    private final HostedClass superClass;
    private final HostedInterface[] interfaces;
    protected HostedArrayClass arrayType;
    protected HostedType[] subTypes;
    protected HostedField[] staticFields;
    boolean loadedFromPriorLayer;
    protected int typeID;
    protected HostedType uniqueConcreteImplementation;
    protected HostedMethod[] allDeclaredMethods;
    protected HostedMethod[] closedTypeWorldVTable;
    protected short typeCheckStart;
    protected short typeCheckRange;
    protected short typeCheckSlot;
    protected short[] closedTypeWorldTypeCheckSlots;
    protected HostedType[] typeCheckInterfaceOrder;
    protected HostedMethod[] openTypeWorldDispatchTables;
    protected int[] itableStartingOffsets;
    protected int typeIDDepth;
    protected int numClassTypes;
    protected int numInterfaceTypes;
    protected int[] openTypeWorldTypeCheckSlots;
    protected HostedType strengthenStampType;

    public HostedType(HostedUniverse universe, AnalysisType wrapped, JavaKind kind, JavaKind storageKind, HostedClass superClass, HostedInterface[] interfaces) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.kind = kind;
        this.storageKind = storageKind;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.typeID = -1;
    }

    public HostedType getStrengthenStampType() {
        return this.strengthenStampType;
    }

    public HostedType[] getSubTypes() {
        assert (this.subTypes != null);
        return this.subTypes;
    }

    protected HostedMethod[] getClosedTypeWorldVTable() {
        assert (this.closedTypeWorldVTable != null);
        return this.closedTypeWorldVTable;
    }

    protected HostedMethod[] getOpenTypeWorldDispatchTables() {
        assert (this.openTypeWorldDispatchTables != null);
        return this.openTypeWorldDispatchTables;
    }

    public HostedMethod[] getVTable() {
        return SubstrateOptions.closedTypeWorld() ? this.getClosedTypeWorldVTable() : this.getOpenTypeWorldDispatchTables();
    }

    @Override
    public int getTypeID() {
        assert (this.typeID != -1);
        return this.typeID;
    }

    public void setTypeCheckRange(short typeCheckStart, short typeCheckRange) {
        assert (SubstrateOptions.closedTypeWorld());
        this.typeCheckStart = typeCheckStart;
        this.typeCheckRange = typeCheckRange;
    }

    public void setTypeCheckSlot(short typeCheckSlot) {
        assert (SubstrateOptions.closedTypeWorld());
        this.typeCheckSlot = typeCheckSlot;
    }

    public void setClosedTypeWorldTypeCheckSlots(short[] closedTypeWorldTypeCheckSlots) {
        assert (SubstrateOptions.closedTypeWorld());
        this.closedTypeWorldTypeCheckSlots = closedTypeWorldTypeCheckSlots;
    }

    public short getTypeCheckStart() {
        assert (SubstrateOptions.closedTypeWorld());
        return this.typeCheckStart;
    }

    public short getTypeCheckRange() {
        assert (SubstrateOptions.closedTypeWorld());
        return this.typeCheckRange;
    }

    public short getTypeCheckSlot() {
        assert (SubstrateOptions.closedTypeWorld());
        return this.typeCheckSlot;
    }

    public short[] getClosedTypeWorldTypeCheckSlots() {
        assert (SubstrateOptions.closedTypeWorld());
        assert (this.closedTypeWorldTypeCheckSlots != null);
        return this.closedTypeWorldTypeCheckSlots;
    }

    public void setTypeIDDepth(int typeIDDepth) {
        assert (!SubstrateOptions.closedTypeWorld());
        this.typeIDDepth = typeIDDepth;
    }

    public void setNumClassTypes(int numClassTypes) {
        assert (!SubstrateOptions.closedTypeWorld());
        this.numClassTypes = numClassTypes;
    }

    public void setNumInterfaceTypes(int numInterfaceTypes) {
        assert (!SubstrateOptions.closedTypeWorld());
        this.numInterfaceTypes = numInterfaceTypes;
    }

    public void setOpenTypeWorldTypeCheckSlots(int[] openTypeWorldTypeCheckSlots) {
        assert (!SubstrateOptions.closedTypeWorld());
        this.openTypeWorldTypeCheckSlots = openTypeWorldTypeCheckSlots;
    }

    public int getTypeIDDepth() {
        assert (!SubstrateOptions.closedTypeWorld());
        return this.typeIDDepth;
    }

    public int getNumClassTypes() {
        assert (!SubstrateOptions.closedTypeWorld());
        return this.numClassTypes;
    }

    public int getNumInterfaceTypes() {
        assert (!SubstrateOptions.closedTypeWorld());
        return this.numInterfaceTypes;
    }

    public int[] getOpenTypeWorldTypeCheckSlots() {
        assert (!SubstrateOptions.closedTypeWorld());
        assert (this.openTypeWorldTypeCheckSlots != null) : this;
        return this.openTypeWorldTypeCheckSlots;
    }

    public boolean isWordType() {
        return this.kind != this.storageKind;
    }

    public HostedMethod[] getAllDeclaredMethods() {
        assert (this.allDeclaredMethods != null) : "not initialized yet";
        return this.allDeclaredMethods;
    }

    public HostedType getUniqueConcreteImplementation() {
        return this.uniqueConcreteImplementation;
    }

    public void loadTypeID(int newTypeID) {
        this.typeID = newTypeID;
        this.loadedFromPriorLayer = true;
    }

    @Override
    public DynamicHub getHub() {
        return this.universe.hostVM().dynamicHub((ResolvedJavaType)this.wrapped);
    }

    public AnalysisType getWrapped() {
        return this.wrapped;
    }

    public boolean isInstantiated() {
        return this.wrapped.isInstantiated();
    }

    public final String getName() {
        return this.wrapped.getName();
    }

    public String toJavaName() {
        return this.wrapped.toJavaName();
    }

    public String toJavaName(boolean qualified) {
        return this.wrapped.toJavaName(qualified);
    }

    public final JavaKind getJavaKind() {
        return this.kind;
    }

    @Override
    public final JavaKind getStorageKind() {
        return this.storageKind;
    }

    public final ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public final boolean hasFinalizer() {
        return false;
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public final boolean isInitialized() {
        return this.getHub().isInitialized();
    }

    public void initialize() {
        this.wrapped.initialize();
    }

    public final HostedArrayClass getArrayClass() {
        return this.arrayType;
    }

    public HostedType getArrayClass(int dimension) {
        HostedType result = this;
        for (int i = 0; i < dimension; ++i) {
            result = result.arrayType;
            if (result != null) continue;
            return null;
        }
        return result;
    }

    public abstract HostedField[] getInstanceFields(boolean var1);

    public ResolvedJavaField[] getStaticFields() {
        assert (this.staticFields != null);
        return this.staticFields;
    }

    public final HostedClass getSuperclass() {
        return this.superClass;
    }

    public final HostedInterface[] getInterfaces() {
        return this.interfaces;
    }

    public abstract HostedType getComponentType();

    public abstract HostedType getBaseType();

    public abstract int getArrayDimension();

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        HostedType result = this.getSingleImplementor();
        if (result == null) {
            return null;
        }
        return new Assumptions.AssumptionResult((Object)result);
    }

    public HostedType getSingleImplementor() {
        return this.uniqueConcreteImplementation;
    }

    public final boolean isAssignableFrom(ResolvedJavaType other) {
        return this.wrapped.isAssignableFrom((ResolvedJavaType)((HostedType)other).wrapped);
    }

    public final ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.universe.lookup((JavaType)this.wrapped.findLeastCommonAncestor((ResolvedJavaType)((HostedType)otherType).wrapped));
    }

    @Override
    public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod m, ResolvedJavaType callerType) {
        HostedMethod method = (HostedMethod)m;
        AnalysisMethod aResult = this.wrapped.resolveConcreteMethod((ResolvedJavaMethod)method.wrapped);
        HostedMethod hResult = aResult == null ? null : (!aResult.isImplementationInvoked() && !this.isWordType() ? null : this.universe.lookup((JavaMethod)aResult));
        return hResult;
    }

    public final int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public final boolean isInstance(JavaConstant obj) {
        return this.wrapped.isInstance(obj);
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return null;
    }

    public String getSourceFileName() {
        return this.wrapped.getSourceFileName();
    }

    public String toString() {
        return "HostedType<" + this.toJavaName(false) + " -> " + this.wrapped.toString() + ">";
    }

    public boolean isLocal() {
        return this.wrapped.isLocal();
    }

    public boolean isMember() {
        return this.wrapped.isLocal();
    }

    public HostedType getEnclosingType() {
        return this.universe.lookup((JavaType)this.wrapped.getEnclosingType());
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.getDeclaredConstructors(true);
    }

    public HostedMethod[] getDeclaredConstructors(boolean forceLink) {
        VMError.guarantee(!forceLink, "only use getDeclaredConstructors without forcing to link, because linking can throw LinkageError");
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredConstructors(forceLink));
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.getDeclaredMethods(true);
    }

    public HostedMethod[] getDeclaredMethods(boolean forceLink) {
        VMError.guarantee(!forceLink, "only use getDeclaredMethods without forcing to link, because linking can throw LinkageError");
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredMethods(forceLink));
    }

    public ResolvedJavaMethod getClassInitializer() {
        return this.universe.lookup((JavaMethod)this.wrapped.getClassInitializer());
    }

    public boolean isLinked() {
        return this.wrapped.isLinked();
    }

    public void link() {
        this.wrapped.link();
    }

    public boolean hasDefaultMethods() {
        return this.wrapped.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.wrapped.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        return this.wrapped.isCloneableWithAllocation();
    }

    public ResolvedJavaType getHostClass() {
        return this.universe.lookup((JavaType)this.wrapped.getHostClass());
    }

    public ResolvedJavaType unwrapTowardsOriginalType() {
        return this.wrapped;
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((JavaType)this);
    }
}

