/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class IncompatibleClassChangeFallbackMethod
extends NonBytecodeMethod {
    private final ResolvedJavaMethod original;
    private final Class<? extends IncompatibleClassChangeError> resolutionError;

    public IncompatibleClassChangeFallbackMethod(ResolvedJavaType declaringClass, ResolvedJavaMethod original, Class<? extends IncompatibleClassChangeError> resolutionError) {
        super(original.getName(), false, declaringClass, original.getSignature(), original.getConstantPool());
        this.original = original;
        this.resolutionError = resolutionError;
    }

    public ResolvedJavaMethod getOriginal() {
        return this.original;
    }

    @Override
    public ResolvedJavaMethod unwrapTowardsOriginalMethod() {
        return this.original;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        AnalysisMethod constructor = kit.getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupConstructor(this.resolutionError, (Class[])new Class[0]));
        AbstractNewObjectNode newInstance = (AbstractNewObjectNode)kit.append((Node)new NewInstanceNode((ResolvedJavaType)constructor.getDeclaringClass(), true));
        kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)constructor, CallTargetNode.InvokeKind.Special, kit.getFrameState(), kit.bci(), new ValueNode[]{newInstance});
        kit.append((Node)new UnwindNode((ValueNode)newInstance));
        return kit.finalizeGraph();
    }
}

