/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.HostedCodeCacheProvider;
import com.oracle.svm.hosted.code.HostedReplacements;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.meta.HostedConstantFieldProvider;
import com.oracle.svm.hosted.meta.HostedConstantReflectionProvider;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.nodes.spi.IdentityHashCodeProvider;
import jdk.graal.compiler.nodes.spi.LoopsDataProvider;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.spi.StampProvider;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;

public class HostedRuntimeConfigurationBuilder
extends SharedRuntimeConfigurationBuilder {
    private final HostedUniverse universe;
    private final HostedProviders analysisProviders;

    public HostedRuntimeConfigurationBuilder(OptionValues options, SVMHost hostVM, HostedUniverse universe, HostedMetaAccess metaAccess, HostedProviders analysisProviders, ClassInitializationSupport classInitializationSupport, LoopsDataProvider originalLoopsDataProvider, SubstratePlatformConfigurationProvider platformConfig, SnippetReflectionProvider snippetReflection) {
        super(options, hostVM, metaAccess, SubstrateBackendFactory.get()::newBackend, classInitializationSupport, originalLoopsDataProvider, platformConfig, snippetReflection);
        this.universe = universe;
        this.analysisProviders = analysisProviders;
    }

    @Override
    protected Providers createProviders(CodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, ForeignCallsProvider foreignCalls, LoweringProvider lowerer, Replacements replacements, StampProvider stampProvider, SnippetReflectionProvider reflectionProvider, PlatformConfigurationProvider platformConfigurationProvider, MetaAccessExtensionProvider metaAccessExtensionProvider, WordTypes wordTypes, LoopsDataProvider loopsDataProvider, IdentityHashCodeProvider identityHashCodeProvider) {
        return new HostedProviders((MetaAccessProvider)this.metaAccess, codeCache, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, reflectionProvider, wordTypes, platformConfigurationProvider, metaAccessExtensionProvider, loopsDataProvider, identityHashCodeProvider);
    }

    @Override
    protected ConstantReflectionProvider createConstantReflectionProvider() {
        return new HostedConstantReflectionProvider(this.universe, (HostedMetaAccess)this.metaAccess, this.classInitializationSupport);
    }

    @Override
    protected ConstantFieldProvider createConstantFieldProvider() {
        return new HostedConstantFieldProvider((MetaAccessProvider)this.metaAccess, this.universe.hostVM());
    }

    @Override
    protected LoweringProvider createLoweringProvider(ForeignCallsProvider foreignCalls, MetaAccessExtensionProvider metaAccessExtensionProvider) {
        return SubstrateLoweringProvider.createForHosted((MetaAccessProvider)this.metaAccess, foreignCalls, this.platformConfig, metaAccessExtensionProvider);
    }

    @Override
    protected Replacements createReplacements(Providers p) {
        ResolvedJavaMethodBytecodeProvider bytecodeProvider = new ResolvedJavaMethodBytecodeProvider();
        return new HostedReplacements(this.universe, p, ConfigurationValues.getTarget(), this.analysisProviders, (BytecodeProvider)bytecodeProvider);
    }

    @Override
    protected CodeCacheProvider createCodeCacheProvider(RegisterConfig registerConfig) {
        return new HostedCodeCacheProvider(ConfigurationValues.getTarget(), registerConfig);
    }
}

