/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.code.FactoryMethodMarker;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyUtils;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;

public final class SimulateClassInitializerPolicy
extends InlineBeforeAnalysisPolicy {
    private final SVMHost hostVM;
    private final SimulateClassInitializerSupport support;

    SimulateClassInitializerPolicy(SVMHost hostVM, SimulateClassInitializerSupport support) {
        super(new NodePlugin[]{new ConstantFoldLoadFieldPlugin(ParsingReason.PointsToAnalysis)});
        this.hostVM = hostVM;
        this.support = support;
    }

    protected boolean shouldInlineInvoke(GraphBuilderContext b, InlineBeforeAnalysisPolicy.AbstractPolicyScope policyScope, AnalysisMethod method, ValueNode[] args) {
        if (b.getDepth() > this.support.maxInlineDepth) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)method.getDeclaringClass(), FactoryMethodMarker.class)) {
            return true;
        }
        return InlineBeforeAnalysisPolicyUtils.inliningAllowed(this.hostVM, b, method);
    }

    protected boolean tryInvocationPlugins() {
        return true;
    }

    protected boolean needsExplicitExceptions() {
        return true;
    }

    protected InlineInvokePlugin.InlineInfo createInvokeInfo(AnalysisMethod method) {
        return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
    }

    protected FixedWithNextNode processInvokeArgs(AnalysisMethod targetMethod, FixedWithNextNode insertionPoint, ValueNode[] arguments, NodeSourcePosition sourcePosition) {
        return insertionPoint;
    }

    protected InlineBeforeAnalysisPolicy.AbstractPolicyScope createRootScope() {
        AccumulativeCounters accumulated = new AccumulativeCounters();
        return new SimulateClassInitializerInlineScope(accumulated, 0);
    }

    protected InlineBeforeAnalysisPolicy.AbstractPolicyScope openCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope o, AnalysisMethod method) {
        SimulateClassInitializerInlineScope outer = (SimulateClassInitializerInlineScope)o;
        return new SimulateClassInitializerInlineScope(outer.accumulativeCounters, outer.inliningDepth + 1);
    }

    protected boolean shouldOmitIntermediateMethodInState(AnalysisMethod method) {
        return false;
    }

    static class AccumulativeCounters {
        long allocatedBytes;

        AccumulativeCounters() {
        }
    }

    public static final class SimulateClassInitializerInlineScope
    extends InlineBeforeAnalysisPolicy.AbstractPolicyScope {
        final AccumulativeCounters accumulativeCounters;
        long allocatedBytes;

        SimulateClassInitializerInlineScope(AccumulativeCounters accumulativeCounters, int inliningDepth) {
            super(inliningDepth);
            this.accumulativeCounters = accumulativeCounters;
        }

        public void commitCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
            SimulateClassInitializerInlineScope calleeScope = (SimulateClassInitializerInlineScope)callee;
            assert (this.accumulativeCounters == calleeScope.accumulativeCounters);
            this.allocatedBytes += calleeScope.allocatedBytes;
        }

        public void abortCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
            SimulateClassInitializerInlineScope calleeScope = (SimulateClassInitializerInlineScope)callee;
            assert (this.accumulativeCounters == calleeScope.accumulativeCounters);
            this.accumulativeCounters.allocatedBytes -= calleeScope.allocatedBytes;
        }

        public boolean processNode(AnalysisMetaAccess metaAccess, AnalysisMethod method, Node node) {
            return true;
        }

        public boolean processNonInlinedInvoke(CoreProviders providers, CallTargetNode node) {
            return true;
        }

        public String toString() {
            return "allocatedBytes: " + this.allocatedBytes + " (" + this.accumulativeCounters.allocatedBytes + ")";
        }
    }
}

