/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.impl.CConstantValueSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class CConstantValueSupportImpl
implements CConstantValueSupport {
    private final NativeLibraries nativeLibraries;
    private final MetaAccessProvider metaAccess;

    public CConstantValueSupportImpl(NativeLibraries nativeLibraries) {
        this.nativeLibraries = nativeLibraries;
        this.metaAccess = nativeLibraries.getMetaAccess();
    }

    public <T> T getCConstantValue(Class<?> declaringClass, String methodName, Class<T> returnType) {
        ResolvedJavaMethod method = this.getAnnotatedMethod(declaringClass, methodName);
        ConstantInfo constantInfo = (ConstantInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)method);
        Object value = constantInfo.getValue();
        switch (constantInfo.getKind()) {
            case INTEGER: 
            case POINTER: {
                return (T)CInterfaceInvocationPlugin.convertCIntegerToMethodReturnType(this.nativeLibraries, returnType, (long)((Long)value), constantInfo.getSizeInBytes() * 8, constantInfo.isUnsigned());
            }
            case FLOAT: {
                if (returnType == Float.class) {
                    return returnType.cast(Float.valueOf(((Double)value).floatValue()));
                }
                return returnType.cast(value);
            }
            case STRING: 
            case BYTEARRAY: {
                return returnType.cast(value);
            }
        }
        throw VMError.shouldNotReachHere("Unexpected returnType: " + returnType.getName());
    }

    private ResolvedJavaMethod getAnnotatedMethod(Class<?> declaringClass, String methodName) {
        ResolvedJavaMethod method;
        try {
            method = this.metaAccess.lookupJavaMethod((Executable)ReflectionUtil.lookupMethod(declaringClass, (String)methodName, (Class[])new Class[0]));
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            throw VMError.shouldNotReachHere("Method not found: " + declaringClass.getName() + "." + methodName);
        }
        if (method.getAnnotation(CConstant.class) == null) {
            throw VMError.shouldNotReachHere("Method " + declaringClass.getName() + "." + methodName + " is not annotated with @" + CConstant.class.getSimpleName());
        }
        return method;
    }
}

