/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.GraalAccess;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class AnalysisMethodHandleAccessProvider
implements MethodHandleAccessProvider {
    private final AnalysisUniverse analysisUniverse;
    private final MethodHandleAccessProvider originalMethodHandleAccess;
    private final SnippetReflectionProvider originalSnippetReflection;

    AnalysisMethodHandleAccessProvider(AnalysisUniverse analysisUniverse) {
        assert (analysisUniverse != null);
        this.analysisUniverse = analysisUniverse;
        this.originalMethodHandleAccess = GraalAccess.getOriginalProviders().getConstantReflection().getMethodHandleAccess();
        this.originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
    }

    public MethodHandleAccessProvider.IntrinsicMethod lookupMethodHandleIntrinsic(ResolvedJavaMethod method) {
        ResolvedJavaMethod original = OriginalMethodProvider.getOriginalMethod((ResolvedJavaMethod)method);
        if (original == null) {
            return null;
        }
        return this.originalMethodHandleAccess.lookupMethodHandleIntrinsic(original);
    }

    public ResolvedJavaMethod resolveInvokeBasicTarget(JavaConstant methodHandle, boolean forceBytecodeGeneration) {
        JavaConstant originalMethodHandle = this.toOriginalConstant(methodHandle);
        if (originalMethodHandle == null) {
            return null;
        }
        ResolvedJavaMethod originalTarget = this.originalMethodHandleAccess.resolveInvokeBasicTarget(originalMethodHandle, true);
        return this.analysisUniverse.lookup((JavaMethod)originalTarget);
    }

    public ResolvedJavaMethod resolveLinkToTarget(JavaConstant memberName) {
        JavaConstant originalMemberName = this.toOriginalConstant(memberName);
        if (originalMemberName == null) {
            return null;
        }
        ResolvedJavaMethod method = this.originalMethodHandleAccess.resolveLinkToTarget(originalMemberName);
        return this.analysisUniverse.lookup((JavaMethod)method);
    }

    private JavaConstant toOriginalConstant(JavaConstant constant) {
        ImageHeapConstant imageHeapConstant;
        if (constant instanceof ImageHeapConstant && !(imageHeapConstant = (ImageHeapConstant)constant).isBackedByHostedObject()) {
            return null;
        }
        Object obj = this.analysisUniverse.getSnippetReflection().asObject(Object.class, constant);
        return this.originalSnippetReflection.forObject(obj);
    }
}

