/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.ServiceCatalogSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.analysis.Inflation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;

@AutomaticallyRegisteredFeature
public class ServiceLoaderFeature
implements InternalFeature {
    private static final Set<String> SKIPPED_SERVICES = Set.of("com.oracle.svm.hosted.NativeImageClassLoaderPostProcessing", "org.graalvm.nativeimage.Platform", "java.util.random.RandomGenerator", "java.security.Provider", "sun.util.locale.provider.LocaleDataMetaInfo", "jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory", "jdk.graal.compiler.hotspot.CompilerConfigurationFactory", "jdk.graal.compiler.hotspot.HotSpotBackendFactory", "jdk.graal.compiler.hotspot.meta.DefaultHotSpotLoweringProvider$Extensions", "jdk.graal.compiler.hotspot.meta.HotSpotInvocationPluginProvider", "jdk.graal.compiler.truffle.hotspot.TruffleCallBoundaryInstrumentationFactory");
    private final Set<String> servicesToSkip = new HashSet<String>(SKIPPED_SERVICES);
    private static final Set<String> SKIPPED_PROVIDERS = Set.of("jdk.graal.compiler.hotspot.meta.HotSpotDisassemblerProvider", "jdk.internal.org.jline.JdkConsoleProviderImpl", "jdk.jshell.execution.impl.ConsoleImpl$ConsoleProviderImpl");
    private final Set<String> serviceProvidersToSkip = new HashSet<String>(SKIPPED_PROVIDERS);

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.UseServiceLoaderFeature.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.servicesToSkip.addAll(Options.ServiceLoaderFeatureExcludeServices.getValue().values());
        this.serviceProvidersToSkip.addAll(Options.ServiceLoaderFeatureExcludeServiceProviders.getValue().values());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        accessImpl.imageClassLoader.classLoaderSupport.serviceProvidersForEach((serviceName, providers) -> {
            Class serviceClass = access.findClassByName(serviceName);
            boolean skipService = false;
            Collection providersToSkip = providers;
            if (this.servicesToSkip.contains(serviceName)) {
                skipService = true;
            } else if (serviceClass == null || serviceClass.isArray() || serviceClass.isPrimitive()) {
                skipService = true;
            } else if (!accessImpl.getHostVM().platformSupported(serviceClass)) {
                skipService = true;
            } else {
                providersToSkip = providers.stream().filter(this.serviceProvidersToSkip::contains).collect(Collectors.toList());
                if (!providersToSkip.isEmpty()) {
                    skipService = true;
                }
            }
            if (skipService) {
                ServiceCatalogSupport.singleton().removeServicesFromServicesCatalog((String)serviceName, (Set<String>)new HashSet<String>(providersToSkip));
                return;
            }
            access.registerReachabilityHandler(a -> this.handleServiceClassIsReachable((Feature.DuringAnalysisAccess)a, serviceClass, (Collection<String>)providers), new Object[]{serviceClass});
        });
    }

    void handleServiceClassIsReachable(Feature.DuringAnalysisAccess access, Class<?> serviceProvider, Collection<String> providers) {
        LinkedHashSet<String> registeredProviders = new LinkedHashSet<String>();
        for (String provider : providers) {
            FeatureImpl.DuringAnalysisAccessImpl accessImpl;
            Class providerClass;
            if (this.serviceProvidersToSkip.contains(provider) || (providerClass = access.findClassByName(provider)) == null || providerClass.isArray() || providerClass.isPrimitive() || !(accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access).getHostVM().platformSupported(providerClass) || ((Inflation)accessImpl.getBigBang()).getAnnotationSubstitutionProcessor().isDeleted(providerClass)) continue;
            Constructor nullaryConstructor = null;
            Method nullaryProviderMethod = null;
            try {
                Constructor constructor;
                if (providerClass.getModule().isNamed() && !providerClass.getModule().getDescriptor().isAutomatic()) {
                    for (Method method : providerClass.getDeclaredMethods()) {
                        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || !method.getName().equals("provider")) continue;
                        if (nullaryProviderMethod == null) {
                            nullaryProviderMethod = method;
                            continue;
                        }
                        nullaryProviderMethod = null;
                        break;
                    }
                }
                if (Modifier.isPublic((constructor = providerClass.getDeclaredConstructor(new Class[0])).getModifiers())) {
                    nullaryConstructor = constructor;
                }
            }
            catch (LinkageError | NoSuchMethodException | SecurityException throwable) {
                // empty catch block
            }
            if (nullaryConstructor == null && nullaryProviderMethod == null) continue;
            RuntimeReflection.register((Class[])new Class[]{providerClass});
            if (nullaryConstructor != null) {
                RuntimeReflection.register((Executable[])new Executable[]{nullaryConstructor});
            }
            if (nullaryProviderMethod != null) {
                RuntimeReflection.register((Executable[])new Executable[]{nullaryProviderMethod});
            } else {
                RuntimeReflection.registerMethodLookup((Class)providerClass, (String)"provider", (Class[])new Class[0]);
            }
            registeredProviders.add(provider);
        }
        if (!registeredProviders.isEmpty()) {
            String serviceResourceLocation = "META-INF/services/" + serviceProvider.getName();
            byte[] serviceFileData = registeredProviders.stream().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
            RuntimeResourceAccess.addResource((Module)access.getApplicationClassLoader().getUnnamedModule(), (String)serviceResourceLocation, (byte[])serviceFileData);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> UseServiceLoaderFeature = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ServiceLoaderFeatureExcludeServices = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ServiceLoaderFeatureExcludeServiceProviders = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    }
}

