/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class HeapBreakdownProvider {
    private static final String BYTE_ARRAY_PREFIX = "byte[] for ";
    private static final Field STRING_VALUE = ReflectionUtil.lookupField(String.class, (String)"value");
    private boolean reportStringBytes = true;
    private int graphEncodingByteLength = -1;
    private List<HeapBreakdownEntry> sortedBreakdownEntries;
    private long totalHeapSize = -1L;

    public static HeapBreakdownProvider singleton() {
        return (HeapBreakdownProvider)ImageSingletons.lookup(HeapBreakdownProvider.class);
    }

    public void disableStringBytesReporting() {
        this.reportStringBytes = false;
    }

    public void setGraphEncodingByteLength(int value) {
        this.graphEncodingByteLength = value;
    }

    public List<HeapBreakdownEntry> getSortedBreakdownEntries() {
        return this.sortedBreakdownEntries;
    }

    public long getTotalHeapSize() {
        assert (this.totalHeapSize >= 0L);
        return this.totalHeapSize;
    }

    protected void calculate(FeatureImpl.BeforeImageWriteAccessImpl access) {
        HostedMetaAccess metaAccess = access.getHostedMetaAccess();
        ObjectLayout objectLayout = (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class);
        HashMap<HostedClass, HeapBreakdownEntry> classToDataMap = new HashMap<HostedClass, HeapBreakdownEntry>();
        long totalObjectSize = 0L;
        long stringByteArrayTotalSize = 0L;
        int stringByteArrayTotalCount = 0;
        Set seenStringByteArrays = Collections.newSetFromMap(new IdentityHashMap());
        boolean reportStringBytesConstant = this.reportStringBytes;
        for (NativeImageHeap.ObjectInfo o : access.getImage().getHeap().getObjects()) {
            String string;
            byte[] bytes;
            Object object;
            if (o.getConstant().isInBaseLayer()) continue;
            long objectSize = o.getSize();
            totalObjectSize += objectSize;
            classToDataMap.computeIfAbsent(o.getClazz(), c -> new HeapBreakdownEntry((HostedClass)c)).add(objectSize);
            if (!reportStringBytesConstant || !((object = o.getObject()) instanceof String) || !seenStringByteArrays.add(bytes = HeapBreakdownProvider.getInternalByteArray(string = (String)object))) continue;
            stringByteArrayTotalSize += objectLayout.getArraySize(JavaKind.Byte, bytes.length, true);
            ++stringByteArrayTotalCount;
        }
        seenStringByteArrays.clear();
        ResolvedJavaType byteArrayType = metaAccess.lookupJavaType((Class)byte[].class);
        HeapBreakdownEntry byteArrayEntry = (HeapBreakdownEntry)classToDataMap.remove(byteArrayType);
        assert (byteArrayEntry != null) : "Unable to find heap breakdown data for byte[] type";
        ArrayList<HeapBreakdownEntry> entries = new ArrayList<HeapBreakdownEntry>(classToDataMap.values());
        classToDataMap.clear();
        this.totalHeapSize = access.getImage().getImageHeapSize();
        long heapAlignmentSize = this.totalHeapSize - totalObjectSize;
        assert (heapAlignmentSize >= 0L) : "Incorrect heap alignment detected: " + heapAlignmentSize;
        if (heapAlignmentSize > 0L) {
            HeapBreakdownEntry heapAlignmentEntry = new HeapBreakdownEntry("", "heap alignment", "#glossary-heap-alignment");
            heapAlignmentEntry.add(heapAlignmentSize);
            entries.add(heapAlignmentEntry);
        }
        if (stringByteArrayTotalSize > 0L) {
            HeapBreakdownProvider.addEntry(entries, byteArrayEntry, new HeapBreakdownEntry("byte[] for java.lang.String"), stringByteArrayTotalSize, stringByteArrayTotalCount);
        }
        List<Integer> codeInfoByteArrayLengths = CodeInfoTable.getImageCodeCache().getTotalByteArrayLengths();
        long codeInfoSize = codeInfoByteArrayLengths.stream().map(l -> objectLayout.getArraySize(JavaKind.Byte, (int)l, true)).reduce(0L, Long::sum);
        HeapBreakdownProvider.addEntry(entries, byteArrayEntry, new HeapBreakdownEntry(BYTE_ARRAY_PREFIX, "code metadata", "#glossary-code-metadata"), codeInfoSize, codeInfoByteArrayLengths.size());
        int metadataByteLength = ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).getMetadataByteLength();
        if (metadataByteLength > 0) {
            long metadataSize = objectLayout.getArraySize(JavaKind.Byte, metadataByteLength, true);
            HeapBreakdownProvider.addEntry(entries, byteArrayEntry, new HeapBreakdownEntry(BYTE_ARRAY_PREFIX, "reflection metadata", "#glossary-reflection-metadata"), metadataSize, 1);
        }
        long resourcesByteArraySize = 0L;
        int resourcesByteArrayCount = 0;
        for (ConditionalRuntimeValue<ResourceStorageEntryBase> resourceList : Resources.singleton().resources()) {
            if (!resourceList.getValueUnconditionally().hasData()) continue;
            for (byte[] resource : resourceList.getValueUnconditionally().getData()) {
                resourcesByteArraySize += objectLayout.getArraySize(JavaKind.Byte, resource.length, true);
                ++resourcesByteArrayCount;
            }
        }
        ProgressReporter reporter = ProgressReporter.singleton();
        reporter.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.RESOURCE_SIZE_BYTES, resourcesByteArraySize);
        if (resourcesByteArraySize > 0L) {
            HeapBreakdownProvider.addEntry(entries, byteArrayEntry, new HeapBreakdownEntry(BYTE_ARRAY_PREFIX, "embedded resources", "#glossary-embedded-resources"), resourcesByteArraySize, resourcesByteArrayCount);
        }
        if (this.graphEncodingByteLength >= 0) {
            long graphEncodingSize = objectLayout.getArraySize(JavaKind.Byte, this.graphEncodingByteLength, true);
            reporter.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.GRAPH_ENCODING_SIZE, graphEncodingSize);
            HeapBreakdownProvider.addEntry(entries, byteArrayEntry, new HeapBreakdownEntry(BYTE_ARRAY_PREFIX, "graph encodings", "#glossary-graph-encodings"), graphEncodingSize, 1);
        }
        assert (byteArrayEntry.byteSize >= 0L && byteArrayEntry.count >= 0);
        HeapBreakdownProvider.addEntry(entries, byteArrayEntry, new HeapBreakdownEntry(BYTE_ARRAY_PREFIX, "general heap data", "#glossary-general-heap-data"), byteArrayEntry.byteSize, byteArrayEntry.count);
        assert (byteArrayEntry.byteSize == 0L && byteArrayEntry.count == 0);
        this.sortedBreakdownEntries = entries.stream().sorted(Comparator.comparingLong(HeapBreakdownEntry::getByteSize).reversed()).toList();
    }

    private static void addEntry(List<HeapBreakdownEntry> entries, HeapBreakdownEntry byteArrayEntry, HeapBreakdownEntry newData, long byteSize, int count) {
        newData.add(byteSize, count);
        entries.add(newData);
        byteArrayEntry.remove(byteSize, count);
        assert (byteArrayEntry.byteSize >= 0L && byteArrayEntry.count >= 0);
    }

    private static byte[] getInternalByteArray(String string) {
        try {
            return (byte[])STRING_VALUE.get(string);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static class HeapBreakdownEntry {
        final HeapBreakdownLabel label;
        long byteSize;
        int count;

        HeapBreakdownEntry(HostedClass hostedClass) {
            this(hostedClass.toJavaName(true));
        }

        public HeapBreakdownEntry(String name) {
            this.label = new SimpleHeapObjectKindName(name);
        }

        HeapBreakdownEntry(String prefix, String name, String htmlAnchor) {
            this.label = new LinkyHeapObjectKindName(prefix, name, htmlAnchor);
        }

        public HeapBreakdownLabel getLabel() {
            return this.label;
        }

        public long getByteSize() {
            return this.byteSize;
        }

        public long getCount() {
            return this.count;
        }

        public void add(long addByteSize) {
            this.add(addByteSize, 1);
        }

        void add(long addByteSize, int addCount) {
            this.byteSize += addByteSize;
            this.count += addCount;
        }

        void remove(long subByteSize, int subCount) {
            this.byteSize -= subByteSize;
            this.count -= subCount;
        }
    }

    record LinkyHeapObjectKindName(String prefix, String label, String htmlAnchor) implements HeapBreakdownLabel
    {
        @Override
        public String renderToString(ProgressReporter.LinkStrategy linkStrategy) {
            return this.prefix + linkStrategy.asDocLink(this.label, this.htmlAnchor);
        }
    }

    record SimpleHeapObjectKindName(String name) implements HeapBreakdownLabel
    {
        @Override
        public String renderToString(ProgressReporter.LinkStrategy linkStrategy) {
            return this.name;
        }
    }

    public static interface HeapBreakdownLabel {
        public String renderToString(ProgressReporter.LinkStrategy var1);
    }
}

