/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateControlFlowIntegrityFeature;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ContinuationsFeature
implements InternalFeature {
    private Boolean supported;

    public static boolean isSupported() {
        return ((ContinuationsFeature)ImageSingletons.lookup(ContinuationsFeature.class)).supported;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(SubstrateControlFlowIntegrityFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (ContinuationSupport.Options.VMContinuations.getValue().booleanValue()) {
            this.supported = !DeoptimizationSupport.enabled() && !SubstrateOptions.useLLVMBackend() && SubstrateControlFlowIntegrity.singleton().continuationsSupported();
            UserError.guarantee(this.supported != false || !ContinuationSupport.Options.VMContinuations.hasBeenSet(), "Continuation support has been explicitly enabled with option %s but is not available because of the runtime compilation, LLVM backend, or control flow integrity features.", ContinuationSupport.Options.VMContinuations.getName());
        } else {
            this.supported = false;
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (ContinuationsFeature.isSupported()) {
            if (!ImageSingletons.contains(ContinuationSupport.class)) {
                ImageSingletons.add(ContinuationSupport.class, (Object)new ContinuationSupport());
            }
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            access.registerAsAccessed(ipField);
            access.registerReachabilityHandler(a -> access.registerAsInHeap(StoredContinuation.class), new Object[]{ReflectionUtil.lookupMethod(StoredContinuationAccess.class, (String)"allocate", (Class[])new Class[]{Integer.TYPE})});
        } else {
            access.registerReachabilityHandler(a -> VMError.shouldNotReachHere("Virtual threads internals are reachable but support is not available or active."), new Object[]{StoredContinuationAccess.class});
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (ContinuationsFeature.isSupported()) {
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            long offset = access.objectFieldOffset(ipField);
            ContinuationSupport.singleton().setIPOffset(offset);
        }
    }
}

