/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.reflect.target.Util_sun_reflect_annotation_AnnotationInvocationHandler;
import java.util.List;

@TargetClass(className="sun.reflect.annotation.AnnotationInvocationHandler")
final class Target_sun_reflect_annotation_AnnotationInvocationHandler {
    Target_sun_reflect_annotation_AnnotationInvocationHandler() {
    }

    @Alias
    static native String toSourceString(Class<?> var0);

    @Alias
    static native String toSourceString(float var0);

    @Alias
    static native String toSourceString(double var0);

    @Alias
    static native String toSourceString(byte var0);

    @Alias
    static native String toSourceString(char var0);

    @Alias
    static native String toSourceString(long var0);

    @Alias
    static native String toSourceString(String var0);

    @Substitute
    private static String memberValueToString(Object value) {
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == Class.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString((Class)value);
            }
            if (type == String.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString((String)value);
            }
            if (type == Character.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString(((Character)value).charValue());
            }
            if (type == Double.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString((Double)value);
            }
            if (type == Float.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString(((Float)value).floatValue());
            }
            if (type == Long.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString((Long)value);
            }
            if (type == Byte.class) {
                return Target_sun_reflect_annotation_AnnotationInvocationHandler.toSourceString((Byte)value);
            }
            return value.toString();
        }
        List<String> stringList = type == byte[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((byte[])value) : (type == char[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((char[])value) : (type == double[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((double[])value) : (type == float[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((float[])value) : (type == int[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((int[])value) : (type == long[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((long[])value) : (type == short[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((short[])value) : (type == boolean[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((boolean[])value) : (type == Class[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((Class[])value) : (type == String[].class ? Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((String[])value) : Util_sun_reflect_annotation_AnnotationInvocationHandler.convert((Object[])value))))))))));
        return Util_sun_reflect_annotation_AnnotationInvocationHandler.stringListToString(stringList);
    }
}

