/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

public class JfrAllocationEvents {
    private static final FastThreadLocalLong lastThreadAllocatedBytes = FastThreadLocalFactory.createLong("JfrAllocationEvents.lastThreadAllocatedBytes");

    public static void reset() {
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            lastThreadAllocatedBytes.set(isolateThread, 0L);
            isolateThread = VMThreads.nextThread(isolateThread);
        }
    }

    public static void emit(long startTicks, DynamicHub hub, UnsignedWord allocationSize, UnsignedWord tlabSize) {
        if (HasJfrSupport.get()) {
            JfrAllocationEvents.emitObjectAllocationInNewTLAB(startTicks, hub, allocationSize, tlabSize);
            JfrAllocationEvents.emitObjectAllocationSample(startTicks, hub);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitObjectAllocationInNewTLAB(long startTicks, DynamicHub hub, UnsignedWord allocationSize, UnsignedWord tlabSize) {
        if (JfrEvent.ObjectAllocationInNewTLAB.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ObjectAllocationInNewTLAB);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.ObjectAllocationInNewTLAB, 0));
            JfrNativeEventWriter.putClass(data, DynamicHub.toClass(hub));
            JfrNativeEventWriter.putLong(data, allocationSize.rawValue());
            JfrNativeEventWriter.putLong(data, tlabSize.rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitObjectAllocationSample(long startTicks, DynamicHub hub) {
        if (JfrEvent.ObjectAllocationSample.shouldEmit()) {
            long threadAllocatedBytes = PlatformThreads.getThreadAllocatedBytes();
            long weight = threadAllocatedBytes - lastThreadAllocatedBytes.get();
            assert (weight > 0L);
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ObjectAllocationSample);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.ObjectAllocationSample, 0));
            JfrNativeEventWriter.putClass(data, DynamicHub.toClass(hub));
            JfrNativeEventWriter.putLong(data, weight);
            JfrNativeEventWriter.endSmallEvent(data);
            lastThreadAllocatedBytes.set(threadAllocatedBytes);
        }
    }
}

