/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources.CompressedGlobTrie;

import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.DoubleStarNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobTrieNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobUtils;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.LiteralNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.StarTrieNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CompressedGlobTrie {
    private static final Pattern threeConsecutiveStarsRegex = Pattern.compile(".*[*]{3,}.*");
    private static final Pattern emptyLevelsRegex = Pattern.compile(".*/{2,}.*");

    public static void finalize(GlobTrieNode root) {
        root.trim();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static List<String> getAdditionalContentIfMatched(GlobTrieNode root, String text) {
        ArrayList<GlobTrieNode> matchedNodes = new ArrayList<GlobTrieNode>();
        CompressedGlobTrie.getAllPatterns(root, CompressedGlobTrie.getPatternParts(text), 0, matchedNodes);
        if (matchedNodes.isEmpty()) {
            return null;
        }
        ArrayList<String> additionalContexts = new ArrayList<String>();
        matchedNodes.forEach(node -> additionalContexts.addAll(node.getAdditionalContent()));
        return additionalContexts;
    }

    public static boolean match(GlobTrieNode root, String text) {
        String escapedText = CompressedGlobTrie.escapeAllStars(text);
        ArrayList<GlobTrieNode> tmp = new ArrayList<GlobTrieNode>();
        CompressedGlobTrie.getAllPatterns(root, CompressedGlobTrie.getPatternParts(escapedText), 0, tmp);
        return !tmp.isEmpty();
    }

    private static String escapeAllStars(String text) {
        return text.replace("*", "\\*");
    }

    public static String validatePattern(String pattern) {
        StringBuilder sb = new StringBuilder();
        if (pattern.isEmpty()) {
            sb.append("Pattern ").append(pattern).append(" : Pattern cannot be empty. ");
            return sb.toString();
        }
        if (threeConsecutiveStarsRegex.matcher(pattern).matches()) {
            sb.append("Pattern contains more than two consecutive * characters. ");
        }
        if (emptyLevelsRegex.matcher(pattern).matches()) {
            sb.append("Pattern contains empty levels. ");
        }
        if (pattern.contains("**/**")) {
            sb.append("Pattern contains invalid sequence **/**. Valid pattern should have ** followed by something other than **. ");
        }
        boolean escapeMode = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char current = pattern.charAt(i);
            if (GlobUtils.ALWAYS_ESCAPED_GLOB_WILDCARDS.contains(Character.valueOf(current)) && !escapeMode) {
                sb.append("Pattern contains unescaped character ").append(current).append(". ");
            }
            escapeMode = current == '\\';
        }
        List<GlobTrieNode> patternParts = CompressedGlobTrie.getPatternParts(pattern);
        for (GlobTrieNode part : patternParts) {
            if (part instanceof LiteralNode) break;
            if (!(part instanceof DoubleStarNode)) continue;
            sb.append("Pattern contains ** without previous literal. This pattern is too generic and therefore can match many resources. Please make the pattern more specific by adding non-generic level before ** level.");
        }
        if (!sb.isEmpty()) {
            sb.insert(0, "Pattern " + pattern + " : ");
        }
        return sb.toString();
    }

    public static List<GlobTrieNode> getPatternParts(String glob) {
        String pattern = !glob.endsWith("/") ? glob : glob.substring(0, glob.length() - 1);
        ArrayList<GlobTrieNode> parts = new ArrayList<GlobTrieNode>();
        List<String> levels = Arrays.stream(pattern.split("/")).toList();
        for (String level : levels) {
            if (level.equals("**")) {
                DoubleStarNode tmp = new DoubleStarNode();
                tmp.setNewLevel();
                parts.add(tmp);
                continue;
            }
            if (level.equals("*")) {
                StarTrieNode tmp = new StarTrieNode(true);
                tmp.setNewLevel();
                parts.add(tmp);
                continue;
            }
            int s = level.indexOf("*".charAt(0));
            if (s != -1) {
                ArrayList<GlobTrieNode> thisLevelParts = new ArrayList<GlobTrieNode>();
                StringBuilder currentPart = new StringBuilder();
                StarCollectorMode currentMode = StarCollectorMode.NORMAL;
                for (char c : level.toCharArray()) {
                    currentPart.append(c);
                    if (c == "*".charAt(0) && currentMode == StarCollectorMode.NORMAL) {
                        thisLevelParts.add(new StarTrieNode(currentPart.toString()));
                        currentPart.setLength(0);
                    }
                    currentMode = c == '\\' ? StarCollectorMode.ESCAPE : StarCollectorMode.NORMAL;
                }
                if (!currentPart.isEmpty()) {
                    thisLevelParts.add(new LiteralNode(currentPart.toString()));
                }
                ((GlobTrieNode)thisLevelParts.get(0)).setNewLevel();
                parts.addAll(thisLevelParts);
                continue;
            }
            LiteralNode tmp = new LiteralNode(level);
            tmp.setNewLevel();
            parts.add(tmp);
        }
        return parts;
    }

    private static void getAllPatterns(GlobTrieNode node, List<GlobTrieNode> parts, int i, List<GlobTrieNode> matches) {
        if (CompressedGlobTrie.patternReachedEnd(i, parts)) {
            if (node.isLeaf()) {
                matches.add(node);
            }
            return;
        }
        DoubleStarNode doubleStar = node.getDoubleStarNode();
        if (doubleStar != null) {
            for (MatchedNode matchedNode : CompressedGlobTrie.getAllAvailablePaths(doubleStar, parts, i)) {
                CompressedGlobTrie.getAllPatterns(matchedNode.child(), parts, matchedNode.lastMatchedChildIndex() + 1, matches);
            }
        }
        SquashedParts sp = CompressedGlobTrie.getThisLevel(parts, i);
        for (StarTrieNode child3 : node.getChildrenWithStar()) {
            for (GlobTrieNode c : CompressedGlobTrie.matchOneLevel(child3, sp.squashedPart())) {
                CompressedGlobTrie.getAllPatterns(c, parts, i + sp.numberOfSquashedParts() + 1, matches);
            }
        }
        GlobTrieNode globTrieNode = parts.get(i);
        if (globTrieNode instanceof StarTrieNode || globTrieNode instanceof DoubleStarNode) {
            return;
        }
        GlobTrieNode child = node.getChild(globTrieNode.getContent());
        if (child == null) {
            return;
        }
        CompressedGlobTrie.getAllPatterns(child, parts, i + 1, matches);
    }

    private static List<MatchedNode> getAllAvailablePaths(DoubleStarNode node, List<GlobTrieNode> parts, int i) {
        ArrayList<MatchedNode> successors = new ArrayList<MatchedNode>();
        if (node.isLeaf()) {
            return List.of(new MatchedNode(node, parts.size()));
        }
        for (int j = i; j < parts.size(); ++j) {
            GlobTrieNode child2;
            SquashedParts sp = CompressedGlobTrie.getThisLevel(parts, j);
            for (GlobTrieNode child2 : node.getChildrenWithStar()) {
                int finalJ = j;
                successors.addAll(CompressedGlobTrie.matchOneLevel(child2, sp.squashedPart()).stream().map(c -> new MatchedNode((GlobTrieNode)c, finalJ + sp.numberOfSquashedParts())).toList());
            }
            GlobTrieNode part = parts.get(j);
            if (part instanceof StarTrieNode) continue;
            child2 = node.getChild(part.getContent());
            if (!part.isNewLevel() || child2 == null) continue;
            successors.add(new MatchedNode(child2, j));
        }
        return successors;
    }

    private static int getIndexOfFirstUnescapedStar(String level) {
        StarCollectorMode currentMode = StarCollectorMode.NORMAL;
        for (int i = 0; i < level.length(); ++i) {
            char c = level.charAt(i);
            if (c == "*".charAt(0) && currentMode == StarCollectorMode.NORMAL) {
                return i;
            }
            currentMode = c == '\\' ? StarCollectorMode.ESCAPE : StarCollectorMode.NORMAL;
        }
        return -1;
    }

    private static List<GlobTrieNode> matchOneLevel(StarTrieNode node, String wholeLevel) {
        if (node.isMatchingWholeLevel()) {
            return List.of(node);
        }
        String nodeContent = node.getContent();
        String prefix = nodeContent.substring(0, CompressedGlobTrie.getIndexOfFirstUnescapedStar(nodeContent));
        if (!prefix.equals("*") && !wholeLevel.startsWith(prefix)) {
            return Collections.emptyList();
        }
        String remainingLevel = wholeLevel.substring(wholeLevel.indexOf(prefix) + prefix.length());
        if (!node.hasChildrenOnThisLevel()) {
            return List.of(node);
        }
        ArrayList<GlobTrieNode> potentialChildren = new ArrayList<GlobTrieNode>();
        for (LiteralNode literalNode : node.getChildrenWithLiteral()) {
            String suffix;
            if (literalNode.isNewLevel() || !remainingLevel.endsWith(suffix = literalNode.getContent())) continue;
            potentialChildren.add(literalNode);
        }
        block1: for (StarTrieNode starTrieNode : node.getChildrenWithStar()) {
            if (starTrieNode.isNewLevel()) continue;
            StarTrieNode tmpChild = starTrieNode;
            while (true) {
                GlobTrieNode potentialChild;
                String childContent;
                String childPrefix;
                int nextOccurrence;
                if ((nextOccurrence = remainingLevel.indexOf(childPrefix = (childContent = tmpChild.getContent()).substring(0, childContent.indexOf("*".charAt(0))))) != -1) {
                    potentialChildren.addAll(CompressedGlobTrie.matchOneLevel(tmpChild, remainingLevel.substring(nextOccurrence)));
                }
                if ((potentialChild = tmpChild.getChildFromSameLevel(tmpChild.getContent())) == null) continue block1;
                tmpChild = (StarTrieNode)potentialChild;
            }
        }
        return potentialChildren;
    }

    private static boolean simplePatternMatch(GlobTrieNode root, GlobTrieNode part) {
        if (root instanceof StarTrieNode || root instanceof DoubleStarNode || part instanceof StarTrieNode || part instanceof DoubleStarNode) {
            return false;
        }
        return root.getChild(part.getContent()) != null;
    }

    private static SquashedParts getThisLevel(List<GlobTrieNode> parts, int begin) {
        GlobTrieNode nextPart;
        StringBuilder sb = new StringBuilder(parts.get(begin).getContent());
        int numberOfSquashedParts = 0;
        for (int i = begin + 1; i < parts.size() && !(nextPart = parts.get(i)).isNewLevel(); ++i) {
            sb.append(nextPart.getContent());
            ++numberOfSquashedParts;
        }
        return new SquashedParts(sb.toString(), numberOfSquashedParts);
    }

    private static boolean patternReachedEnd(int index, List<GlobTrieNode> parts) {
        return index >= parts.size();
    }

    public static void removeNodes(GlobTrieNode head, Predicate<String> shouldRemove) {
        List<String> contentToRemove = head.getAdditionalContent().stream().filter(shouldRemove).toList();
        head.removeAdditionalContent(contentToRemove);
        ArrayList<GlobTrieNode> childrenToRemove = new ArrayList<GlobTrieNode>();
        for (GlobTrieNode child : head.getChildren()) {
            CompressedGlobTrie.removeNodes(child, shouldRemove);
            if (child.isLeaf() && child.getAdditionalContent().isEmpty()) {
                if (child.getChildren().isEmpty()) {
                    childrenToRemove.add(child);
                    continue;
                }
                child.makeNodeInternal();
                continue;
            }
            if (child.isLeaf() || !child.getChildren().isEmpty()) continue;
            childrenToRemove.add(child);
        }
        head.removeChildren(childrenToRemove);
    }

    private static enum StarCollectorMode {
        NORMAL,
        ESCAPE;

    }

    private record MatchedNode(GlobTrieNode child, int lastMatchedChildIndex) {
    }

    private record SquashedParts(String squashedPart, int numberOfSquashedParts) {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class CompressedGlobTrieBuilder {
        public static GlobTrieNode build(List<GlobWithInfo> patterns) {
            GlobTrieNode root = new GlobTrieNode();
            ArrayList<GlobWithInfo> doubleStarPatterns = new ArrayList<GlobWithInfo>();
            ArrayList<GlobWithInfo> starPatterns = new ArrayList<GlobWithInfo>();
            ArrayList<GlobWithInfo> noStarPatterns = new ArrayList<GlobWithInfo>();
            List<String> invalidPatterns = CompressedGlobTrieBuilder.classifyPatterns(patterns, doubleStarPatterns, starPatterns, noStarPatterns);
            if (!invalidPatterns.isEmpty()) {
                StringBuilder sb = new StringBuilder("Error: invalid glob patterns found:" + System.lineSeparator());
                invalidPatterns.forEach(msg -> sb.append((String)msg).append(System.lineSeparator()));
                throw UserError.abort(sb.toString(), new Object[0]);
            }
            doubleStarPatterns.sort(CompressedGlobTrieBuilder::comparePatterns);
            starPatterns.sort(CompressedGlobTrieBuilder::comparePatterns);
            doubleStarPatterns.forEach(pattern -> CompressedGlobTrieBuilder.addPattern(root, pattern));
            starPatterns.forEach(pattern -> CompressedGlobTrieBuilder.addPattern(root, pattern));
            noStarPatterns.forEach(pattern -> CompressedGlobTrieBuilder.addPattern(root, pattern));
            return root;
        }

        private static String unescapePossibleWildcards(String pattern) {
            String unescapedPattern = pattern;
            for (char esc : GlobUtils.ALWAYS_ESCAPED_GLOB_WILDCARDS) {
                unescapedPattern = unescapedPattern.replace("\\" + esc, String.valueOf(esc));
            }
            return unescapedPattern;
        }

        private static void addPattern(GlobTrieNode root, GlobWithInfo pattern) {
            String unescapedPattern = CompressedGlobTrieBuilder.unescapePossibleWildcards(pattern.pattern());
            List<GlobTrieNode> parts = CompressedGlobTrie.getPatternParts(unescapedPattern);
            ArrayList<GlobTrieNode> reachableNodes = new ArrayList<GlobTrieNode>();
            CompressedGlobTrie.getAllPatterns(root, parts, 0, reachableNodes);
            if (!reachableNodes.isEmpty()) {
                for (GlobTrieNode node : reachableNodes) {
                    if (!node.getAdditionalContent().stream().anyMatch(c -> c.equals(pattern.additionalContent()))) continue;
                    return;
                }
            }
            CompressedGlobTrieBuilder.addPattern(root, parts, 0, pattern.additionalContent());
        }

        private static void addPattern(GlobTrieNode root, List<GlobTrieNode> parts, int i, String additionalInfo) {
            if (CompressedGlobTrie.patternReachedEnd(i, parts)) {
                root.setLeaf();
                root.addAdditionalContent(additionalInfo);
                return;
            }
            GlobTrieNode nextPart = parts.get(i);
            boolean canProceed = CompressedGlobTrie.simplePatternMatch(root, nextPart);
            if (canProceed) {
                CompressedGlobTrieBuilder.addPattern(root.getChild(nextPart.getContent()), parts, i + 1, additionalInfo);
                return;
            }
            CompressedGlobTrieBuilder.addNewBranch(root, parts, i, additionalInfo);
        }

        private static void addNewBranch(GlobTrieNode root, List<GlobTrieNode> parts, int i, String additionalInfo) {
            if (parts.isEmpty() || i >= parts.size()) {
                return;
            }
            GlobTrieNode newNode = null;
            for (int j = i; j < parts.size(); ++j) {
                GlobTrieNode part = parts.get(j);
                newNode = newNode == null ? root.addChild(part.getContent(), part) : newNode.addChild(part.getContent(), part);
            }
            newNode.setLeaf();
            newNode.addAdditionalContent(additionalInfo);
        }

        private static List<String> classifyPatterns(List<GlobWithInfo> patterns, List<GlobWithInfo> doubleStar, List<GlobWithInfo> singleStar, List<GlobWithInfo> noStar) {
            ArrayList<String> invalidPatterns = new ArrayList<String>();
            for (GlobWithInfo patternWithInfo : patterns) {
                String error = CompressedGlobTrie.validatePattern(patternWithInfo.pattern());
                if (!error.isEmpty()) {
                    invalidPatterns.add(error);
                    continue;
                }
                String pattern = patternWithInfo.pattern();
                if (pattern.indexOf("**") != -1) {
                    doubleStar.add(patternWithInfo);
                    continue;
                }
                if (pattern.indexOf("*".charAt(0)) != -1) {
                    singleStar.add(patternWithInfo);
                    continue;
                }
                noStar.add(patternWithInfo);
            }
            return invalidPatterns;
        }

        private static int comparePatterns(GlobWithInfo n1, GlobWithInfo n2) {
            String s1 = n1.pattern();
            String s2 = n2.pattern();
            List<String> s1Levels = Arrays.stream(s1.split("/")).toList();
            List<String> s2Levels = Arrays.stream(s2.split("/")).toList();
            int i = 0;
            while (i < s1Levels.size() && i < s2Levels.size()) {
                String s1Level = s1Levels.get(i);
                String s2Level = s2Levels.get(i);
                int s1DoubleStar = s1Level.indexOf("**");
                int s2DoubleStar = s2Level.indexOf("**");
                if (s1DoubleStar != -1 || s2DoubleStar != -1) {
                    if (s1DoubleStar == -1) {
                        return 1;
                    }
                    if (s2DoubleStar == -1) {
                        return -1;
                    }
                    ++i;
                    continue;
                }
                int s1Star = s1Level.indexOf("*".charAt(0));
                int s2Star = s2Level.indexOf("*".charAt(0));
                if (s1Star != -1 && s2Star != -1) {
                    int len2;
                    int len1Stars = StringUtil.numberOfCharsInString((char)"*".charAt(0), (String)s1Level);
                    int len2Stars = StringUtil.numberOfCharsInString((char)"*".charAt(0), (String)s2Level);
                    int len1 = s1Level.length() - len1Stars;
                    if (len1 == (len2 = s2Level.length() - len2Stars)) {
                        if (len1Stars != len2Stars) {
                            return len2Stars - len1Stars;
                        }
                        if (s1Level.equals(s2Level)) {
                            ++i;
                            continue;
                        }
                        return s1Levels.size() - s2Levels.size();
                    }
                    return len1 - len2;
                }
                if (s1Star == -1 && s2Star == -1) {
                    if (s1Level.compareTo(s2Level) == 0) {
                        ++i;
                        continue;
                    }
                    return s1Levels.size() - s2Levels.size();
                }
                return s1Star == -1 ? 1 : -1;
            }
            return s1Levels.size() - s2Levels.size();
        }
    }

    public record GlobWithInfo(String pattern, String additionalContent) {
    }
}

