/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.imagelayer;

import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import java.util.EnumSet;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class ImageLayerBuildingSupport
implements UnsavedSingleton {
    protected final boolean buildingImageLayer;
    private final boolean buildingInitialLayer;
    private final boolean buildingApplicationLayer;

    protected ImageLayerBuildingSupport(boolean buildingImageLayer, boolean buildingInitialLayer, boolean buildingApplicationLayer) {
        this.buildingImageLayer = buildingImageLayer;
        this.buildingInitialLayer = buildingInitialLayer;
        this.buildingApplicationLayer = buildingApplicationLayer;
    }

    private static ImageLayerBuildingSupport singleton() {
        return (ImageLayerBuildingSupport)ImageSingletons.lookup(ImageLayerBuildingSupport.class);
    }

    @Fold
    public static boolean buildingImageLayer() {
        return ImageLayerBuildingSupport.singleton().buildingImageLayer;
    }

    @Fold
    public static boolean buildingInitialLayer() {
        return ImageLayerBuildingSupport.singleton().buildingInitialLayer;
    }

    @Fold
    public static boolean buildingApplicationLayer() {
        return ImageLayerBuildingSupport.singleton().buildingApplicationLayer;
    }

    @Fold
    public static boolean buildingExtensionLayer() {
        return ImageLayerBuildingSupport.singleton().buildingImageLayer && !ImageLayerBuildingSupport.singleton().buildingInitialLayer;
    }

    @Fold
    public static boolean buildingSharedLayer() {
        return ImageLayerBuildingSupport.singleton().buildingImageLayer && !ImageLayerBuildingSupport.singleton().buildingApplicationLayer;
    }

    @Override
    public final EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS_ALLOW_FOLDING;
    }
}

