/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.meta.SharedMethod;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.common.LoopSafepointInsertionPhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public class SubstrateSafepointInsertionPhase
extends LoopSafepointInsertionPhase {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean needSafepointCheck(ResolvedJavaMethod method) {
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method)) {
            return false;
        }
        return !AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, CFunction.class) && !AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, InvokeCFunctionPointer.class);
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        SharedMethod method = (SharedMethod)graph.method();
        if (!method.needSafepointCheck()) {
            return;
        }
        if (!((SubstrateBackend)context.getTargetProvider()).safepointCheckedInEpilogue(method)) {
            for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
                SafepointNode safepointNode = (SafepointNode)graph.add((Node)new SafepointNode());
                graph.addBeforeFixed((FixedNode)returnNode, (FixedWithNextNode)safepointNode);
            }
        }
        super.run(graph, context);
    }
}

