/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.meta.SharedMethod;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.Phase;

public class RemoveUnwindPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        if (method.isDeoptTarget()) {
            return;
        }
        ArrayList<WithExceptionNode> withExceptionNodes = new ArrayList<WithExceptionNode>();
        ArrayList<BytecodeExceptionNode> bytecodeExceptionNodes = new ArrayList<BytecodeExceptionNode>();
        for (UnwindNode unwindNode : graph.getNodes(UnwindNode.TYPE)) {
            RemoveUnwindPhase.walkBack(unwindNode.predecessor(), (Node)unwindNode, GraphUtil.unproxify((ValueNode)unwindNode.exception()), withExceptionNodes, bytecodeExceptionNodes);
        }
        for (WithExceptionNode withExceptionNode : withExceptionNodes) {
            if (!withExceptionNode.isAlive()) continue;
            graph.getDebug().log(4, "Removing exception edge for: %s", (Object)withExceptionNode);
            withExceptionNode.replaceWithNonThrowing();
        }
        for (BytecodeExceptionNode bytecodeExceptionNode : bytecodeExceptionNodes) {
            if (!bytecodeExceptionNode.isAlive()) continue;
            graph.getDebug().log(4, "Converting a BytecodeException node to a ThrowBytecodeException node for: %s", (Object)bytecodeExceptionNode);
            RemoveUnwindPhase.convertToThrow(bytecodeExceptionNode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void walkBack(Node initialNode, Node initialSuccessor, ValueNode initialExpectedException, List<WithExceptionNode> withExceptionNodes, List<BytecodeExceptionNode> bytecodeExceptionNodes) {
        Node current = initialNode;
        Node successor = initialSuccessor;
        ValueNode expectedException = initialExpectedException;
        ArrayList<WorklistEntry> worklist = new ArrayList<WorklistEntry>();
        while (true) {
            if (current instanceof WithExceptionNode) {
                WithExceptionNode node = (WithExceptionNode)current;
                if (node.exceptionEdge() == successor) {
                    withExceptionNodes.add(node);
                }
            } else if (current instanceof BytecodeExceptionNode || current instanceof ExceptionObjectNode) {
                if (current == expectedException) {
                    if (current instanceof BytecodeExceptionNode) {
                        BytecodeExceptionNode node = (BytecodeExceptionNode)current;
                        bytecodeExceptionNodes.add(node);
                    } else {
                        successor = current;
                        current = current.predecessor();
                        continue;
                    }
                }
            } else if (current instanceof MergeNode) {
                MergeNode merge = (MergeNode)current;
                if (merge.isPhiAtMerge((Node)expectedException)) {
                    PhiNode expectedExceptionForInput = (PhiNode)expectedException;
                    for (int input = 0; input < merge.forwardEndCount(); ++input) {
                        EndNode predecessor = merge.forwardEndAt(input);
                        worklist.add(new WorklistEntry((Node)predecessor, (Node)merge, GraphUtil.unproxify((ValueNode)expectedExceptionForInput.valueAt(input))));
                    }
                } else {
                    for (ValueNode predecessor : merge.cfgPredecessors()) {
                        worklist.add(new WorklistEntry((Node)predecessor, (Node)merge, expectedException));
                    }
                }
            } else if (current instanceof AbstractBeginNode || current instanceof AbstractEndNode) {
                successor = current;
                current = current.predecessor();
                continue;
            }
            if (worklist.isEmpty()) {
                return;
            }
            WorklistEntry entry = (WorklistEntry)worklist.removeLast();
            current = entry.current;
            successor = entry.successor;
            expectedException = entry.expectedException;
        }
    }

    private static void convertToThrow(BytecodeExceptionNode bytecodeExceptionNode) {
        StructuredGraph graph = bytecodeExceptionNode.graph();
        ThrowBytecodeExceptionNode throwNode = (ThrowBytecodeExceptionNode)graph.add((Node)new ThrowBytecodeExceptionNode(bytecodeExceptionNode.getExceptionKind(), (List<ValueNode>)bytecodeExceptionNode.getArguments()));
        throwNode.setStateBefore(bytecodeExceptionNode.createStateDuring());
        throwNode.setNodeSourcePosition(bytecodeExceptionNode.getNodeSourcePosition());
        FixedWithNextNode predecessor = (FixedWithNextNode)bytecodeExceptionNode.predecessor();
        GraphUtil.killCFG((FixedNode)bytecodeExceptionNode);
        assert (predecessor.next() == null) : "must be killed now";
        predecessor.setNext((FixedNode)throwNode);
    }

    private record WorklistEntry(Node current, Node successor, ValueNode expectedException) {
    }
}

