/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="XPAC")
class AArch64XPACOp
extends AArch64LIRInstruction {
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue input;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue result;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue lrValue;
    public static final LIRInstructionClass<AArch64XPACOp> TYPE = LIRInstructionClass.create(AArch64XPACOp.class);

    AArch64XPACOp(AllocatableValue input, AllocatableValue result) {
        super(TYPE);
        this.input = input;
        this.result = result;
        this.lrValue = AArch64.lr.asValue();
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (this.result.getPlatformKind().equals((Object)AArch64Kind.QWORD));
        assert (this.input.getPlatformKind().equals((Object)AArch64Kind.QWORD));
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        Register lr = ValueUtil.asRegister((Value)this.lrValue);
        assert (lr.equals((Object)AArch64.lr));
        masm.mov(64, lr, src);
        masm.xpaclri();
        masm.mov(64, dst, lr);
    }
}

