/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.lir;

import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import java.util.List;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.site.Infopoint;

public final class DeoptEntryOp
extends LIRInstruction {
    public static final LIRInstructionClass<DeoptEntryOp> TYPE = LIRInstructionClass.create(DeoptEntryOp.class);
    @LIRInstruction.State
    protected LIRFrameState state;

    public DeoptEntryOp(LIRFrameState state) {
        super(TYPE);
        this.state = state;
    }

    public void emitCode(CompilationResultBuilder crb) {
        CompilationResult compilation = crb.compilationResult;
        List infoPoints = compilation.getInfopoints();
        int size = infoPoints.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            Infopoint infopoint = (Infopoint)infoPoints.get(idx);
            int entryOffset = CodeInfoEncoder.getEntryOffset(infopoint);
            if (entryOffset < 0 || entryOffset != crb.asm.position()) continue;
            crb.asm.ensureUniquePC();
            break;
        }
        int position = crb.asm.position();
        compilation.addInfopoint((Infopoint)new DeoptEntryInfopoint(position, this.state.debugInfo()));
        crb.recordExceptionHandlers(position, this.state);
        if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
            int initialPos = crb.asm.position();
            crb.asm.maybeEmitIndirectTargetMarker();
            assert (initialPos != crb.asm.position()) : "No target marker emitted. Position: " + initialPos;
        } else {
            crb.asm.ensureUniquePC();
        }
    }

    public boolean destroysCallerSavedRegisters() {
        return true;
    }
}

