/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.compacting.ObjectRefFixupVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;

public final class ObjectFixupVisitor
implements ObjectVisitor {
    private final ObjectRefFixupVisitor refFixupVisitor;

    public ObjectFixupVisitor(ObjectRefFixupVisitor refFixupVisitor) {
        this.refFixupVisitor = refFixupVisitor;
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean visitObjectInline(Object obj) {
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)hub.isReferenceInstanceClass())) {
            Reference dr = (Reference)obj;
            this.refFixupVisitor.visitObjectReferenceInline(ReferenceInternals.getReferentFieldAddress(dr), 0, true, dr);
        }
        InteriorObjRefWalker.walkObjectInline(obj, this.refFixupVisitor);
        return true;
    }

    @Override
    public boolean visitObject(Object o) {
        throw VMError.shouldNotReachHere("for performance reasons");
    }
}

