/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapPartition;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HostedImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.RuntimeImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.util.List;
import jdk.graal.compiler.core.common.NumUtil;
import org.graalvm.word.UnsignedWord;

public class ChunkedImageHeapLayouter
implements ImageHeapLayouter {
    private static final int READ_ONLY_REGULAR = 0;
    private static final int READ_ONLY_RELOCATABLE = 1;
    private static final int WRITABLE_REGULAR = 2;
    private static final int WRITABLE_HUGE = 3;
    private static final int READ_ONLY_HUGE = 4;
    private static final int PARTITION_COUNT = 5;
    private final ChunkedImageHeapPartition[] partitions;
    private final ImageHeapInfo heapInfo;
    private final long startOffset;
    private final long hugeObjectThreshold;
    private ChunkedImageHeapAllocator allocator;

    public ChunkedImageHeapLayouter(ImageHeapInfo heapInfo, long startOffset) {
        int alignment = ConfigurationValues.getObjectLayout().getAlignment();
        this.partitions = new ChunkedImageHeapPartition[5];
        this.partitions[0] = new ChunkedImageHeapPartition("readOnly", false, false, alignment, alignment);
        this.partitions[1] = new ChunkedImageHeapPartition("readOnlyRelocatable", false, false, alignment, alignment);
        this.partitions[2] = new ChunkedImageHeapPartition("writable", true, false, alignment, alignment);
        this.partitions[3] = new ChunkedImageHeapPartition("writableHuge", true, true, alignment, alignment);
        this.partitions[4] = new ChunkedImageHeapPartition("readOnlyHuge", false, true, alignment, SubstrateOptions.getPageSize());
        this.heapInfo = heapInfo;
        this.startOffset = startOffset;
        UnsignedWord alignedHeaderSize = RememberedSet.get().getHeaderSizeOfAlignedChunk();
        UnsignedWord unalignedHeaderSize = RememberedSet.get().getHeaderSizeOfUnalignedChunk();
        UnsignedWord hugeThreshold = HeapParameters.getAlignedHeapChunkSize().subtract(alignedHeaderSize);
        if (unalignedHeaderSize.belowThan(alignedHeaderSize)) {
            hugeThreshold = hugeThreshold.unsignedDivide(2);
        }
        this.hugeObjectThreshold = hugeThreshold.rawValue();
    }

    public ChunkedImageHeapPartition[] getPartitions() {
        return this.partitions;
    }

    @Override
    public void assignObjectToPartition(ImageHeapObject info, boolean immutable, boolean references, boolean relocatable) {
        ChunkedImageHeapPartition partition = this.choosePartition(info, immutable, relocatable);
        info.setHeapPartition(partition);
        partition.assign(info);
    }

    private ChunkedImageHeapPartition choosePartition(ImageHeapObject info, boolean immutable, boolean hasRelocatables) {
        if (immutable) {
            if (hasRelocatables) {
                VMError.guarantee(info.getSize() < this.hugeObjectThreshold, "Objects with relocatable pointers cannot be huge objects");
                return this.getReadOnlyRelocatable();
            }
            if (info.getSize() >= this.hugeObjectThreshold) {
                VMError.guarantee(info.getObjectClass() != DynamicHub.class, "Class metadata (dynamic hubs) cannot be huge objects");
                return this.getReadOnlyHuge();
            }
            return this.getReadOnlyRegular();
        }
        assert (info.getObjectClass() != DynamicHub.class) : "Class metadata (dynamic hubs) cannot be writable";
        if (info.getSize() >= this.hugeObjectThreshold) {
            return this.getWritableHuge();
        }
        return this.getWritableRegular();
    }

    @Override
    public ImageHeapLayoutInfo layout(ImageHeap imageHeap, int pageSize) {
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        assert (pageSize % objectAlignment == 0) : "Page size does not match object alignment";
        ImageHeapLayoutInfo layoutInfo = this.doLayout(imageHeap, pageSize);
        for (ChunkedImageHeapPartition partition : this.getPartitions()) {
            assert (partition.getStartOffset() % (long)partition.getStartAlignment() == 0L) : partition;
            assert ((partition.getStartOffset() + partition.getSize()) % (long)partition.getEndAlignment() == 0L) : partition;
        }
        assert (layoutInfo.getImageHeapSize() % (long)pageSize == 0L) : "Image heap size is not a multiple of page size";
        return layoutInfo;
    }

    private ImageHeapLayoutInfo doLayout(ImageHeap imageHeap, int pageSize) {
        this.allocator = new ChunkedImageHeapAllocator(imageHeap, this.startOffset);
        for (ChunkedImageHeapPartition partition : this.getPartitions()) {
            partition.layout(this.allocator);
        }
        return this.populateInfoObjects(imageHeap.countDynamicHubs(), pageSize);
    }

    private ImageHeapLayoutInfo populateInfoObjects(int dynamicHubCount, int pageSize) {
        long offsetOfFirstWritableAlignedChunk = -1L;
        for (ChunkedImageHeapAllocator.AlignedChunk chunk : this.allocator.getAlignedChunks()) {
            if (!chunk.isWritable()) continue;
            offsetOfFirstWritableAlignedChunk = chunk.getBegin();
            break;
        }
        VMError.guarantee(offsetOfFirstWritableAlignedChunk >= 0L && offsetOfFirstWritableAlignedChunk % (long)pageSize == 0L, "Start of the writable part is assumed to be page-aligned");
        long offsetOfFirstWritableUnalignedChunk = -1L;
        long offsetOfLastWritableUnalignedChunk = -1L;
        for (ChunkedImageHeapAllocator.UnalignedChunk chunk : this.allocator.getUnalignedChunks()) {
            if (!chunk.isWritable()) break;
            if (offsetOfFirstWritableUnalignedChunk == -1L) {
                offsetOfFirstWritableUnalignedChunk = chunk.getBegin();
            }
            offsetOfLastWritableUnalignedChunk = chunk.getBegin();
        }
        this.heapInfo.initialize(this.getReadOnlyRegular().firstObject, this.getReadOnlyRegular().lastObject, this.getReadOnlyRelocatable().firstObject, this.getReadOnlyRelocatable().lastObject, this.getWritableRegular().firstObject, this.getWritableRegular().lastObject, this.getWritableHuge().firstObject, this.getWritableHuge().lastObject, this.getReadOnlyHuge().firstObject, this.getReadOnlyHuge().lastObject, offsetOfFirstWritableAlignedChunk, offsetOfFirstWritableUnalignedChunk, offsetOfLastWritableUnalignedChunk, dynamicHubCount);
        long writableEnd = this.getWritableHuge().getStartOffset() + this.getWritableHuge().getSize();
        long writableSize = writableEnd - offsetOfFirstWritableAlignedChunk;
        long imageHeapSize = this.getReadOnlyHuge().getStartOffset() + this.getReadOnlyHuge().getSize() - this.startOffset;
        return new ImageHeapLayoutInfo(this.startOffset, offsetOfFirstWritableAlignedChunk, writableSize, this.getReadOnlyRelocatable().getStartOffset(), this.getReadOnlyRelocatable().getSize(), imageHeapSize);
    }

    @Override
    public void writeMetadata(ByteBuffer imageHeapBytes, long imageHeapOffsetInBuffer) {
        long layoutToBufferOffsetAddend = imageHeapOffsetInBuffer - this.startOffset;
        ImageHeapChunkWriter writer = SubstrateUtil.HOSTED ? new HostedImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend) : new RuntimeImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend);
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getAlignedChunks());
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getUnalignedChunks());
    }

    private static void writeHeaders(ImageHeapChunkWriter writer, List<? extends ChunkedImageHeapAllocator.Chunk> chunks) {
        ChunkedImageHeapAllocator.Chunk previous = null;
        ChunkedImageHeapAllocator.Chunk current = null;
        for (ChunkedImageHeapAllocator.Chunk chunk : chunks) {
            ChunkedImageHeapLayouter.writeHeader(writer, previous, current, chunk);
            previous = current;
            current = chunk;
        }
        ChunkedImageHeapLayouter.writeHeader(writer, previous, current, null);
    }

    private static void writeHeader(ImageHeapChunkWriter writer, ChunkedImageHeapAllocator.Chunk previous, ChunkedImageHeapAllocator.Chunk current, ChunkedImageHeapAllocator.Chunk next) {
        if (current != null) {
            long offsetToPrevious = previous != null ? previous.getBegin() - current.getBegin() : 0L;
            long offsetToNext = next != null ? next.getBegin() - current.getBegin() : 0L;
            int chunkPosition = NumUtil.safeToInt((long)current.getBegin());
            if (current instanceof ChunkedImageHeapAllocator.AlignedChunk) {
                ChunkedImageHeapAllocator.AlignedChunk aligned = (ChunkedImageHeapAllocator.AlignedChunk)current;
                writer.initializeAlignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForAlignedChunk(chunkPosition, aligned.getObjects());
            } else {
                assert (current instanceof ChunkedImageHeapAllocator.UnalignedChunk);
                writer.initializeUnalignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForUnalignedChunk(chunkPosition);
            }
        }
    }

    private ChunkedImageHeapPartition getReadOnlyRegular() {
        return this.partitions[0];
    }

    private ChunkedImageHeapPartition getReadOnlyRelocatable() {
        return this.partitions[1];
    }

    private ChunkedImageHeapPartition getWritableRegular() {
        return this.partitions[2];
    }

    private ChunkedImageHeapPartition getWritableHuge() {
        return this.partitions[3];
    }

    private ChunkedImageHeapPartition getReadOnlyHuge() {
        return this.partitions[4];
    }
}

