/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class RuntimeConditionSet {
    private Object[] conditions;
    private boolean satisfied;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static RuntimeConditionSet emptySet() {
        return new RuntimeConditionSet(new Object[0]);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static RuntimeConditionSet createHosted(ConfigurationCondition condition) {
        RuntimeConditionSet conditionSet = new RuntimeConditionSet(new Object[0]);
        conditionSet.addCondition(condition);
        return conditionSet;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void addCondition(ConfigurationCondition cnd) {
        VMError.guarantee(cnd.isRuntimeChecked(), "Only runtime conditions can be added to the ConditionalRuntimeValue.");
        if (this.satisfied) {
            return;
        }
        if (cnd.isAlwaysTrue()) {
            this.conditions = null;
            this.satisfied = true;
            return;
        }
        Object newRuntimeCondition = RuntimeConditionSet.createRuntimeCondition(cnd);
        HashSet<Object> existingConditions = this.conditions == null ? new HashSet<Object>() : new HashSet<Object>(Arrays.asList(this.conditions));
        existingConditions.add(newRuntimeCondition);
        this.setConditions(existingConditions.toArray());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Set<Class<?>> getTypesForEncoding() {
        if (this.conditions == null) {
            return Set.of();
        }
        HashSet types = new HashSet();
        for (Object condition : this.conditions) {
            types.addAll(RuntimeConditionSet.getTypesForEncoding(condition));
        }
        return types;
    }

    public static RuntimeConditionSet unmodifiableEmptySet() {
        return UnmodifiableRuntimeConditionSet.UNMODIFIABLE_EMPTY_SET;
    }

    public static RuntimeConditionSet createDecoded(Object[] conditions) {
        return new RuntimeConditionSet(conditions);
    }

    public boolean satisfied() {
        boolean result = false;
        if (this.satisfied) {
            result = true;
        } else {
            Object[] localConditions = this.conditions;
            if (localConditions == null) {
                result = true;
            } else {
                for (Object condition : localConditions) {
                    if (!RuntimeConditionSet.isSatisfied(condition)) continue;
                    this.conditions = null;
                    result = true;
                    this.satisfied = true;
                    break;
                }
            }
        }
        if (ConfigurationFiles.Options.TrackUnsatisfiedTypeReachedConditions.getValue().booleanValue() && !result) {
            LogUtils.info((String)("Unsatisfied runtime conditions reachable at build-time: " + Arrays.toString(this.conditions)));
            new Exception().printStackTrace(System.out);
            return true;
        }
        return result;
    }

    public String toString() {
        String conditionsString = this.conditions == null ? "[]" : Arrays.toString(this.conditions);
        return conditionsString + " = " + this.satisfied;
    }

    private RuntimeConditionSet(Object[] conditions) {
        this.setConditions(conditions);
    }

    private void setConditions(Object[] conditions) {
        this.conditions = conditions.length == 0 ? null : conditions;
        this.satisfied = false;
    }

    private static Object createRuntimeCondition(ConfigurationCondition cnd) {
        if (cnd.isAlwaysTrue() || !cnd.isRuntimeChecked()) {
            throw VMError.shouldNotReachHere("We should never create run-time conditions from conditions that are always true at build time. Condition: " + String.valueOf(cnd));
        }
        return cnd.getType();
    }

    private static boolean isSatisfied(Object condition) {
        if (condition instanceof Class) {
            Class typeReachedCondition = (Class)condition;
            return DynamicHub.fromClass(typeReachedCondition).isReached();
        }
        throw VMError.shouldNotReachHere("Only typeReached condition is supported.");
    }

    private static Set<Class<?>> getTypesForEncoding(Object condition) {
        if (condition instanceof Class) {
            Class res = (Class)condition;
            return Set.of(res);
        }
        throw VMError.shouldNotReachHere("Only typeReached condition is supported.");
    }

    public static final class UnmodifiableRuntimeConditionSet
    extends RuntimeConditionSet {
        private static final RuntimeConditionSet UNMODIFIABLE_EMPTY_SET = new UnmodifiableRuntimeConditionSet(new Object[0]);

        private UnmodifiableRuntimeConditionSet(Object[] conditions) {
            super(conditions);
        }

        @Override
        public synchronized void addCondition(ConfigurationCondition cnd) {
            throw new UnsupportedOperationException("Can't add conditions to an unmodifiable set of conditions.");
        }
    }
}

