/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.graal.compiler.util.json.JsonParser;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public abstract class ConfigurationParser {
    public static final String CONDITIONAL_KEY = "condition";
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String PROXY_KEY = "proxy";
    public static final String REFLECTION_KEY = "reflection";
    public static final String JNI_KEY = "jni";
    public static final String SERIALIZATION_KEY = "serialization";
    public static final String RESOURCES_KEY = "resources";
    public static final String BUNDLES_KEY = "bundles";
    public static final String GLOBS_KEY = "globs";
    public static final String MODULE_KEY = "module";
    public static final String GLOB_KEY = "glob";
    private final Map<String, Set<String>> seenUnknownAttributesByType = new HashMap<String, Set<String>>();
    private final boolean strictSchema;

    public static InputStream openStream(URI uri) throws IOException {
        URL url = uri.toURL();
        if ("file".equals(url.getProtocol()) || "jar".equalsIgnoreCase(url.getProtocol()) || !SubstrateUtil.HOSTED && "resource".equals(url.getProtocol())) {
            return url.openStream();
        }
        throw VMError.shouldNotReachHere("For security reasons, reading configurations is not supported from URIs with protocol: " + url.getProtocol());
    }

    protected ConfigurationParser(boolean strictConfiguration) {
        this.strictSchema = strictConfiguration;
    }

    public void parseAndRegister(URI uri) throws IOException {
        try (BufferedReader reader = ConfigurationParser.openReader(uri);){
            this.parseAndRegister(new JsonParser((Reader)reader).parse(), uri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected static BufferedReader openReader(URI uri) throws IOException {
        return new BufferedReader(new InputStreamReader(ConfigurationParser.openStream(uri)));
    }

    public void parseAndRegister(Reader reader) throws IOException {
        this.parseAndRegister(new JsonParser(reader).parse(), null);
    }

    public abstract void parseAndRegister(Object var1, URI var2) throws IOException;

    public Object getFromGlobalFile(Object json, String key) {
        EconomicMap<String, Object> map = ConfigurationParser.asMap(json, "top level of reachability metadata file must be an object");
        this.checkAttributes(map, "reachability metadata", Collections.emptyList(), List.of(REFLECTION_KEY, JNI_KEY, SERIALIZATION_KEY, RESOURCES_KEY, BUNDLES_KEY, "reason", "comment"));
        return map.get((Object)key);
    }

    public static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JsonParserException(errorMessage);
    }

    public static EconomicMap<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof EconomicMap) {
            return (EconomicMap)data;
        }
        throw new JsonParserException(errorMessage);
    }

    protected void checkAttributes(EconomicMap<String, Object> map, String type, Collection<String> requiredAttrs, Collection<String> optionalAttrs) {
        HashSet<String> unseenRequired = new HashSet<String>(requiredAttrs);
        for (Object key2 : map.getKeys()) {
            unseenRequired.remove(key2);
        }
        if (!unseenRequired.isEmpty()) {
            throw new JsonParserException("Missing attribute(s) [" + String.join((CharSequence)", ", unseenRequired) + "] in " + type);
        }
        HashSet<String> unknownAttributes = new HashSet<String>();
        for (String key3 : map.getKeys()) {
            unknownAttributes.add(key3);
        }
        unknownAttributes.removeAll(requiredAttrs);
        unknownAttributes.removeAll(optionalAttrs);
        if (this.seenUnknownAttributesByType.containsKey(type)) {
            unknownAttributes.removeAll((Collection)this.seenUnknownAttributesByType.get(type));
        }
        if (unknownAttributes.size() > 0) {
            String message = "Unknown attribute(s) [" + String.join((CharSequence)", ", unknownAttributes) + "] in " + type;
            this.warnOrFailOnSchemaError(message);
            Set unknownAttributesForType = this.seenUnknownAttributesByType.computeIfAbsent(type, key -> new HashSet());
            unknownAttributesForType.addAll(unknownAttributes);
        }
    }

    public static void checkHasExactlyOneAttribute(EconomicMap<String, Object> map, String type, Collection<String> alternativeAttributes) {
        boolean attributeFound = false;
        for (String key : map.getKeys()) {
            if (!alternativeAttributes.contains(key)) continue;
            if (attributeFound) {
                String message = "Exactly one of [" + String.join((CharSequence)", ", alternativeAttributes) + "] must be set in " + type;
                throw new JsonParserException(message);
            }
            attributeFound = true;
        }
        if (!attributeFound) {
            String message = "Exactly one of [" + String.join((CharSequence)", ", alternativeAttributes) + "] must be set in " + type;
            throw new JsonParserException(message);
        }
    }

    protected void warnOrFailOnSchemaError(String message) {
        if (this.strictSchema) {
            ConfigurationParser.failOnSchemaError(message);
        } else {
            LogUtils.warning((String)message);
        }
    }

    protected void checkAttributes(EconomicMap<String, Object> map, String type, Collection<String> requiredAttrs) {
        this.checkAttributes(map, type, requiredAttrs, Collections.emptyList());
    }

    public static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JsonParserException("Invalid string value \"" + String.valueOf(value) + "\".");
    }

    protected static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JsonParserException("Invalid string value \"" + String.valueOf(value) + "\" for element '" + propertyName + "'");
    }

    protected static String asNullableString(Object value, String propertyName) {
        return value == null ? null : ConfigurationParser.asString(value, propertyName);
    }

    protected static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JsonParserException("Invalid boolean value '" + String.valueOf(value) + "' for element '" + propertyName + "'");
    }

    protected static long asLong(Object value, String propertyName) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new JsonParserException("Invalid long value '" + String.valueOf(value) + "' for element '" + propertyName + "'");
    }

    protected UnresolvedConfigurationCondition parseCondition(EconomicMap<String, Object> data, boolean runtimeCondition) {
        Object conditionData = data.get((Object)CONDITIONAL_KEY);
        if (conditionData != null) {
            EconomicMap<String, Object> conditionObject = ConfigurationParser.asMap(conditionData, "Attribute 'condition' must be an object");
            if (conditionObject.containsKey((Object)"typeReachable") && conditionObject.containsKey((Object)"typeReached")) {
                ConfigurationParser.failOnSchemaError("condition can not have both 'typeReached' and 'typeReachable' set.");
            }
            if (conditionObject.containsKey((Object)"typeReached")) {
                Object object;
                Optional<ConfigurationTypeDescriptor> condition;
                if (!runtimeCondition) {
                    ConfigurationParser.failOnSchemaError("'typeReached' condition cannot be used in older schemas. Please migrate the file to the latest schema.");
                }
                if ((condition = ConfigurationParser.parseTypeContents(object = conditionObject.get((Object)"typeReached"))).isPresent()) {
                    String className = ((NamedConfigurationTypeDescriptor)condition.get()).name();
                    return UnresolvedConfigurationCondition.create((String)className, (boolean)true);
                }
            } else if (conditionObject.containsKey((Object)"typeReachable")) {
                Object object;
                Optional<ConfigurationTypeDescriptor> condition;
                if (runtimeCondition && !ConfigurationFiles.Options.TreatAllTypeReachableConditionsAsTypeReached.getValue().booleanValue()) {
                    ConfigurationParser.failOnSchemaError("'typeReachable' condition can not be used with the latest schema. Please use 'typeReached'.");
                }
                if ((condition = ConfigurationParser.parseTypeContents(object = conditionObject.get((Object)"typeReachable"))).isPresent()) {
                    String className = ((NamedConfigurationTypeDescriptor)condition.get()).name();
                    return UnresolvedConfigurationCondition.create((String)className, (boolean)ConfigurationFiles.Options.TreatAllTypeReachableConditionsAsTypeReached.getValue());
                }
            }
        }
        return UnresolvedConfigurationCondition.alwaysTrue();
    }

    private static JsonParserException failOnSchemaError(String message) {
        throw new JsonParserException(message);
    }

    protected static Optional<TypeDescriptorWithOrigin> parseName(EconomicMap<String, Object> data, boolean treatAllNameEntriesAsType) {
        Object name = data.get((Object)NAME_KEY);
        if (name != null) {
            NamedConfigurationTypeDescriptor typeDescriptor = new NamedConfigurationTypeDescriptor(ConfigurationParser.asString(name));
            return Optional.of(new TypeDescriptorWithOrigin(typeDescriptor, treatAllNameEntriesAsType));
        }
        throw ConfigurationParser.failOnSchemaError("must have type or name specified for an element");
    }

    protected static Optional<ConfigurationTypeDescriptor> parseTypeContents(Object typeObject) {
        if (typeObject instanceof String) {
            String stringValue = (String)typeObject;
            return Optional.of(new NamedConfigurationTypeDescriptor(stringValue));
        }
        EconomicMap<String, Object> type = ConfigurationParser.asMap(typeObject, "type descriptor should be a string or object");
        if (type.containsKey((Object)PROXY_KEY)) {
            ConfigurationParser.checkHasExactlyOneAttribute(type, "type descriptor object", Set.of(PROXY_KEY));
            return Optional.of(ConfigurationParser.getProxyDescriptor(type.get((Object)PROXY_KEY)));
        }
        return Optional.empty();
    }

    private static ProxyConfigurationTypeDescriptor getProxyDescriptor(Object proxyObject) {
        List<Object> proxyInterfaces = ConfigurationParser.asList(proxyObject, "proxy interface content should be an interface list");
        List<String> proxyInterfaceNames = proxyInterfaces.stream().map(obj -> ConfigurationParser.asString(obj, PROXY_KEY)).toList();
        return new ProxyConfigurationTypeDescriptor(proxyInterfaceNames);
    }

    protected record TypeDescriptorWithOrigin(ConfigurationTypeDescriptor typeDescriptor, boolean definedAsType) {
    }
}

