/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.debug.Assertions;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;

public final class VTableBuilder {
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;

    private VTableBuilder(HostedUniverse hUniverse, HostedMetaAccess hMetaAccess) {
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
    }

    public static void buildTables(HostedUniverse hUniverse, HostedMetaAccess hMetaAccess) {
        VTableBuilder builder = new VTableBuilder(hUniverse, hMetaAccess);
        if (SubstrateOptions.closedTypeWorld()) {
            builder.buildClosedTypeWorldVTables();
        } else {
            builder.buildOpenTypeWorldDispatchTables();
            assert (builder.verifyOpenTypeWorldDispatchTables());
        }
    }

    private boolean verifyOpenTypeWorldDispatchTables() {
        HostedMethod invalidVTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isInterface() || type.isAbstract()) continue;
            for (int i = 0; i < type.openTypeWorldDispatchTables.length; ++i) {
                HostedMethod method = type.openTypeWorldDispatchTables[i];
                if (method.equals(invalidVTableEntryHandler)) continue;
                if (method.getDeclaringClass().isInterface()) {
                    int interfaceTypeID = method.getDeclaringClass().getTypeID();
                    int[] typeCheckSlots = type.getOpenTypeWorldTypeCheckSlots();
                    boolean found = false;
                    for (int itableIdx = 0; itableIdx < type.getNumInterfaceTypes(); ++itableIdx) {
                        if (typeCheckSlots[type.getNumClassTypes() + itableIdx] != interfaceTypeID) continue;
                        HostedMethod dispatchResult = type.openTypeWorldDispatchTables[type.itableStartingOffsets[itableIdx] + method.getVTableIndex()];
                        assert (dispatchResult.equals(method)) : Assertions.errorMessage((Object[])new Object[]{method, dispatchResult});
                        found = true;
                        break;
                    }
                    assert (found) : Assertions.errorMessage((Object[])new Object[]{method, type});
                    continue;
                }
                HostedMethod openTypeWorldMethod = type.openTypeWorldDispatchTables[method.getVTableIndex()];
                assert (openTypeWorldMethod.equals(method)) : Assertions.errorMessage((Object[])new Object[]{method, openTypeWorldMethod});
            }
        }
        return true;
    }

    private static List<HostedMethod> generateITable(HostedType type) {
        return VTableBuilder.generateDispatchTable(type, 0);
    }

    private static List<HostedMethod> generateDispatchTable(HostedType type, int startingIndex) {
        List<HostedMethod> table = Arrays.stream(type.getAllDeclaredMethods()).filter(method -> !(!method.wrapped.isInvoked() && !method.wrapped.isImplementationInvoked() || method.implementations.length < 1 && !method.wrapped.isVirtualRootMethod())).toList();
        int index = startingIndex;
        for (HostedMethod method2 : table) {
            assert (method2.vtableIndex == -1) : method2.vtableIndex;
            method2.vtableIndex = index++;
        }
        return table;
    }

    private void generateOpenTypeWorldDispatchTable(HostedInstanceClass type, Map<HostedType, List<HostedMethod>> dispatchTablesMap, HostedMethod invalidDispatchTableEntryHandler) {
        List<HostedMethod> resultClassTableMethods;
        HostedClass superClass = type.getSuperclass();
        List<HostedMethod> parentClassTable = superClass == null ? List.of() : dispatchTablesMap.get(superClass);
        List<HostedMethod> classTableWithoutSuper = VTableBuilder.generateDispatchTable(type, parentClassTable.size());
        if (!classTableWithoutSuper.isEmpty()) {
            resultClassTableMethods = new ArrayList(parentClassTable);
            resultClassTableMethods.addAll(classTableWithoutSuper);
        } else {
            resultClassTableMethods = parentClassTable;
        }
        dispatchTablesMap.put(type, resultClassTableMethods);
        if (!type.isAbstract()) {
            int i;
            ArrayList<HostedMethod> aggregatedTable = new ArrayList<HostedMethod>(resultClassTableMethods);
            HostedType[] interfaces = type.typeCheckInterfaceOrder;
            type.itableStartingOffsets = new int[interfaces.length];
            int currentITableOffset = resultClassTableMethods.size();
            for (i = 0; i < interfaces.length; ++i) {
                HostedType interfaceType = interfaces[i];
                List<HostedMethod> interfaceMethods = dispatchTablesMap.get(interfaceType);
                type.itableStartingOffsets[i] = currentITableOffset;
                aggregatedTable.addAll(interfaceMethods);
                currentITableOffset += interfaceMethods.size();
            }
            type.openTypeWorldDispatchTables = new HostedMethod[aggregatedTable.size()];
            for (i = 0; i < aggregatedTable.size(); ++i) {
                HostedMethod method = (HostedMethod)aggregatedTable.get(i);
                if (type.isInstantiated()) {
                    HostedMethod resolvedMethod = (HostedMethod)type.resolveConcreteMethod(method, type);
                    type.openTypeWorldDispatchTables[i] = resolvedMethod == null ? invalidDispatchTableEntryHandler : resolvedMethod;
                    continue;
                }
                type.openTypeWorldDispatchTables[i] = invalidDispatchTableEntryHandler;
            }
        }
        for (HostedType subType : type.subTypes) {
            if (!(subType instanceof HostedInstanceClass)) continue;
            HostedInstanceClass instanceClass = (HostedInstanceClass)subType;
            this.generateOpenTypeWorldDispatchTable(instanceClass, dispatchTablesMap, invalidDispatchTableEntryHandler);
        }
    }

    private void buildOpenTypeWorldDispatchTables() {
        HashMap<HostedType, List<HostedMethod>> dispatchTablesMap = new HashMap<HostedType, List<HostedMethod>>();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (!type.isInterface()) continue;
            dispatchTablesMap.put(type, VTableBuilder.generateITable(type));
        }
        HostedMethod invalidDispatchTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        this.generateOpenTypeWorldDispatchTable((HostedInstanceClass)this.hUniverse.objectType(), dispatchTablesMap, invalidDispatchTableEntryHandler);
        int[] emptyITableOffsets = new int[]{};
        HostedInstanceClass objectType = this.hUniverse.getObjectClass();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isArray()) {
                type.openTypeWorldDispatchTables = objectType.openTypeWorldDispatchTables;
                type.itableStartingOffsets = objectType.itableStartingOffsets;
            }
            if (type.openTypeWorldDispatchTables != null) continue;
            assert (type.isInterface() || type.isPrimitive() || type.isAbstract());
            type.openTypeWorldDispatchTables = HostedMethod.EMPTY_ARRAY;
            type.itableStartingOffsets = emptyITableOffsets;
        }
    }

    private void buildClosedTypeWorldVTables() {
        HashMap<HostedType, ArrayList<HostedMethod>> vtablesMap = new HashMap<HostedType, ArrayList<HostedMethod>>();
        HashMap<HostedType, BitSet> usedSlotsMap = new HashMap<HostedType, BitSet>();
        HashMap<HostedMethod, Set<Integer>> vtablesSlots = new HashMap<HostedMethod, Set<Integer>>();
        for (HostedType type : this.hUniverse.getTypes()) {
            vtablesMap.put(type, new ArrayList());
            Iterator initialBitSet = new BitSet();
            usedSlotsMap.put(type, (BitSet)((Object)initialBitSet));
        }
        HostedInstanceClass objectClass = this.hUniverse.getObjectClass();
        this.assignImplementations((HostedType)objectClass, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<Pair> interfaces = new ArrayList<Pair>();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (!type.isInterface()) continue;
            int importance = VTableBuilder.collectSubtypes(type, new HashSet<HostedType>()).size();
            interfaces.add(Pair.create((Object)type, (Object)importance));
        }
        interfaces.sort((pair1, pair2) -> (Integer)pair2.getRight() - (Integer)pair1.getRight());
        for (Pair pair : interfaces) {
            this.assignImplementations((HostedType)pair.getLeft(), vtablesMap, usedSlotsMap, vtablesSlots);
        }
        this.buildVTable(objectClass, vtablesMap, usedSlotsMap, vtablesSlots);
        HostedMethod invalidVTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isArray()) {
                type.closedTypeWorldVTable = objectClass.closedTypeWorldVTable;
            }
            if (type.closedTypeWorldVTable == null) {
                assert (type.isInterface() || type.isPrimitive());
                type.closedTypeWorldVTable = HostedMethod.EMPTY_ARRAY;
            }
            HostedMethod[] vtableArray = type.closedTypeWorldVTable;
            for (int i = 0; i < vtableArray.length; ++i) {
                if (vtableArray[i] != null) continue;
                vtableArray[i] = invalidVTableEntryHandler;
            }
        }
        if (SubstrateUtil.assertionsEnabled()) {
            for (HostedType type : this.hUniverse.getTypes()) {
                for (HostedMethod m : type.closedTypeWorldVTable) {
                    assert (m.equals(invalidVTableEntryHandler) || m.equals(this.hUniverse.lookup((JavaMethod)type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)m.wrapped, (ResolvedJavaType)type.wrapped))));
                }
            }
        }
    }

    private static Set<HostedType> collectSubtypes(HostedType type, Set<HostedType> allSubtypes) {
        if (allSubtypes.add(type)) {
            for (HostedType subtype : type.subTypes) {
                VTableBuilder.collectSubtypes(subtype, allSubtypes);
            }
        }
        return allSubtypes;
    }

    private void buildVTable(HostedClass clazz, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        this.assignImplementations((HostedType)clazz, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<HostedMethod> vtable = vtablesMap.get(clazz);
        HostedMethod[] vtableArray = vtable.toArray(new HostedMethod[vtable.size()]);
        assert (vtableArray.length == 0 || vtableArray[vtableArray.length - 1] != null) : "Unnecessary entry at end of vtable";
        clazz.closedTypeWorldVTable = vtableArray;
        for (HostedType subClass : clazz.subTypes) {
            if (subClass.isInterface() || subClass.isArray()) continue;
            this.buildVTable((HostedClass)subClass, vtablesMap, usedSlotsMap, vtablesSlots);
        }
    }

    private void assignImplementations(HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        for (HostedMethod method : type.getAllDeclaredMethods()) {
            int slot;
            if (!method.wrapped.isInvoked() && !method.wrapped.isImplementationInvoked() || method.implementations.length <= 1 && !method.wrapped.isVirtualRootMethod()) continue;
            method.vtableIndex = slot = this.findSlot(method, vtablesMap, usedSlotsMap, vtablesSlots);
            this.assignImplementations(method.getDeclaringClass(), method, slot, vtablesMap);
        }
    }

    private void assignImplementations(HostedType type, HostedMethod method, int slot, Map<HostedType, ArrayList<HostedMethod>> vtablesMap) {
        if (type.wrapped.isInstantiated()) {
            assert (type.isInstanceClass() && !type.isAbstract() || type.isArray());
            HostedMethod resolvedMethod = this.resolveMethod(type, method);
            if (resolvedMethod != null) {
                ArrayList<HostedMethod> vtable = vtablesMap.get(type);
                if (slot < vtable.size() && vtable.get(slot) != null) {
                    assert (vtable.get(slot).equals(resolvedMethod));
                } else {
                    VTableBuilder.resize(vtable, slot + 1);
                    assert (vtable.get(slot) == null);
                    vtable.set(slot, resolvedMethod);
                }
                resolvedMethod.vtableIndex = slot;
            }
        }
        for (HostedType subtype : type.subTypes) {
            if (subtype.isArray()) continue;
            this.assignImplementations(subtype, method, slot, vtablesMap);
        }
    }

    private HostedMethod resolveMethod(HostedType type, HostedMethod method) {
        AnalysisMethod resolved = type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)method.wrapped, (ResolvedJavaType)type.wrapped);
        if (resolved == null || !resolved.isImplementationInvoked()) {
            return null;
        }
        assert (!resolved.isAbstract());
        return this.hUniverse.lookup((JavaMethod)resolved);
    }

    private static void resize(ArrayList<?> list, int minSize) {
        list.ensureCapacity(minSize);
        while (list.size() < minSize) {
            list.add(null);
        }
    }

    private int findSlot(HostedMethod method, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        if (method.implementations.length > 0) {
            Set<Integer> resultSlots = vtablesSlots.get(method.implementations[0]);
            for (HostedMethod impl : method.implementations) {
                Set<Integer> implSlots = vtablesSlots.get(impl);
                if (implSlots == null) {
                    resultSlots = null;
                    break;
                }
                resultSlots.retainAll(implSlots);
            }
            if (resultSlots != null && !resultSlots.isEmpty()) {
                int resultSlot = Integer.MAX_VALUE;
                for (int slot : resultSlots) {
                    resultSlot = Math.min(resultSlot, slot);
                }
                return resultSlot;
            }
        }
        BitSet usedSlots = new BitSet();
        this.collectUsedSlots(method.getDeclaringClass(), usedSlots, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.collectUsedSlots(impl.getDeclaringClass(), usedSlots, usedSlotsMap);
        }
        int resultSlot = usedSlots.nextClearBit(0);
        this.markSlotAsUsed(resultSlot, method.getDeclaringClass(), vtablesMap, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.markSlotAsUsed(resultSlot, impl.getDeclaringClass(), vtablesMap, usedSlotsMap);
            vtablesSlots.computeIfAbsent(impl, k -> new HashSet()).add(resultSlot);
        }
        return resultSlot;
    }

    private void collectUsedSlots(HostedType type, BitSet usedSlots, Map<HostedType, BitSet> usedSlotsMap) {
        usedSlots.or(usedSlotsMap.get(type));
        for (HostedType sub : type.subTypes) {
            if (sub.isArray()) continue;
            this.collectUsedSlots(sub, usedSlots, usedSlotsMap);
        }
    }

    private void markSlotAsUsed(int resultSlot, HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap) {
        assert (resultSlot >= vtablesMap.get(type).size() || vtablesMap.get(type).get(resultSlot) == null);
        usedSlotsMap.get(type).set(resultSlot);
        for (HostedType sub : type.subTypes) {
            if (sub.isArray()) continue;
            this.markSlotAsUsed(resultSlot, sub, vtablesMap, usedSlotsMap);
        }
    }
}

