/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.heap.SVMImageHeapScanner;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorExitNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

class JNINativeCallWrapperMethod
extends CustomSubstitutionMethod {
    private static final int NATIVE_LINE_NUMBER = -2;
    private static final LineNumberTable LINE_NUMBER_TABLE = new LineNumberTable(new int[]{1}, new int[]{-2});
    private final JNINativeLinkage linkage;
    private final Field linkageBuiltInAddressField = ReflectionUtil.lookupField(JNINativeLinkage.class, (String)"builtInAddress");

    JNINativeCallWrapperMethod(ResolvedJavaMethod method) {
        super(method);
        assert (!(method instanceof WrappedJavaMethod));
        this.linkage = JNINativeCallWrapperMethod.createLinkage(method);
    }

    private static JNINativeLinkage createLinkage(ResolvedJavaMethod method) {
        String className = method.getDeclaringClass().getName();
        String descriptor = method.getSignature().toMethodDescriptor();
        return JNIAccessFeature.singleton().makeLinkage(className, method.getName(), descriptor);
    }

    @Override
    public int getModifiers() {
        return this.getOriginal().getModifiers() & 0xFFFFFFDF;
    }

    @Override
    public LineNumberTable getLineNumberTable() {
        return LINE_NUMBER_TABLE;
    }

    @Override
    public StackTraceElement asStackTraceElement(int bci) {
        StackTraceElement ste = super.asStackTraceElement(bci);
        ste = new StackTraceElement(ste.getClassLoaderName(), ste.getModuleName(), ste.getModuleVersion(), ste.getClassName(), ste.getMethodName(), ste.getFileName(), -2);
        assert (ste.isNativeMethod());
        return ste;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        InvokeWithExceptionNode callAddress;
        JNIGraphKit kit = new JNIGraphKit(debug, providers, (ResolvedJavaMethod)method);
        if (this.linkage.isBuiltInFunction()) {
            Function<String, CGlobalDataInfo> createSymbol = symbolName -> CGlobalDataFeature.singleton().registerAsAccessedOrGet(CGlobalDataFactory.forSymbol(symbolName));
            CGlobalDataInfo builtinAddress = this.linkage.getOrCreateBuiltInAddress(createSymbol);
            callAddress = kit.unique(new CGlobalDataLoadAddressNode(builtinAddress));
            SVMImageHeapScanner.instance().rescanField((Object)this.linkage, this.linkageBuiltInAddressField);
        } else {
            callAddress = kit.invokeNativeCallAddress((ValueNode)kit.createObject(this.linkage));
        }
        InvokeWithExceptionNode environment = kit.invokeEnvironment();
        InvokeWithExceptionNode handleFrame = kit.invokeNativeCallPrologue();
        AnalysisType javaReturnType = (AnalysisType)method.getSignature().getReturnType();
        List javaArgumentTypes = method.toParameterList();
        List<ValueNode> javaArguments = kit.getInitialArguments();
        ArrayList<ValueNode> jniArguments = new ArrayList<ValueNode>(2 + javaArguments.size());
        ArrayList<AnalysisType> jniArgumentTypes = new ArrayList<AnalysisType>(2 + javaArguments.size());
        AnalysisType environmentType = kit.getMetaAccess().lookupJavaType(JNIEnvironment.class);
        AnalysisType objectHandleType = kit.getMetaAccess().lookupJavaType(JNIObjectHandle.class);
        jniArguments.add((ValueNode)environment);
        jniArgumentTypes.add(environmentType);
        if (method.isStatic()) {
            JavaConstant clazz = kit.getConstantReflection().asJavaClass((ResolvedJavaType)method.getDeclaringClass());
            ConstantNode clazzNode = ConstantNode.forConstant((JavaConstant)clazz, (MetaAccessProvider)kit.getMetaAccess(), (StructuredGraph)kit.getGraph());
            InvokeWithExceptionNode box = kit.invokeBoxObjectInLocalHandle((ValueNode)clazzNode);
            jniArguments.add((ValueNode)box);
            jniArgumentTypes.add(objectHandleType);
        }
        for (int i = 0; i < javaArguments.size(); ++i) {
            ValueNode arg = javaArguments.get(i);
            AnalysisType argType = (AnalysisType)javaArgumentTypes.get(i);
            if (argType.getJavaKind().isObject()) {
                ValueNode obj = javaArguments.get(i);
                arg = kit.invokeBoxObjectInLocalHandle(obj);
                argType = objectHandleType;
            }
            jniArguments.add(arg);
            jniArgumentTypes.add(argType);
        }
        assert (jniArguments.size() == jniArgumentTypes.size());
        AnalysisType jniReturnType = javaReturnType;
        if (jniReturnType.getJavaKind().isObject()) {
            jniReturnType = objectHandleType;
        }
        if (this.getOriginal().isSynchronized()) {
            ValueNode monitorObject;
            if (method.isStatic()) {
                JavaConstant hubConstant = (JavaConstant)kit.getConstantReflection().asObjectHub((ResolvedJavaType)method.getDeclaringClass());
                monitorObject = ConstantNode.forConstant((JavaConstant)hubConstant, (MetaAccessProvider)kit.getMetaAccess(), (StructuredGraph)kit.getGraph());
            } else {
                monitorObject = kit.maybeCreateExplicitNullCheck(javaArguments.get(0));
            }
            MonitorIdNode monitorId = (MonitorIdNode)kit.getGraph().add((Node)new MonitorIdNode(kit.getFrameState().lockDepth(false)));
            MonitorEnterNode monitorEnter = (MonitorEnterNode)kit.append((Node)new MonitorEnterNode(monitorObject, monitorId));
            kit.getFrameState().pushLock(monitorEnter.object(), monitorEnter.getMonitorId());
            monitorEnter.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)monitorEnter));
        }
        kit.getFrameState().clearLocals();
        ResolvedSignature jniSignature = ResolvedSignature.fromList(jniArgumentTypes, (ResolvedJavaType)jniReturnType);
        ValueNode returnValue = kit.createCFunctionCall((ValueNode)callAddress, jniArguments, (Signature)jniSignature, 3, false);
        if (this.getOriginal().isSynchronized()) {
            MonitorIdNode monitorId = kit.getFrameState().peekMonitorId();
            ValueNode monitorObject = kit.getFrameState().popLock();
            MonitorExitNode monitorExit = (MonitorExitNode)kit.append((Node)new MonitorExitNode(monitorObject, monitorId, null));
            monitorExit.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)monitorExit));
        }
        if (javaReturnType.getJavaKind().isObject()) {
            returnValue = kit.invokeUnboxHandle(returnValue);
        }
        kit.invokeNativeCallEpilogue((ValueNode)handleFrame);
        kit.invokeRethrowPendingException();
        if (javaReturnType.getJavaKind().isObject()) {
            returnValue = kit.checkObjectType(returnValue, (ResolvedJavaType)javaReturnType, false);
        }
        kit.createReturn(returnValue, javaReturnType.getJavaKind());
        return kit.finalizeGraph();
    }
}

