/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
class JNIRegistrationsJavaZip
extends JNIRegistrationUtil
implements InternalFeature {
    JNIRegistrationsJavaZip() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JNIRegistrationsJavaZip.initializeAtRunTime((Feature.FeatureAccess)a, "java.util.zip.Inflater", "java.util.zip.Deflater");
        JNIRegistrationsJavaZip.initializeAtRunTime((Feature.FeatureAccess)a, "java.util.zip.Adler32", "java.util.zip.CRC32");
        JNIRegistrationsJavaZip.initializeAtRunTime((Feature.FeatureAccess)a, "sun.net.www.protocol.jar.JarFileFactory", "sun.net.www.protocol.jar.JarURLConnection");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        a.registerReachabilityHandler(JNIRegistrationsJavaZip::registerInflaterInitIDs, new Object[]{JNIRegistrationsJavaZip.method((Feature.FeatureAccess)a, "java.util.zip.Inflater", "initIDs", new Class[0])});
    }

    private static void registerInflaterInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Field[])JNIRegistrationsJavaZip.fields((Feature.FeatureAccess)a, "java.util.zip.Inflater", "inputConsumed", "outputConsumed"));
    }
}

