/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.query;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.RawPointerToInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.c.query.NativeInfoTreeVisitor;
import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class QueryResultParser
extends NativeInfoTreeVisitor {
    private final Map<String, String> idToResult = new HashMap<String, String>();

    private QueryResultParser(NativeLibraries nativeLibs) {
        super(nativeLibs);
    }

    public static List<String> parse(NativeLibraries nativeLibs, NativeCodeInfo nativeCodeInfo, InputStream source) {
        QueryResultParser parser = new QueryResultParser(nativeLibs);
        List<String> lines = FileUtils.readAllLines(source);
        for (String line : lines) {
            String[] keyValuePair = line.split("=");
            assert (keyValuePair.length == 2);
            parser.idToResult.put(keyValuePair[0], keyValuePair[1]);
        }
        nativeCodeInfo.accept(parser);
        return lines;
    }

    @Override
    protected void visitConstantInfo(ConstantInfo constantInfo) {
        switch (constantInfo.getKind()) {
            case INTEGER: {
                this.parseIntegerProperty(constantInfo.getSizeInfo());
                this.parseSignedness(constantInfo.getSignednessInfo());
                this.parseIntegerConstantValue(constantInfo.getValueInfo());
                this.tryChangeSizeToDeclaredReturnType(constantInfo);
                break;
            }
            case POINTER: {
                this.parseIntegerProperty(constantInfo.getSizeInfo());
                this.parseIntegerConstantValue(constantInfo.getValueInfo());
                break;
            }
            case FLOAT: {
                this.parseIntegerProperty(constantInfo.getSizeInfo());
                this.parseFloatValue(constantInfo.getValueInfo());
                break;
            }
            case STRING: {
                this.parseStringValue(constantInfo.getValueInfo());
                break;
            }
            case BYTEARRAY: {
                this.parseByteArrayValue(constantInfo.getValueInfo());
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)constantInfo.getKind());
            }
        }
    }

    private void tryChangeSizeToDeclaredReturnType(ConstantInfo constantInfo) {
        ResolvedJavaType javaReturnType = AccessorInfo.getReturnType(constantInfo.getAnnotatedElement());
        JavaKind javaReturnKind = this.nativeLibs.getWordTypes().asKind((JavaType)javaReturnType);
        int bytesInJava = javaReturnKind.getByteCount();
        int bytesInC = constantInfo.getSizeInBytes();
        long cValue = (Long)constantInfo.getValue();
        if (javaReturnKind == JavaKind.Boolean) {
            long newValue = cValue != 0L ? 1L : 0L;
            constantInfo.getValueInfo().setProperty(newValue);
            constantInfo.getSizeInfo().setProperty(bytesInJava);
        } else if (bytesInJava != bytesInC) {
            boolean largeUnsignedCValue;
            boolean withinRange = cValue >= javaReturnKind.getMinValue() && cValue <= javaReturnKind.getMaxValue();
            boolean negativeCValueAsUnsigned64BitValue = !constantInfo.isUnsigned() && cValue < 0L && !this.nativeLibs.isSigned(javaReturnType) && javaReturnKind.getBitCount() == 64;
            boolean bl = largeUnsignedCValue = constantInfo.isUnsigned() && cValue < 0L;
            if (withinRange && !negativeCValueAsUnsigned64BitValue && !largeUnsignedCValue) {
                constantInfo.getSizeInfo().setProperty(bytesInJava);
            }
        }
    }

    @Override
    public void visitStructInfo(StructInfo structInfo) {
        if (!structInfo.isIncomplete()) {
            this.parseIntegerProperty(structInfo.getSizeInfo());
        }
        this.processChildren(structInfo);
    }

    @Override
    protected void visitRawStructureInfo(RawStructureInfo info) {
    }

    @Override
    public void visitStructFieldInfo(StructFieldInfo fieldInfo) {
        this.parseIntegerProperty(fieldInfo.getSizeInfo());
        this.parseIntegerProperty(fieldInfo.getOffsetInfo());
        if (fieldInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            this.parseSignedness(fieldInfo.getSignednessInfo());
        }
    }

    @Override
    public void visitStructBitfieldInfo(StructBitfieldInfo bitfieldInfo) {
        this.parseIntegerProperty(bitfieldInfo.getByteOffsetInfo());
        this.parseIntegerProperty(bitfieldInfo.getStartBitInfo());
        this.parseIntegerProperty(bitfieldInfo.getEndBitInfo());
        this.parseSignedness(bitfieldInfo.getSignednessInfo());
    }

    @Override
    public void visitPointerToInfo(PointerToInfo pointerToInfo) {
        this.parseIntegerProperty(pointerToInfo.getSizeInfo());
        if (pointerToInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            this.parseSignedness(pointerToInfo.getSignednessInfo());
        }
    }

    @Override
    public void visitRawPointerToInfo(RawPointerToInfo pointerToInfo) {
    }

    @Override
    protected void visitEnumInfo(EnumInfo info) {
        assert (info.getKind() == SizableInfo.ElementKind.INTEGER);
        this.parseIntegerProperty(info.getSizeInfo());
        this.parseSignedness(info.getSignednessInfo());
        super.visitEnumInfo(info);
    }

    @Override
    protected void visitEnumConstantInfo(EnumConstantInfo constantInfo) {
        assert (constantInfo.getKind() == SizableInfo.ElementKind.INTEGER);
        this.parseIntegerProperty(constantInfo.getSizeInfo());
        this.parseSignedness(constantInfo.getSignednessInfo());
        this.parseIntegerConstantValue(constantInfo.getValueInfo());
    }

    private void parseSignedness(PropertyInfo<SizableInfo.SignednessValue> info) {
        info.setProperty(SizableInfo.SignednessValue.valueOf(this.stringLiteral(info)));
    }

    private void parseIntegerConstantValue(PropertyInfo<Object> info) {
        String hex = this.idToResult.get(info.getUniqueID());
        long value = QueryResultParser.parseHexToLong(hex);
        SizableInfo parent = (SizableInfo)info.getParent();
        int bitsInC = parent.getSizeInBytes() * 8;
        if (bitsInC < 64) {
            value = parent.isUnsigned() ? CodeUtil.zeroExtend((long)value, (int)bitsInC) : CodeUtil.signExtend((long)value, (int)bitsInC);
        }
        info.setProperty(value);
    }

    private static long parseHexToLong(String hex) {
        assert (hex.length() <= 16);
        if (hex.length() > 8) {
            String msb = hex.substring(0, hex.length() - 8);
            String lsb = hex.substring(hex.length() - 8);
            long msbValue = Long.parseLong(msb, 16);
            long lsbValue = Long.parseLong(lsb, 16);
            return msbValue << 32 | lsbValue;
        }
        return Long.parseLong(hex, 16);
    }

    private void parseFloatValue(PropertyInfo<Object> info) {
        String str = this.idToResult.get(info.getUniqueID());
        double value = Double.parseDouble(str);
        info.setProperty(value);
    }

    private void parseStringValue(PropertyInfo<Object> info) {
        info.setProperty(this.stringLiteral(info));
    }

    private String stringLiteral(ElementInfo info) {
        String str = this.idToResult.get(info.getUniqueID());
        if (str.startsWith("$") && str.endsWith("$")) {
            return str.substring("$".length(), str.length() - "$".length());
        }
        this.addError("String constant not deliminated correctly", info);
        return "";
    }

    private void parseByteArrayValue(PropertyInfo<Object> info) {
        info.setProperty(this.byteArrayLiteral(info));
    }

    private byte[] byteArrayLiteral(ElementInfo info) {
        String str = this.stringLiteral(info);
        if (!str.isEmpty()) {
            return str.getBytes(StandardCharsets.UTF_8);
        }
        return new byte[0];
    }

    private void parseIntegerProperty(PropertyInfo<Integer> info) {
        int value = Integer.parseInt(this.idToResult.get(info.getUniqueID()));
        info.setProperty(value);
    }
}

