/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.function;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegister;
import java.lang.reflect.Type;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;

@AutomaticallyRegisteredFeature
public class CEntryPointSupport
implements InternalFeature {
    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        CEntryPointSupport.registerEntryPointActionsPlugins(plugins.getInvocationPlugins());
        CEntryPointSupport.registerCurrentIsolatePlugins(plugins.getInvocationPlugins());
    }

    private static void registerEntryPointActionsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CEntryPointActions.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("enterCreateIsolate", new Type[]{CEntryPointCreateIsolateParameters.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode parameters) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.createIsolate(parameters));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("enterAttachThread", new Type[]{Isolate.class, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate, ValueNode ensureJavaThreadNode) {
                if (!ensureJavaThreadNode.isConstant()) {
                    b.bailout("Parameter ensureJavaThread of enterAttachThread must be a compile time constant");
                }
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.attachThread(isolate, false, ensureJavaThreadNode.asJavaConstant().asInt() != 0));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("enterAttachThread", new Type[]{Isolate.class, Boolean.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate, ValueNode startedByIsolate, ValueNode ensureJavaThread) {
                if (!startedByIsolate.isConstant() || !ensureJavaThread.isConstant()) {
                    b.bailout("Parameters ensureJavaThread and startedByIsolate of enterAttachThread must be a compile time constant");
                }
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.attachThread(isolate, startedByIsolate.asJavaConstant().asInt() != 0, ensureJavaThread.asJavaConstant().asInt() != 0));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("enter", new Type[]{IsolateThread.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode thread) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.enter(thread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("enterByIsolate", new Type[]{Isolate.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.enterByIsolate(isolate));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("leave", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                StateSplitProxyNode proxy = (StateSplitProxyNode)b.append((Node)new StateSplitProxyNode());
                proxy.setStateAfter(b.getInvocationPluginBeforeState());
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("leaveDetachThread", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                StateSplitProxyNode proxy = (StateSplitProxyNode)b.append((Node)new StateSplitProxyNode());
                proxy.setStateAfter(b.getInvocationPluginBeforeState());
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.DetachThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("leaveTearDownIsolate", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                StateSplitProxyNode proxy = (StateSplitProxyNode)b.append((Node)new StateSplitProxyNode());
                proxy.setStateAfter(b.getInvocationPluginBeforeState());
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.TearDownIsolate));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("failFatally", new Type[]{Integer.TYPE, CCharPointer.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.add((Node)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.FailFatally, arg1, arg2));
                LoweredDeadEndNode deadEndNode = (LoweredDeadEndNode)b.add((Node)new LoweredDeadEndNode());
                AbstractBeginNode prevBegin = AbstractBeginNode.prevBegin((FixedNode)deadEndNode);
                if (prevBegin != null && prevBegin.predecessor() instanceof IfNode) {
                    ((IfNode)prevBegin.predecessor()).setProbability(prevBegin, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE);
                }
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("isCurrentThreadAttachedTo", new Type[]{Isolate.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Boolean, (ValueNode)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.IsAttached, isolate));
                return true;
            }
        });
    }

    private static void registerCurrentIsolatePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CurrentIsolate.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getCurrentThread", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, ReadReservedRegister.createReadIsolateThreadNode(b.getGraph()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getIsolate", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                    b.addPush(JavaKind.Object, ReadReservedRegister.createReadHeapBaseNode(b.getGraph()));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL.rawValue()));
                }
                return true;
            }
        });
    }
}

