/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import jdk.internal.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;

public final class AnnotationValue
extends AnnotationMemberValue {
    final Class<? extends Annotation> type;
    final Map<String, AnnotationMemberValue> members;

    static AnnotationValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean exceptionOnMissingAnnotationClass, boolean skip) {
        boolean skipMembers = skip;
        Object typeOrException = AnnotationMetadata.extractType(buf, cp, container, skip);
        if (typeOrException instanceof TypeNotPresentExceptionProxy) {
            if (exceptionOnMissingAnnotationClass) {
                TypeNotPresentExceptionProxy proxy = (TypeNotPresentExceptionProxy)typeOrException;
                throw new TypeNotPresentException(proxy.typeName(), proxy.getCause());
            }
            skipMembers = true;
        }
        int numMembers = buf.getShort() & 0xFFFF;
        LinkedHashMap<String, AnnotationMemberValue> memberValues = new LinkedHashMap<String, AnnotationMemberValue>();
        for (int i = 0; i < numMembers; ++i) {
            String memberName = AnnotationMetadata.extractString(buf, cp, skipMembers);
            AnnotationMemberValue memberValue = AnnotationMemberValue.extract(buf, cp, container, skipMembers);
            if (skipMembers) continue;
            memberValues.put(memberName, memberValue);
        }
        if (skipMembers) {
            return null;
        }
        Class type = (Class)typeOrException;
        return new AnnotationValue(type, memberValues);
    }

    static AnnotationValue forAnnotationFormatException() {
        return new AnnotationValue(null, null);
    }

    AnnotationValue(Annotation annotation) {
        this.type = annotation.annotationType();
        this.members = new LinkedHashMap<String, AnnotationMemberValue>();
        AnnotationType annotationType = AnnotationType.getInstance(this.type);
        annotationType.members().forEach((memberName, memberAccessor) -> {
            AnnotationMemberValue memberValue;
            try {
                memberValue = AnnotationMemberValue.from(annotationType.memberTypes().get(memberName), memberAccessor.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AnnotationMetadata.AnnotationExtractionError((Object)annotation, (Throwable)e);
            }
            Object memberDefault = annotationType.memberDefaults().get(memberName);
            if (!memberValue.equals(memberDefault)) {
                this.members.put((String)memberName, memberValue);
            }
        });
    }

    private AnnotationValue(Class<? extends Annotation> type, Map<String, AnnotationMemberValue> members) {
        this.type = type;
        this.members = members;
    }

    public boolean isAnnotationFormatException() {
        return this.type == null && this.members == null;
    }

    public Class<? extends Annotation> getType() {
        return this.type;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public void forEachMember(BiConsumer<String, AnnotationMemberValue> callback) {
        this.members.forEach(callback);
    }

    @Override
    public List<Class<?>> getTypes() {
        if (this.isAnnotationFormatException()) {
            return List.of();
        }
        ArrayList types = new ArrayList();
        types.add(this.type);
        for (AnnotationMemberValue memberValue : this.members.values()) {
            types.addAll(memberValue.getTypes());
        }
        return types;
    }

    @Override
    public char getTag() {
        return '@';
    }

    @Override
    public Object get(Class<?> memberType) {
        if (this.isAnnotationFormatException()) {
            throw new AnnotationFormatError("Annotations could not be parsed at image build time");
        }
        AnnotationType annotationType = AnnotationType.getInstance(this.type);
        LinkedHashMap<String, Object> memberValues = new LinkedHashMap<String, Object>(annotationType.memberDefaults());
        this.members.forEach((memberName, memberValue) -> memberValues.put((String)memberName, memberValue.get(annotationType.memberTypes().get(memberName))));
        return AnnotationMetadata.checkResult(AnnotationParser.annotationForMap(this.type, memberValues), memberType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationValue that = (AnnotationValue)o;
        return this.isAnnotationFormatException() == that.isAnnotationFormatException() && Objects.equals(this.type, that.type) && this.members.equals(that.members);
    }

    public int hashCode() {
        return Objects.hash(this.isAnnotationFormatException(), this.type, this.members);
    }
}

