/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.code.ExplicitCallingConvention;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.graal.phases.SubstrateSafepointInsertionPhase;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.EncodedLineNumberTable;
import com.oracle.svm.graal.meta.SubstrateSignature;
import com.oracle.svm.graal.meta.SubstrateType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public class SubstrateMethod
implements SharedRuntimeMethod {
    private static final int FLAG_BIT_BRIDGE = 0;
    private static final int FLAG_BIT_NEVER_INLINE = 1;
    private static final int FLAG_BIT_UNINTERRUPTIBLE = 2;
    private static final int FLAG_BIT_NEEDS_SAFEPOINT_CHECK = 3;
    private static final int FLAG_BIT_ENTRY_POINT = 4;
    private static final int FLAG_BIT_SNIPPET = 5;
    private static final int FLAG_BIT_FOREIGN_CALL_TARGET = 6;
    private static final int FLAG_BIT_CALLING_CONVENTION_KIND = 7;
    private static final int NUM_BITS_CALLING_CONVENTION_KIND = 2;
    private static final int FLAG_BIT_CALLEE_SAVED_REGISTERS = 9;
    private final int flags;
    private final byte[] encodedLineNumberTable;
    private final int modifiers;
    private final String name;
    private final int hashCode;
    private SubstrateType declaringClass;
    private int encodedGraphStartOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private int vTableIndex;
    private final ImageCodeInfo imageCodeInfo;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private int imageCodeOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private int imageCodeDeoptOffset;
    @UnknownObjectField(types={SubstrateMethod[].class, SubstrateMethod.class}, canBeNull=true, availability=BuildPhaseProvider.ReadyForCompilation.class)
    protected Object implementations;
    private SubstrateSignature signature;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateMethod(AnalysisMethod original, ImageCodeInfo codeInfo, HostedStringDeduplication stringTable) {
        this.imageCodeInfo = codeInfo;
        this.encodedLineNumberTable = EncodedLineNumberTable.encode(original.getLineNumberTable());
        assert (original.getAnnotation(CEntryPoint.class) == null) : "Can't compile entry point method";
        this.modifiers = original.getModifiers();
        this.name = stringTable.deduplicate(original.getName(), true);
        this.hashCode = original.hashCode();
        this.encodedGraphStartOffset = -1;
        SubstrateCallingConventionKind callingConventionKind = ExplicitCallingConvention.Util.getCallingConventionKind((ResolvedJavaMethod)original, original.isEntryPoint());
        this.flags = SubstrateMethod.makeFlag(original.isBridge(), 0) | SubstrateMethod.makeFlag(original.hasNeverInlineDirective(), 1) | SubstrateMethod.makeFlag(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)original), 2) | SubstrateMethod.makeFlag(SubstrateSafepointInsertionPhase.needSafepointCheck((ResolvedJavaMethod)original), 3) | SubstrateMethod.makeFlag(original.isEntryPoint(), 4) | SubstrateMethod.makeFlag(original.isAnnotationPresent(Snippet.class), 5) | SubstrateMethod.makeFlag(original.isAnnotationPresent(SubstrateForeignCallTarget.class), 6) | SubstrateMethod.makeFlag(callingConventionKind.ordinal(), 7, 2) | SubstrateMethod.makeFlag(StubCallingConvention.Utils.hasStubCallingConvention((ResolvedJavaMethod)original), 9);
    }

    private static int makeFlag(boolean value, int flagBit) {
        return value ? 1 << flagBit : 0;
    }

    private static int makeFlag(int value, int flagBit, int numBits) {
        VMError.guarantee(value >= 0 && value < 1 << numBits, "flag value out of range");
        return value << flagBit;
    }

    private boolean getFlag(int flagBit) {
        return (this.flags & 1 << flagBit) != 0;
    }

    private int getFlag(int flagBit, int numBits) {
        return this.flags >> flagBit & (1 << numBits) - 1;
    }

    public byte[] getEncodedLineNumberTable() {
        return this.encodedLineNumberTable;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setLinks(SubstrateSignature signature, SubstrateType declaringClass) {
        this.signature = signature;
        this.declaringClass = declaringClass;
    }

    public void setImplementations(SubstrateMethod[] rawImplementations) {
        this.implementations = rawImplementations.length == 0 ? null : (rawImplementations.length == 1 ? rawImplementations[0] : rawImplementations);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getRawImplementations() {
        return this.implementations;
    }

    public void setSubstrateData(int vTableIndex, int imageCodeOffset, int imageCodeDeoptOffset) {
        this.vTableIndex = vTableIndex;
        this.imageCodeOffset = imageCodeOffset;
        this.imageCodeDeoptOffset = imageCodeDeoptOffset;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ImageCodeInfo getImageCodeInfo() {
        return this.imageCodeInfo;
    }

    @Override
    public boolean hasImageCodeOffset() {
        return this.imageCodeOffset != 0;
    }

    @Override
    public int getImageCodeOffset() {
        assert (this.imageCodeOffset != 0);
        return this.imageCodeOffset;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getImageCodeDeoptOffset() {
        return this.imageCodeDeoptOffset;
    }

    @Override
    public boolean forceIndirectCall() {
        return false;
    }

    @Override
    public int getEncodedGraphStartOffset() {
        return this.encodedGraphStartOffset;
    }

    public void setEncodedGraphStartOffset(long encodedGraphStartOffset) {
        this.encodedGraphStartOffset = TypeConversion.asS4((long)encodedGraphStartOffset);
    }

    @Override
    public SubstrateCallingConventionKind getCallingConventionKind() {
        return SubstrateCallingConventionKind.values()[this.getFlag(7, 2)];
    }

    @Override
    public boolean hasCalleeSavedRegisters() {
        return this.getFlag(9);
    }

    public SubstrateMethod[] getImplementations() {
        if (this.implementations == null) {
            return new SubstrateMethod[0];
        }
        if (this.implementations instanceof SubstrateMethod) {
            return new SubstrateMethod[]{(SubstrateMethod)this.implementations};
        }
        return (SubstrateMethod[])this.implementations;
    }

    @Override
    public boolean isDeoptTarget() {
        return false;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public boolean isUninterruptible() {
        return this.getFlag(2);
    }

    @Override
    public boolean needSafepointCheck() {
        return this.getFlag(3);
    }

    @Override
    public boolean isEntryPoint() {
        return this.getFlag(4);
    }

    @Override
    public boolean isSnippet() {
        return this.getFlag(5);
    }

    @Override
    public boolean isForeignCallTarget() {
        return this.getFlag(6);
    }

    @Override
    public int getVTableIndex() {
        if (this.vTableIndex < 0) {
            throw VMError.shouldNotReachHere("no vtable index");
        }
        return this.vTableIndex;
    }

    @Override
    public Deoptimizer.StubType getDeoptStubType() {
        return Deoptimizer.StubType.NoDeoptStub;
    }

    public String getName() {
        return this.name;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public SubstrateType getDeclaringClass() {
        return this.declaringClass;
    }

    public int getMaxLocals() {
        return this.getSignature().getParameterCount(!Modifier.isStatic(this.getModifiers())) * 2;
    }

    public int getMaxStackSize() {
        return 2;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isClassInitializer() {
        assert (!"<clinit>".equals(this.name) || !this.isStatic()) : "class initializers are executed during native image generation and are never in the native image";
        return false;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name) && !this.isStatic();
    }

    public boolean canBeStaticallyBound() {
        return this.equals(this.implementations);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public StackTraceElement asStackTraceElement(int bci) {
        int lineNumber = EncodedLineNumberTable.getLineNumber(bci, this.encodedLineNumberTable);
        return new StackTraceElement(this.getDeclaringClass().toClassName(), this.getName(), this.getDeclaringClass().getSourceFileName(), lineNumber);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return DefaultProfilingInfo.get((TriState)TriState.UNKNOWN);
    }

    public void reprofile() {
        throw VMError.intentionallyUnimplemented();
    }

    public ConstantPool getConstantPool() {
        throw VMError.intentionallyUnimplemented();
    }

    public Annotation[] getAnnotations() {
        throw VMError.unimplemented("Annotations are not available for JIT compilation at image run time");
    }

    public Annotation[] getDeclaredAnnotations() {
        throw VMError.unimplemented("Annotations are not available for JIT compilation at image run time");
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw VMError.unimplemented("Annotations are not available for JIT compilation at image run time");
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.getFlag(1) || this.encodedGraphStartOffset < 0;
    }

    public boolean shouldBeInlined() {
        return false;
    }

    public LineNumberTable getLineNumberTable() {
        return EncodedLineNumberTable.decode(this.encodedLineNumberTable);
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isVarArgs() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isBridge() {
        return this.getFlag(0);
    }

    public boolean isDefault() {
        throw VMError.intentionallyUnimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.intentionallyUnimplemented();
    }

    public String toString() {
        return "SubstrateMethod<" + this.format("%h.%n") + ">";
    }
}

