/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.memory.UntrackedNullableNativeMemory;
import com.oracle.svm.core.posix.PosixSystemPropertiesSupport;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Stdlib;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.Foundation;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@CLibrary(value="darwin", requireStatic=true)
public class DarwinSystemPropertiesSupport
extends PosixSystemPropertiesSupport {
    private static volatile String osVersionValue = null;

    @Override
    protected String javaIoTmpdirValue() {
        int buflen = Limits.PATH_MAX();
        CCharPointer tmpPath = (CCharPointer)UnsafeStackValue.get(buflen);
        UnsignedWord pathSize = Unistd.confstr(Unistd._CS_DARWIN_USER_TEMP_DIR(), tmpPath, WordFactory.unsigned((int)buflen));
        if (pathSize.aboveThan(0) && pathSize.belowOrEqual(buflen)) {
            return CTypeConversion.toJavaString((CCharPointer)tmpPath);
        }
        return "/var/tmp";
    }

    @Override
    protected String javaLibraryPathValue() {
        CCharPointer dyldLibraryPath;
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)"DYLD_LIBRARY_PATH");){
            dyldLibraryPath = Stdlib.getenv(name.get());
        }
        if (dyldLibraryPath.isNull()) {
            return ".";
        }
        return CTypeConversion.toJavaString((CCharPointer)dyldLibraryPath) + ":.";
    }

    @Override
    protected String osNameValue() {
        return Platform.includedIn(Platform.IOS.class) ? "iOS" : "Mac OS X";
    }

    @Override
    protected String osVersionValue() {
        CCharPointer osVersionStr;
        if (osVersionValue != null) {
            return osVersionValue;
        }
        Foundation.NSOperatingSystemVersion osVersion = UnsafeStackValue.get(Foundation.NSOperatingSystemVersion.class);
        Foundation.operatingSystemVersion(osVersion);
        if (osVersion.isNonNull()) {
            long major = osVersion.getMajorVersion();
            long minor = osVersion.getMinorVersion();
            long patch = osVersion.getPatchVersion();
            if (major == 10L && minor >= 16L && patch == 0L) {
                CCharPointer osVersionStr2 = Foundation.systemVersionPlatform();
                if (osVersionStr2.isNonNull()) {
                    osVersionValue = CTypeConversion.toJavaString((CCharPointer)osVersionStr2);
                    UntrackedNullableNativeMemory.free((PointerBase)osVersionStr2);
                    return osVersionValue;
                }
            } else {
                if (patch == 0L) {
                    osVersionValue = major + "." + minor;
                    return osVersionValue;
                }
                osVersionValue = major + "." + minor + "." + patch;
                return osVersionValue;
            }
        }
        if ((osVersionStr = Foundation.systemVersionPlatformFallback()).isNonNull()) {
            osVersionValue = CTypeConversion.toJavaString((CCharPointer)osVersionStr);
            UntrackedNullableNativeMemory.free((PointerBase)osVersionStr);
            return osVersionValue;
        }
        osVersionValue = "Unknown";
        return "Unknown";
    }
}

