/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.util.UserError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public abstract class PosixSubstrateSigprofHandler
extends SubstrateSigprofHandler {
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSigprofHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in sigprof signal handler.")
    @Uninterruptible(reason="Signal handler may only execute uninterruptible code.")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (PosixSubstrateSigprofHandler.tryEnterIsolate()) {
            CodePointer ip = (CodePointer)RegisterDumper.singleton().getIP(uContext);
            Pointer sp = (Pointer)RegisterDumper.singleton().getSP(uContext);
            PosixSubstrateSigprofHandler.tryUninterruptibleStackWalk(ip, sp, true);
        }
    }

    @Override
    protected void installSignalHandler() {
        PosixUtils.installSignalHandler(Signal.SignalEnum.SIGPROF, (Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer(), Signal.SA_RESTART());
    }

    static boolean isSignalHandlerBasedExecutionSamplerEnabled() {
        if (Options.SignalHandlerBasedExecutionSampler.hasBeenSet()) {
            return Options.SignalHandlerBasedExecutionSampler.getValue();
        }
        return PosixSubstrateSigprofHandler.isPlatformSupported();
    }

    private static boolean isPlatformSupported() {
        return (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) && SubstrateOptions.EnableSignalHandling.getValue() != false;
    }

    private static void validateSamplerOption(HostedOptionKey<Boolean> isSamplerEnabled) {
        if (isSamplerEnabled.getValue().booleanValue()) {
            UserError.guarantee(PosixSubstrateSigprofHandler.isPlatformSupported(), "The %s cannot be used to profile on this platform.", SubstrateOptionsParser.commandArgument(isSamplerEnabled, "+"));
        }
    }

    static class Options {
        public static final HostedOptionKey<Boolean> SignalHandlerBasedExecutionSampler = new HostedOptionKey<Object>(null, PosixSubstrateSigprofHandler::validateSamplerOption);

        Options() {
        }
    }
}

