/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckImpl;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckNode;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.Map;
import java.util.function.Predicate;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class StackOverflowCheckSnippets
extends SubstrateTemplates
implements Snippets {
    private final Predicate<ResolvedJavaMethod> mustNotAllocatePredicate;
    private final SnippetTemplate.SnippetInfo stackOverflowCheck;

    @Snippet
    private static void stackOverflowCheckSnippet(@Snippet.ConstantParameter boolean mustNotAllocate, @Snippet.ConstantParameter boolean hasDeoptFrameSize, long deoptFrameSize) {
        UnsignedWord stackBoundary = StackOverflowCheckImpl.stackBoundaryTL.get();
        if (hasDeoptFrameSize) {
            stackBoundary = stackBoundary.add(WordFactory.unsigned((long)deoptFrameSize));
        }
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)KnownIntrinsics.readStackPointer().belowOrEqual(stackBoundary))) {
            if (mustNotAllocate) {
                StackOverflowCheckSnippets.callSlowPath(StackOverflowCheckImpl.THROW_CACHED_STACK_OVERFLOW_ERROR);
            } else {
                StackOverflowCheckSnippets.callSlowPath(StackOverflowCheckImpl.THROW_NEW_STACK_OVERFLOW_ERROR);
            }
            throw UnreachableNode.unreachable();
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    StackOverflowCheckSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate) {
        super(options, providers);
        this.stackOverflowCheck = this.snippet(providers, StackOverflowCheckSnippets.class, "stackOverflowCheckSnippet", new LocationIdentity[]{StackOverflowCheckImpl.stackBoundaryTL.getLocationIdentity()});
        this.mustNotAllocatePredicate = mustNotAllocatePredicate;
        lowerings.put(StackOverflowCheckNode.class, new StackOverflowCheckLowering());
    }

    final class StackOverflowCheckLowering
    implements NodeLoweringProvider<StackOverflowCheckNode> {
        StackOverflowCheckLowering() {
        }

        @Override
        public void lower(StackOverflowCheckNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            long deoptFrameSize = StackOverflowCheckImpl.computeDeoptFrameSize(graph);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(StackOverflowCheckSnippets.this.stackOverflowCheck, graph.getGuardsStage(), tool.getLoweringStage());
            args.addConst("mustNotAllocate", (Object)(StackOverflowCheckSnippets.this.mustNotAllocatePredicate != null && StackOverflowCheckSnippets.this.mustNotAllocatePredicate.test(graph.method()) ? 1 : 0));
            args.addConst("hasDeoptFrameSize", (Object)(deoptFrameSize > 0L ? 1 : 0));
            args.add("deoptFrameSize", (Object)deoptFrameSize);
            StackOverflowCheckSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

