/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SafeSignedDivNode;
import com.oracle.svm.core.graal.snippets.SafeSignedRemNode;
import com.oracle.svm.core.graal.snippets.SafeUnsignedDivNode;
import com.oracle.svm.core.graal.snippets.SafeUnsignedRemNode;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.SignedDivNode;
import jdk.graal.compiler.nodes.calc.SignedRemNode;
import jdk.graal.compiler.nodes.calc.UnsignedDivNode;
import jdk.graal.compiler.nodes.calc.UnsignedRemNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public abstract class ArithmeticSnippets
extends SubstrateTemplates
implements Snippets {
    private final ObjectLayout layout = ConfigurationValues.getObjectLayout();
    private final SnippetTemplate.SnippetInfo idiv;
    private final SnippetTemplate.SnippetInfo ldiv;
    private final SnippetTemplate.SnippetInfo irem;
    private final SnippetTemplate.SnippetInfo lrem;
    private final SnippetTemplate.SnippetInfo uidiv;
    private final SnippetTemplate.SnippetInfo uldiv;
    private final SnippetTemplate.SnippetInfo uirem;
    private final SnippetTemplate.SnippetInfo ulrem;

    @Snippet
    protected static int idivSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck, @Snippet.ConstantParameter boolean needsBoundsCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        if (needsBoundsCheck && BranchProbabilityNode.probability((double)0.010000000000000009, (x == Integer.MIN_VALUE ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.010000000000000009, (y == -1 ? 1 : 0) != 0)) {
            return Integer.MIN_VALUE;
        }
        return ArithmeticSnippets.safeDiv(x, y);
    }

    @Snippet
    protected static long ldivSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck, @Snippet.ConstantParameter boolean needsBoundsCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        if (needsBoundsCheck && BranchProbabilityNode.probability((double)0.010000000000000009, (x == Long.MIN_VALUE ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.010000000000000009, (y == -1L ? 1 : 0) != 0)) {
            return Long.MIN_VALUE;
        }
        return ArithmeticSnippets.safeDiv(x, y);
    }

    @Snippet
    protected static int iremSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck, @Snippet.ConstantParameter boolean needsBoundsCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        if (needsBoundsCheck && BranchProbabilityNode.probability((double)0.010000000000000009, (x == Integer.MIN_VALUE ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.010000000000000009, (y == -1 ? 1 : 0) != 0)) {
            return 0;
        }
        return ArithmeticSnippets.safeRem(x, y);
    }

    @Snippet
    protected static long lremSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck, @Snippet.ConstantParameter boolean needsBoundsCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        if (needsBoundsCheck && BranchProbabilityNode.probability((double)0.010000000000000009, (x == Long.MIN_VALUE ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.010000000000000009, (y == -1L ? 1 : 0) != 0)) {
            return 0L;
        }
        return ArithmeticSnippets.safeRem(x, y);
    }

    @Snippet
    protected static int uidivSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        return ArithmeticSnippets.safeUDiv(x, y);
    }

    @Snippet
    protected static long uldivSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        return ArithmeticSnippets.safeUDiv(x, y);
    }

    @Snippet
    protected static int uiremSnippet(int x, int y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        return ArithmeticSnippets.safeURem(x, y);
    }

    @Snippet
    protected static long ulremSnippet(long x, long y, @Snippet.ConstantParameter boolean needsZeroCheck) {
        if (needsZeroCheck) {
            ArithmeticSnippets.zeroCheck(y);
        }
        return ArithmeticSnippets.safeURem(x, y);
    }

    private static void zeroCheck(int val) {
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (val == 0 ? 1 : 0) != 0)) {
            DeoptimizeNode.deopt((DeoptimizationAction)DeoptimizationAction.None, (DeoptimizationReason)DeoptimizationReason.ArithmeticException);
            throw UnreachableNode.unreachable();
        }
    }

    private static void zeroCheck(long val) {
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (val == 0L ? 1 : 0) != 0)) {
            DeoptimizeNode.deopt((DeoptimizationAction)DeoptimizationAction.None, (DeoptimizationReason)DeoptimizationReason.ArithmeticException);
            throw UnreachableNode.unreachable();
        }
    }

    @Node.NodeIntrinsic(value=SafeSignedDivNode.class)
    private static native int safeDiv(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeSignedDivNode.class)
    private static native long safeDiv(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeSignedRemNode.class)
    private static native int safeRem(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeSignedRemNode.class)
    private static native long safeRem(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeUnsignedDivNode.class)
    private static native int safeUDiv(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeUnsignedDivNode.class)
    private static native long safeUDiv(long var0, long var2);

    @Node.NodeIntrinsic(value=SafeUnsignedRemNode.class)
    private static native int safeURem(int var0, int var1);

    @Node.NodeIntrinsic(value=SafeUnsignedRemNode.class)
    private static native long safeURem(long var0, long var2);

    protected ArithmeticSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean divRemNeedsSignedBoundsCheck) {
        super(options, providers);
        this.idiv = this.snippet(providers, ArithmeticSnippets.class, "idivSnippet", new LocationIdentity[0]);
        this.ldiv = this.snippet(providers, ArithmeticSnippets.class, "ldivSnippet", new LocationIdentity[0]);
        this.irem = this.snippet(providers, ArithmeticSnippets.class, "iremSnippet", new LocationIdentity[0]);
        this.lrem = this.snippet(providers, ArithmeticSnippets.class, "lremSnippet", new LocationIdentity[0]);
        this.uidiv = this.snippet(providers, ArithmeticSnippets.class, "uidivSnippet", new LocationIdentity[0]);
        this.uldiv = this.snippet(providers, ArithmeticSnippets.class, "uldivSnippet", new LocationIdentity[0]);
        this.uirem = this.snippet(providers, ArithmeticSnippets.class, "uiremSnippet", new LocationIdentity[0]);
        this.ulrem = this.snippet(providers, ArithmeticSnippets.class, "ulremSnippet", new LocationIdentity[0]);
        lowerings.put(SignedDivNode.class, new DivRemLowering(divRemNeedsSignedBoundsCheck));
        lowerings.put(SignedRemNode.class, new DivRemLowering(divRemNeedsSignedBoundsCheck));
        lowerings.put(UnsignedDivNode.class, new DivRemLowering(divRemNeedsSignedBoundsCheck));
        lowerings.put(UnsignedRemNode.class, new DivRemLowering(divRemNeedsSignedBoundsCheck));
        lowerings.put(SafeSignedDivNode.class, new IdentityLowering());
        lowerings.put(SafeSignedRemNode.class, new IdentityLowering());
        lowerings.put(SafeUnsignedDivNode.class, new IdentityLowering());
        lowerings.put(SafeUnsignedRemNode.class, new IdentityLowering());
    }

    protected class DivRemLowering
    implements NodeLoweringProvider<IntegerDivRemNode> {
        private final boolean needsSignedBoundsCheck;

        protected DivRemLowering(boolean needsSignedBoundsCheck) {
            this.needsSignedBoundsCheck = needsSignedBoundsCheck;
        }

        @Override
        public void lower(IntegerDivRemNode node, LoweringTool tool) {
            SnippetTemplate.SnippetInfo snippet;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            assert (node.getStackKind() == JavaKind.Int || node.getStackKind() == JavaKind.Long);
            if (node instanceof SignedDivNode) {
                snippet = node.getStackKind() == JavaKind.Int ? ArithmeticSnippets.this.idiv : ArithmeticSnippets.this.ldiv;
            } else if (node instanceof SignedRemNode) {
                snippet = node.getStackKind() == JavaKind.Int ? ArithmeticSnippets.this.irem : ArithmeticSnippets.this.lrem;
            } else if (node instanceof UnsignedDivNode) {
                snippet = node.getStackKind() == JavaKind.Int ? ArithmeticSnippets.this.uidiv : ArithmeticSnippets.this.uldiv;
            } else if (node instanceof UnsignedRemNode) {
                snippet = node.getStackKind() == JavaKind.Int ? ArithmeticSnippets.this.uirem : ArithmeticSnippets.this.ulrem;
            } else {
                throw VMError.shouldNotReachHereUnexpectedInput(node);
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("x", (Object)node.getX());
            args.add("y", (Object)node.getY());
            IntegerStamp yStamp = (IntegerStamp)node.getY().stamp(NodeView.DEFAULT);
            boolean needsZeroCheck = node.canDeoptimize() && node.getZeroGuard() == null && yStamp.contains(0L);
            args.addConst("needsZeroCheck", (Object)needsZeroCheck);
            if (node instanceof SignedDivNode || node instanceof SignedRemNode) {
                args.addConst("needsBoundsCheck", (Object)this.needsSignedBoundsCheck);
            }
            ArithmeticSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    public static class IdentityLowering
    implements NodeLoweringProvider<Node> {
        @Override
        public void lower(Node node, LoweringTool tool) {
        }
    }
}

