/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.LegacyResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourceMetadataParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;

public abstract class ResourceConfigurationParser<C>
extends ConfigurationParser {
    protected final ResourcesRegistry<C> registry;
    protected final ConfigurationConditionResolver<C> conditionResolver;

    public static <C> ResourceConfigurationParser<C> create(boolean strictMetadata, ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, boolean strictConfiguration) {
        if (strictMetadata) {
            return new ResourceMetadataParser<C>(conditionResolver, registry, strictConfiguration);
        }
        return new LegacyResourceConfigurationParser<C>(conditionResolver, registry, strictConfiguration);
    }

    protected ResourceConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, boolean strictConfiguration) {
        super(strictConfiguration);
        this.registry = registry;
        this.conditionResolver = conditionResolver;
    }

    protected void parseBundlesObject(Object bundlesObject) {
        List<Object> bundles = ResourceConfigurationParser.asList(bundlesObject, "Attribute 'bundles' must be a list of bundles");
        for (Object bundle : bundles) {
            this.parseBundle(bundle);
        }
    }

    protected void parseResourcesObject(Object resourcesObject) {
        block4: {
            block3: {
                if (!(resourcesObject instanceof EconomicMap)) break block3;
                EconomicMap resourcesObjectMap = (EconomicMap)resourcesObject;
                this.checkAttributes((EconomicMap<String, Object>)resourcesObjectMap, "resource descriptor object", Collections.singleton("includes"), Collections.singleton("excludes"));
                Object includesObject = resourcesObjectMap.get((Object)"includes");
                Object excludesObject = resourcesObjectMap.get((Object)"excludes");
                List<Object> includes = ResourceConfigurationParser.asList(includesObject, "Attribute 'includes' must be a list of resources");
                for (Object object : includes) {
                    this.parsePatternEntry(object, this.registry::addResources, "'includes' list");
                }
                if (excludesObject == null) break block4;
                List<Object> excludes = ResourceConfigurationParser.asList(excludesObject, "Attribute 'excludes' must be a list of resources");
                for (Object object : excludes) {
                    this.parsePatternEntry(object, this.registry::ignoreResources, "'excludes' list");
                }
                break block4;
            }
            List<Object> resources = ResourceConfigurationParser.asList(resourcesObject, "Attribute 'resources' must be a list of resources");
            for (Object object : resources) {
                this.parsePatternEntry(object, this.registry::addResources, "'resources' list");
            }
        }
    }

    private void parseBundle(Object bundle) {
        Object classNames;
        List<Locale> asList;
        EconomicMap<String, Object> resource = ResourceConfigurationParser.asMap(bundle, "Elements of 'bundles' list must be a bundle descriptor object");
        this.checkAttributes(resource, "bundle descriptor object", Collections.singletonList("name"), Arrays.asList("locales", "classNames", "condition"));
        String basename = ResourceConfigurationParser.asString(resource.get((Object)"name"));
        TypeResult<C> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(resource, false));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object locales = resource.get((Object)"locales");
        if (locales != null && !(asList = ResourceConfigurationParser.asList(locales, "Attribute 'locales' must be a list of locales").stream().map(ResourceConfigurationParser::parseLocale).collect(Collectors.toList())).isEmpty()) {
            this.registry.addResourceBundles(resolvedConfigurationCondition.get(), basename, asList);
        }
        if ((classNames = resource.get((Object)"classNames")) != null) {
            List<Object> asList2 = ResourceConfigurationParser.asList(classNames, "Attribute 'classNames' must be a list of classes");
            for (Object o : asList2) {
                String className = ResourceConfigurationParser.asString(o);
                this.registry.addClassBasedResourceBundle(resolvedConfigurationCondition.get(), basename, className);
            }
        }
        if (locales == null && classNames == null) {
            this.registry.addResourceBundles(resolvedConfigurationCondition.get(), basename);
        }
    }

    private static Locale parseLocale(Object input) {
        String localeTag = ResourceConfigurationParser.asString(input);
        Locale locale = LocalizationSupport.parseLocaleFromTag(localeTag);
        if (locale == null) {
            throw new JsonParserException(localeTag + " is not a valid locale tag");
        }
        return locale;
    }

    private void parsePatternEntry(Object data, BiConsumer<C, String> resourceRegistry, String parentType) {
        EconomicMap<String, Object> resource = ResourceConfigurationParser.asMap(data, "Elements of " + parentType + " must be a resource descriptor object");
        this.checkAttributes(resource, "regex resource descriptor object", Collections.singletonList("pattern"), Collections.singletonList("condition"));
        TypeResult<C> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(resource, false));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object valueObject = resource.get((Object)"pattern");
        String value = ResourceConfigurationParser.asString(valueObject, "pattern");
        resourceRegistry.accept(resolvedConfigurationCondition.get(), value);
    }

    protected void parseGlobsObject(Object globsObject) {
        List<Object> globs = ResourceConfigurationParser.asList(globsObject, "Attribute 'globs' must be a list of glob patterns");
        for (Object object : globs) {
            this.parseGlobEntry(object, (arg_0, arg_1, arg_2) -> this.registry.addGlob(arg_0, arg_1, arg_2));
        }
    }

    private void parseGlobEntry(Object data, GlobPatternConsumer<C> resourceRegistry) {
        EconomicMap<String, Object> globObject = ResourceConfigurationParser.asMap(data, "Elements of 'globs' list must be a glob descriptor objects");
        this.checkAttributes(globObject, "glob resource descriptor object", Collections.singletonList("glob"), List.of("condition", "module"));
        TypeResult<C> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(globObject, false));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object moduleObject = globObject.get((Object)"module");
        String module = ResourceConfigurationParser.asNullableString(moduleObject, "module");
        Object valueObject = globObject.get((Object)"glob");
        String value = ResourceConfigurationParser.asString(valueObject, "glob");
        resourceRegistry.accept(resolvedConfigurationCondition.get(), module, value);
    }

    private static interface GlobPatternConsumer<T> {
        public void accept(T var1, String var2, String var3);
    }
}

