/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class ClassLoaderSupport {
    public boolean isNativeImageClassLoader(ClassLoader classLoader) {
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            if (!this.isNativeImageClassLoaderImpl(loader)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isNativeImageClassLoaderImpl(ClassLoader var1);

    public abstract void collectResources(ResourceCollector var1);

    public abstract List<ResourceBundle> getResourceBundle(String var1, Locale var2);

    public abstract Map<String, Set<Module>> getPackageToModules();

    public static interface ResourceCollector {
        public List<ConfigurationCondition> isIncluded(Module var1, String var2, URI var3);

        public void addResourceEntry(Module var1, String var2);

        public void addResourceConditionally(Module var1, String var2, ConfigurationCondition var3);

        public void registerNegativeQuery(Module var1, String var2);

        public void registerIOException(Module var1, String var2, IOException var3, boolean var4);
    }
}

