/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateMemoryAccessProvider;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedConstantReflectionProvider;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class HostedMemoryAccessProvider
implements SubstrateMemoryAccessProvider {
    private final HostedMetaAccess hMetaAccess;
    private final HostedConstantReflectionProvider hConstantReflection;

    public HostedMemoryAccessProvider(HostedMetaAccess hMetaAccess, HostedConstantReflectionProvider hConstantReflection) {
        this.hMetaAccess = hMetaAccess;
        this.hConstantReflection = hConstantReflection;
    }

    public JavaConstant readPrimitiveConstant(JavaKind stackKind, Constant base, long displacement, int bits) {
        JavaConstant result = this.doRead(stackKind, (JavaConstant)base, displacement);
        if (result == null) {
            return null;
        }
        return switch (stackKind) {
            case JavaKind.Int -> JavaConstant.forInt((int)result.asInt());
            case JavaKind.Long, JavaKind.Float, JavaKind.Double -> {
                if (!$assertionsDisabled && result.getJavaKind() != stackKind) {
                    throw new AssertionError();
                }
                yield result;
            }
            default -> throw VMError.shouldNotReachHereUnexpectedInput(stackKind);
        };
    }

    public JavaConstant readObjectConstant(Constant base, long displacement) {
        return this.doRead(JavaKind.Object, (JavaConstant)base, displacement);
    }

    @Override
    public JavaConstant readNarrowObjectConstant(Constant base, long displacement, CompressEncoding encoding) {
        assert (SubstrateOptions.SpawnIsolates.getValue().booleanValue());
        JavaConstant result = this.readObjectConstant(base, displacement);
        if (result == null) {
            return null;
        }
        if (JavaConstant.NULL_POINTER.equals((Object)result)) {
            return CompressedNullConstant.COMPRESSED_NULL;
        }
        return ((CompressibleConstant)result).compress();
    }

    private JavaConstant doRead(JavaKind stackKind, JavaConstant base, long displacement) {
        if (base.getJavaKind() != JavaKind.Object) {
            return null;
        }
        HostedType type = this.hMetaAccess.lookupJavaType(base);
        HostedField field = (HostedField)type.findInstanceFieldWithOffset(displacement, null);
        if (field == null) {
            return null;
        }
        assert (field.getStorageKind().getStackKind() == stackKind);
        JavaConstant result = this.hConstantReflection.readFieldValue(field, base);
        if (result.getJavaKind().getStackKind() != stackKind) {
            return null;
        }
        return result;
    }
}

