/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public abstract class CustomSubstitutionMethod
implements ResolvedJavaMethod,
GraphProvider,
OriginalMethodProvider,
AnnotationWrapper {
    protected final ResolvedJavaMethod original;

    public CustomSubstitutionMethod(ResolvedJavaMethod original) {
        this.original = original;
    }

    public ResolvedJavaMethod getOriginal() {
        return this.original;
    }

    public boolean allowRuntimeCompilation() {
        return false;
    }

    public String getName() {
        return this.original.getName();
    }

    public Signature getSignature() {
        return new Signature(){
            private final Signature wrapped;
            {
                this.wrapped = CustomSubstitutionMethod.this.original.getSignature();
            }

            public int getParameterCount(boolean receiver) {
                return this.wrapped.getParameterCount(receiver);
            }

            public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
                JavaType result = this.wrapped.getParameterType(index, accessingClass);
                if (accessingClass != null && !(result instanceof ResolvedJavaType)) {
                    result = this.wrapped.getParameterType(index, CustomSubstitutionMethod.this.original.getDeclaringClass());
                }
                return result;
            }

            public JavaType getReturnType(ResolvedJavaType accessingClass) {
                JavaType result = this.wrapped.getReturnType(accessingClass);
                if (accessingClass != null && !(result instanceof ResolvedJavaType)) {
                    result = this.wrapped.getReturnType(CustomSubstitutionMethod.this.original.getDeclaringClass());
                }
                return result;
            }

            public String toString() {
                return "CustomSubstitutionMethod.Signature<" + String.valueOf(this.wrapped) + ">";
            }
        };
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public int getMaxLocals() {
        return this.getSignature().getParameterCount(!this.isStatic()) * 2;
    }

    public int getMaxStackSize() {
        return 2;
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.original.isVarArgs();
    }

    public boolean isBridge() {
        return this.original.isBridge();
    }

    public boolean isDefault() {
        return this.original.isDefault();
    }

    public boolean isClassInitializer() {
        return this.original.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.original.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.original.canBeStaticallyBound();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.original.asStackTraceElement(0);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.intentionallyUnimplemented();
    }

    public void reprofile() {
    }

    public ConstantPool getConstantPool() {
        return this.original.getConstantPool();
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.original.getParameters();
    }

    public Annotation[][] getParameterAnnotations() {
        return this.original.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.original.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return this.original.canBeInlined();
    }

    public boolean hasNeverInlineDirective() {
        return this.original.hasNeverInlineDirective();
    }

    public boolean shouldBeInlined() {
        return this.original.shouldBeInlined();
    }

    public LineNumberTable getLineNumberTable() {
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.intentionallyUnimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.intentionallyUnimplemented();
    }

    public Executable getJavaMethod() {
        return OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)this.original);
    }
}

