/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonWriter;
import com.oracle.svm.hosted.BuildArtifactsExporter;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.CodeBreakdownProvider;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.hosted.ProgressReporterCHelper;
import com.oracle.svm.hosted.ProgressReporterFeature;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.util.CPUType;
import com.oracle.svm.hosted.util.DiagnosticUtils;
import com.oracle.svm.hosted.util.JDKArgsUtils;
import com.oracle.svm.hosted.util.VMErrorReporter;
import com.oracle.svm.util.ImageBuildStatistics;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;

public class ProgressReporter {
    private static final boolean IS_CI = SubstrateUtil.isRunningInCI();
    private static final int CHARACTERS_PER_LINE = IS_CI ? 120 : ProgressReporterCHelper.getTerminalWindowColumnsClamped();
    private static final String HEADLINE_SEPARATOR = Utils.stringFilledWith(CHARACTERS_PER_LINE, "=");
    private static final String LINE_SEPARATOR = Utils.stringFilledWith(CHARACTERS_PER_LINE, "-");
    private static final int MAX_NUM_BREAKDOWN = 10;
    public static final String DOCS_BASE_URL = "https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/BuildOutput.md";
    private static final double EXCESSIVE_GC_MIN_THRESHOLD_MILLIS = 15000.0;
    private static final double EXCESSIVE_GC_RATIO = 0.5;
    private final NativeImageSystemIOWrappers builderIO;
    public final ProgressReporterJsonHelper jsonHelper;
    private final DirectPrinter linePrinter = new DirectPrinter();
    private final StringBuilder buildOutputLog = new StringBuilder();
    private final StagePrinter<?> stagePrinter;
    private final ColorStrategy colorStrategy;
    private final LinkStrategy linkStrategy;
    private final boolean usePrefix;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private String outputPrefix = "";
    private long lastGCCheckTimeMillis = System.currentTimeMillis();
    private GCStats lastGCStats = GCStats.getCurrent();
    private long numRuntimeCompiledMethods = -1L;
    private int numJNIClasses = -1;
    private int numJNIFields = -1;
    private int numJNIMethods = -1;
    private int numForeignDowncalls = -1;
    private Timer debugInfoTimer;
    private boolean creationStageEndCompleted = false;

    public static ProgressReporter singleton() {
        return (ProgressReporter)ImageSingletons.lookup(ProgressReporter.class);
    }

    public ProgressReporter(OptionValues options) {
        this.builderIO = (Boolean)SubstrateOptions.BuildOutputSilent.getValue(options) != false ? NativeImageSystemIOWrappers.disabled() : NativeImageSystemIOWrappers.singleton();
        this.jsonHelper = new ProgressReporterJsonHelper();
        this.usePrefix = (Boolean)SubstrateOptions.BuildOutputPrefix.getValue(options);
        boolean enableColors = SubstrateOptions.hasColorsEnabled(options);
        this.colorStrategy = enableColors ? new ColorfulStrategy() : new ColorlessStrategy();
        this.stagePrinter = (Boolean)SubstrateOptions.BuildOutputProgress.getValue(options) != false ? new CharacterwiseStagePrinter() : new LinewiseStagePrinter(this);
        this.linkStrategy = (Boolean)SubstrateOptions.BuildOutputLinks.getValue(options) != false ? new LinkyStrategy() : new LinklessStrategy();
    }

    public void setNumRuntimeCompiledMethods(int value) {
        this.numRuntimeCompiledMethods = value;
    }

    public void setJNIInfo(int numClasses, int numFields, int numMethods) {
        this.numJNIClasses = numClasses;
        this.numJNIFields = numFields;
        this.numJNIMethods = numMethods;
    }

    public void setForeignFunctionsInfo(int numDowncalls) {
        this.numForeignDowncalls = numDowncalls;
    }

    public void printStart(String imageName, AbstractImage.NativeImageKind imageKind) {
        if (this.usePrefix) {
            this.outputPrefix = String.format("[%s:%s] ", imageName, GraalServices.getExecutionID());
            this.stagePrinter.progressBarStart += this.outputPrefix.length();
        }
        this.l().printHeadlineSeparator();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.IMAGE_NAME, imageName);
        String imageKindName = imageKind.name().toLowerCase().replace('_', ' ');
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().blueBold()).link("GraalVM Native Image", "https://www.graalvm.org/native-image/")).reset()).a(": Generating '").bold()).a(imageName).reset()).a("' (").doclink(imageKindName, "#glossary-imagekind")).a(")...").println();
        this.l().printHeadlineSeparator();
        if (!this.linkStrategy.isTerminalSupported()) {
            this.l().a("For detailed information and explanations on the build output, visit:").println();
            this.l().a(DOCS_BASE_URL).println();
            this.l().printLineSeparator();
        }
        this.stagePrinter.start(BuildStage.INITIALIZING);
    }

    public void printUnsuccessfulInitializeEnd() {
        if (this.stagePrinter.activeBuildStage != null) {
            this.stagePrinter.end(0.0);
        }
    }

    public void printInitializeEnd(List<Feature> features, ImageClassLoader classLoader) {
        this.stagePrinter.end(ProgressReporter.getTimer(TimerCollection.Registry.CLASSLIST).getTotalTime() + ProgressReporter.getTimer(TimerCollection.Registry.SETUP).getTotalTime());
        VM vm = (VM)ImageSingletons.lookup(VM.class);
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.JAVA_VERSION, vm.version);
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.VENDOR_VERSION, vm.vendorVersion);
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GRAALVM_VERSION, vm.vendorVersion);
        ((DirectPrinter)((DirectPrinter)this.l().a(" ").doclink("Java version", "#glossary-java-info")).a(": ").a(vm.version).a(", ").doclink("vendor version", "#glossary-java-info")).a(": ").a(vm.vendorVersion).println();
        String optimizationLevel = SubstrateOptions.Optimize.getValue();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_OPTIMIZATION_LEVEL, optimizationLevel);
        String march = CPUType.getSelectedOrDefaultMArch();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_MARCH, march);
        DirectPrinter graalLine = (DirectPrinter)((DirectPrinter)this.l().a(" ").doclink("Graal compiler", "#glossary-graal-compiler")).a(": optimization level: %s, target machine: %s", optimizationLevel, march);
        ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).appendGraalSuffix(graalLine);
        graalLine.println();
        String cCompilerShort = null;
        if (ImageSingletons.contains(CCompilerInvoker.class)) {
            cCompilerShort = ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.getShortDescription();
            ((DirectPrinter)this.l().a(" ").doclink("C compiler", "#glossary-ccompiler")).a(": ").a(cCompilerShort).println();
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.CC, cCompilerShort);
        String gcName = Heap.getHeap().getGC().getName();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GC, gcName);
        long maxHeapSize = SubstrateGCOptions.MaxHeapSize.getValue();
        String maxHeapValue = maxHeapSize == 0L ? Heap.getHeap().getGC().getDefaultMaxHeapSize() : ByteFormattingUtil.bytesToHuman(maxHeapSize);
        ((DirectPrinter)((DirectPrinter)this.l().a(" ").doclink("Garbage collector", "#glossary-gc")).a(": ").a(gcName).a(" (").doclink("max heap size", "#glossary-gc-max-heap-size")).a(": ").a(maxHeapValue).a(")").println();
        this.printFeatures(features);
        this.printExperimentalOptions(classLoader);
        this.printEnvironmentVariableOptions();
        this.printResourceInfo();
    }

    private void printFeatures(List<Feature> features) {
        int numFeatures = features.size();
        if (numFeatures > 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a(" ").a(numFeatures)).a(" ").doclink("user-specific feature(s)", "#glossary-user-specific-features")).a(":").println();
            features.sort(Comparator.comparing(a -> a.getClass().getName()));
            for (Feature feature : features) {
                ProgressReporter.printFeature(this.l(), feature);
            }
        }
    }

    private static void printFeature(DirectPrinter printer, Feature feature) {
        printer.a(" - ");
        String name = feature.getClass().getName();
        String url = feature.getURL();
        if (url != null) {
            printer.link(name, url);
        } else {
            printer.a(name);
        }
        String description = feature.getDescription();
        if (description != null) {
            printer.a(": ").a(description);
        }
        printer.println();
    }

    private void printExperimentalOptions(ImageClassLoader classLoader) {
        HashMap<String, OptionOrigin> experimentalBuilderOptionsAndOrigins = new HashMap<String, OptionOrigin>();
        for (String arg : DiagnosticUtils.getBuilderArguments(classLoader)) {
            OptionOrigin optionOrigin;
            if (!arg.startsWith("-H:")) continue;
            String[] optionParts = arg.split("=", 2)[0].split("@", 2);
            OptionOrigin optionOrigin2 = optionOrigin = optionParts.length == 2 ? OptionOrigin.from(optionParts[1], false) : null;
            if (optionOrigin != null && ProgressReporter.isStableOrInternalOrigin(optionOrigin)) continue;
            String prefixedOptionName = optionParts[0];
            experimentalBuilderOptionsAndOrigins.put(prefixedOptionName, optionOrigin);
        }
        if (experimentalBuilderOptionsAndOrigins.isEmpty()) {
            return;
        }
        HashMap<CallSite, ExperimentalOptionDetails> experimentalOptions = new HashMap<CallSite, ExperimentalOptionDetails>();
        UnmodifiableEconomicMap hostedOptionValues = HostedOptionValues.singleton().getMap();
        for (OptionKey optionKey : hostedOptionValues.getKeys()) {
            String prefixedOptionName;
            if (optionKey instanceof RuntimeOptionKey || optionKey == SubstrateOptions.UnlockExperimentalVMOptions || optionKey.getDescriptor().getStability() != OptionStability.EXPERIMENTAL) continue;
            OptionDescriptor descriptor = optionKey.getDescriptor();
            Object optionValue = optionKey.getValueOrDefault(hostedOptionValues);
            String emptyOrBooleanValue = "";
            if (descriptor.getOptionValueType() == Boolean.class) {
                String string = emptyOrBooleanValue = Boolean.parseBoolean(optionValue.toString()) ? "+" : "-";
            }
            if (!experimentalBuilderOptionsAndOrigins.containsKey(prefixedOptionName = "-H:" + emptyOrBooleanValue + optionKey.getName())) continue;
            String origins = "";
            String migrationMessage = descriptor.getExtraHelp().isEmpty() ? "" : (String)descriptor.getExtraHelp().getFirst();
            String alternatives = "";
            if (optionValue instanceof LocatableMultiOptionValue) {
                LocatableMultiOptionValue lmov = (LocatableMultiOptionValue)optionValue;
                if (lmov.getValuesWithOrigins().allMatch(o -> ((OptionOrigin)o.getRight()).isStable())) continue;
                origins = lmov.getValuesWithOrigins().filter(p -> !ProgressReporter.isStableOrInternalOrigin((OptionOrigin)p.getRight())).map(p -> ((OptionOrigin)p.getRight()).toString()).collect(Collectors.joining(", "));
                alternatives = lmov.getValuesWithOrigins().map(p -> SubstrateOptionsParser.commandArgument(option, p.getLeft().toString())).filter(c -> !c.startsWith("-H:")).collect(Collectors.joining(", "));
            } else {
                String optionValueString;
                OptionOrigin origin = (OptionOrigin)experimentalBuilderOptionsAndOrigins.get(prefixedOptionName);
                if (origin == null && optionKey instanceof HostedOptionKey) {
                    HostedOptionKey hok = (HostedOptionKey)optionKey;
                    origin = hok.getLastOrigin();
                }
                if (origin == null || ProgressReporter.isStableOrInternalOrigin(origin)) continue;
                origins = origin.toString();
                if (descriptor.getOptionValueType() == Boolean.class) {
                    assert (!emptyOrBooleanValue.isEmpty());
                    optionValueString = emptyOrBooleanValue;
                } else {
                    optionValueString = String.valueOf(optionValue);
                }
                String command = SubstrateOptionsParser.commandArgument(optionKey, optionValueString);
                if (!command.startsWith("-H:")) {
                    alternatives = command;
                }
            }
            experimentalOptions.put((CallSite)((Object)prefixedOptionName), new ExperimentalOptionDetails(migrationMessage, alternatives, origins));
        }
        if (experimentalOptions.isEmpty()) {
            return;
        }
        this.l().printLineSeparator();
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().yellowBold()).a(" ").a(experimentalOptions.size())).a(" ").doclink("experimental option(s)", "#glossary-experimental-options")).a(" unlocked").reset()).a(":").println();
        for (Map.Entry entry : experimentalOptions.entrySet()) {
            ((DirectPrinter)this.l().a(" - '%s'%s", entry.getKey(), ((ExperimentalOptionDetails)entry.getValue()).toSuffix())).println();
        }
    }

    private static boolean isStableOrInternalOrigin(OptionOrigin origin) {
        return origin.isStable() || origin.isInternal();
    }

    private void printEnvironmentVariableOptions() {
        String envVarValue = SubstrateOptions.BuildOutputNativeImageOptionsEnvVarValue.getValue();
        if (envVarValue != null && !envVarValue.isEmpty()) {
            this.l().printLineSeparator();
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().yellowBold()).a(" ").doclink("Picked up NATIVE_IMAGE_OPTIONS", "#glossary-picked-up-ni-options")).reset()).a(":").println();
            for (String arg : JDKArgsUtils.parseArgsFromEnvVar(envVarValue, "NATIVE_IMAGE_OPTIONS", msg -> UserError.abort(msg, new Object[0]))) {
                ((DirectPrinter)this.l().a(" - '%s'", arg)).println();
            }
        }
    }

    private void printResourceInfo() {
        String xmxValueOrNull;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.GC_MAX_HEAP, maxMemory);
        long totalMemorySize = ProgressReporter.getOperatingSystemMXBean().getTotalMemorySize();
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.MEMORY_TOTAL, totalMemorySize);
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        List<String> maxRAMPrecentageValues = inputArguments.stream().filter(arg -> arg.startsWith("-XX:MaxRAMPercentage")).toList();
        String maxHeapSuffix = "determined at start";
        if (maxRAMPrecentageValues.size() > 1) {
            maxHeapSuffix = "set via '%s'".formatted(maxRAMPrecentageValues.get(maxRAMPrecentageValues.size() - 1));
        }
        if ((xmxValueOrNull = (String)inputArguments.stream().filter(arg -> arg.startsWith("-Xmx")).reduce((first, second) -> second).orElse(null)) != null) {
            maxHeapSuffix = "set via '%s'".formatted(xmxValueOrNull);
        }
        int maxNumberOfThreads = NativeImageOptions.getActualNumberOfThreads();
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.PARALLELISM, maxNumberOfThreads);
        int availableProcessors = runtime.availableProcessors();
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.CPU_CORES_TOTAL, availableProcessors);
        String maxNumberOfThreadsSuffix = "determined at start";
        if (NativeImageOptions.NumberOfThreads.hasBeenSet()) {
            maxNumberOfThreadsSuffix = "set via '%s'".formatted(SubstrateOptionsParser.commandArgument(NativeImageOptions.NumberOfThreads, Integer.toString(maxNumberOfThreads)));
        }
        this.l().printLineSeparator();
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().yellowBold()).doclink("Build resources", "#glossary-build-resources")).a(":").reset()).println();
        ((DirectPrinter)this.l().a(" - %.2fGB of memory (%.1f%% of %.2fGB system memory, %s)", ByteFormattingUtil.bytesToGiB(maxMemory), Utils.toPercentage(maxMemory, totalMemorySize), ByteFormattingUtil.bytesToGiB(totalMemorySize), maxHeapSuffix)).println();
        ((DirectPrinter)this.l().a(" - %s thread(s) (%.1f%% of %s available processor(s), %s)", maxNumberOfThreads, Utils.toPercentage(maxNumberOfThreads, availableProcessors), availableProcessors, maxNumberOfThreadsSuffix)).println();
    }

    public ReporterClosable printAnalysis(AnalysisUniverse universe, Collection<String> libraries) {
        return this.print(TimerCollection.Registry.ANALYSIS, BuildStage.ANALYSIS, () -> this.printAnalysisStatistics(universe, libraries));
    }

    private ReporterClosable print(TimerCollection.Registry registry, BuildStage buildStage) {
        return this.print(registry, buildStage, null);
    }

    private ReporterClosable print(TimerCollection.Registry registry, BuildStage buildStage, final Runnable extraPrint) {
        final Timer timer = ProgressReporter.getTimer(registry);
        timer.start();
        this.stagePrinter.start(buildStage);
        return new ReporterClosable(this){
            final /* synthetic */ ProgressReporter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void closeAction() {
                timer.stop();
                this.this$0.stagePrinter.end(timer);
                if (extraPrint != null) {
                    extraPrint.run();
                }
            }
        };
    }

    private void printAnalysisStatistics(AnalysisUniverse universe, Collection<String> libraries) {
        int numLibraries;
        String actualFormat = "%,9d ";
        String totalFormat = " (%4.1f%% of %,8d total)";
        long reachableTypes = universe.getTypes().stream().filter(AnalysisType::isReachable).count();
        long totalTypes = universe.getTypes().size();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_TOTAL, totalTypes);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_TOTAL, totalTypes);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_REACHABLE, reachableTypes);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_REACHABLE, reachableTypes);
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(actualFormat, reachableTypes)).doclink("reachable types", "#glossary-reachability")).a("  ").a(totalFormat, Utils.toPercentage(reachableTypes, totalTypes), totalTypes)).println();
        Collection fields = universe.getFields();
        long reachableFields = fields.stream().filter(AnalysisField::isAccessed).count();
        int totalFields = fields.size();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_TOTAL, totalFields);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_REACHABLE, reachableFields);
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(actualFormat, reachableFields)).doclink("reachable fields", "#glossary-reachability")).a(" ").a(totalFormat, Utils.toPercentage(reachableFields, totalFields), totalFields)).println();
        Collection methods = universe.getMethods();
        long reachableMethods = methods.stream().filter(AnalysisMethod::isReachable).count();
        int totalMethods = methods.size();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_TOTAL, totalMethods);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_REACHABLE, reachableMethods);
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(actualFormat, reachableMethods)).doclink("reachable methods", "#glossary-reachability")).a(totalFormat, Utils.toPercentage(reachableMethods, totalMethods), totalMethods)).println();
        if (this.numRuntimeCompiledMethods >= 0L) {
            this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.RUNTIME_COMPILED_METHODS_COUNT, this.numRuntimeCompiledMethods);
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(actualFormat, this.numRuntimeCompiledMethods)).doclink("runtime compiled methods", "#glossary-runtime-methods")).a(totalFormat, Utils.toPercentage(this.numRuntimeCompiledMethods, totalMethods), totalMethods)).println();
        }
        String typesFieldsMethodFormat = "%,9d types, %,5d fields, and %,5d methods ";
        int reflectClassesCount = ClassForNameSupport.count();
        ReflectionHostedSupport rs = (ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class);
        int reflectFieldsCount = rs.getReflectionFieldsCount();
        int reflectMethodsCount = rs.getReflectionMethodsCount();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_REFLECT, reflectMethodsCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_REFLECT, reflectClassesCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_REFLECT, reflectClassesCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_REFLECT, reflectFieldsCount);
        ((DirectPrinter)((DirectPrinter)this.l().a(typesFieldsMethodFormat, reflectClassesCount, reflectFieldsCount, reflectMethodsCount)).doclink("registered for reflection", "#glossary-reflection-registrations")).println();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_JNI, this.numJNIMethods >= 0 ? (long)this.numJNIMethods : -1L);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_JNI, this.numJNIClasses >= 0 ? (long)this.numJNIClasses : -1L);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_JNI, this.numJNIClasses >= 0 ? (long)this.numJNIClasses : -1L);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_JNI, this.numJNIFields >= 0 ? (long)this.numJNIFields : -1L);
        if (this.numJNIClasses >= 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a(typesFieldsMethodFormat, this.numJNIClasses, this.numJNIFields, this.numJNIMethods)).doclink("registered for JNI access", "#glossary-jni-access-registrations")).println();
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FOREIGN_DOWNCALLS, this.numForeignDowncalls >= 0 ? (long)this.numForeignDowncalls : -1L);
        if (this.numForeignDowncalls >= 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a("%,8d ", this.numForeignDowncalls)).doclink("foreign downcalls registered", "#glossary-foreign-downcall-registrations")).println();
        }
        if ((numLibraries = libraries.size()) > 0) {
            TreeSet<String> sortedLibraries = new TreeSet<String>(libraries);
            ((DirectPrinter)this.l().a("%,9d native %s: ", numLibraries, numLibraries == 1 ? "library" : "libraries")).a(String.join((CharSequence)", ", sortedLibraries)).println();
        }
    }

    public ReporterClosable printUniverse() {
        return this.print(TimerCollection.Registry.UNIVERSE, BuildStage.UNIVERSE);
    }

    public ReporterClosable printParsing() {
        return this.print(TimerCollection.Registry.PARSE, BuildStage.PARSING);
    }

    public ReporterClosable printInlining() {
        return this.print(TimerCollection.Registry.INLINE, BuildStage.INLINING);
    }

    public ReporterClosable printCompiling() {
        return this.print(TimerCollection.Registry.COMPILE, BuildStage.COMPILING);
    }

    public ReporterClosable printLayouting() {
        return this.print(TimerCollection.Registry.LAYOUT, BuildStage.LAYING_OUT);
    }

    public void printCreationStart() {
        this.stagePrinter.start(BuildStage.CREATING);
    }

    public void setDebugInfoTimer(Timer timer) {
        this.debugInfoTimer = timer;
    }

    public void printCreationEnd(int imageFileSize, int heapObjectCount, long imageHeapSize, int codeAreaSize, int numCompilations, int debugInfoSize) {
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.IMAGE_HEAP_OBJECT_COUNT, heapObjectCount);
        Timer imageTimer = ProgressReporter.getTimer(TimerCollection.Registry.IMAGE);
        Timer writeTimer = ProgressReporter.getTimer(TimerCollection.Registry.WRITE);
        this.stagePrinter.end(imageTimer.getTotalTime() + writeTimer.getTotalTime());
        this.creationStageEndCompleted = true;
        String format = "%9s (%5.2f%%) for ";
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(codeAreaSize), Utils.toPercentage(codeAreaSize, imageFileSize))).doclink("code area", "#glossary-code-area")).a(":%,10d compilation units", numCompilations)).println();
        int numResources = Resources.singleton().count();
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.IMAGE_HEAP_RESOURCE_COUNT, numResources);
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(imageHeapSize), Utils.toPercentage(imageHeapSize, imageFileSize))).doclink("image heap", "#glossary-image-heap")).a(":%,9d objects and %,d resources", heapObjectCount, numResources)).println();
        if (debugInfoSize > 0) {
            this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.DEBUG_INFO_SIZE, debugInfoSize);
            DirectPrinter l = (DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(debugInfoSize), Utils.toPercentage(debugInfoSize, imageFileSize))).doclink("debug info", "#glossary-debug-info");
            if (this.debugInfoTimer != null) {
                l.a(" generated in %.1fs", Utils.millisToSeconds(this.debugInfoTimer.getTotalTime()));
            }
            l.println();
        }
        long otherBytes = (long)(imageFileSize - codeAreaSize) - imageHeapSize - (long)debugInfoSize;
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.IMAGE_HEAP_SIZE, imageHeapSize);
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.TOTAL_SIZE, imageFileSize);
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.CODE_AREA_SIZE, codeAreaSize);
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.NUM_COMP_UNITS, numCompilations);
        ((DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(otherBytes), Utils.toPercentage(otherBytes, imageFileSize))).doclink("other data", "#glossary-other-data")).println();
        ((DirectPrinter)this.l().a("%9s in total", ByteFormattingUtil.bytesToHuman(imageFileSize))).println();
        this.printBreakdowns();
        ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).afterBreakdowns();
        this.printRecommendations();
    }

    public void ensureCreationStageEndCompleted() {
        if (!this.creationStageEndCompleted) {
            this.println();
        }
    }

    private void printBreakdowns() {
        if (!SubstrateOptions.BuildOutputBreakdowns.getValue().booleanValue()) {
            return;
        }
        this.l().printLineSeparator();
        Map<String, Long> codeBreakdown = CodeBreakdownProvider.get();
        Iterator packagesBySize = codeBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        HeapBreakdownProvider heapBreakdown = HeapBreakdownProvider.singleton();
        Iterator<HeapBreakdownProvider.HeapBreakdownEntry> typesBySizeInHeap = heapBreakdown.getSortedBreakdownEntries().iterator();
        TwoColumnPrinter p = new TwoColumnPrinter();
        ((TwoColumnPrinter)((TwoColumnPrinter)((TwoColumnPrinter)((TwoColumnPrinter)p.l()).yellowBold()).a(String.format("Top %d ", 10)).doclink("origins", "#glossary-code-area-origins")).a(" of code area:").jumpToMiddle().a(String.format("Top %d object types in image heap:", 10)).reset()).flushln();
        long printedCodeBytes = 0L;
        long printedHeapBytes = 0L;
        long printedCodeItems = 0L;
        long printedHeapItems = 0L;
        for (int i = 0; i < 10; ++i) {
            String codeSizePart = "";
            if (packagesBySize.hasNext()) {
                Map.Entry e = (Map.Entry)packagesBySize.next();
                String className = Utils.truncateClassOrPackageName((String)e.getKey());
                codeSizePart = String.format("%9s %s", ByteFormattingUtil.bytesToHuman((Long)e.getValue()), className);
                printedCodeBytes += ((Long)e.getValue()).longValue();
                ++printedCodeItems;
            }
            String heapSizePart = "";
            if (typesBySizeInHeap.hasNext()) {
                HeapBreakdownProvider.HeapBreakdownEntry e = typesBySizeInHeap.next();
                String className = e.label.renderToString(this.linkStrategy);
                if (e.label instanceof HeapBreakdownProvider.SimpleHeapObjectKindName) {
                    className = Utils.truncateClassOrPackageName(className);
                }
                long byteSize = e.byteSize;
                heapSizePart = String.format("%9s %s", ByteFormattingUtil.bytesToHuman(byteSize), className);
                printedHeapBytes += byteSize;
                ++printedHeapItems;
            }
            if (codeSizePart.isEmpty() && heapSizePart.isEmpty()) break;
            ((TwoColumnPrinter)p.l()).a(codeSizePart).jumpToMiddle().a(heapSizePart).flushln();
        }
        int numCodeItems = codeBreakdown.size();
        int numHeapItems = heapBreakdown.getSortedBreakdownEntries().size();
        long totalCodeBytes = codeBreakdown.values().stream().mapToLong(Long::longValue).sum();
        ((TwoColumnPrinter)p.l()).a(String.format("%9s for %s more packages", ByteFormattingUtil.bytesToHuman(totalCodeBytes - printedCodeBytes), (long)numCodeItems - printedCodeItems)).jumpToMiddle().a(String.format("%9s for %s more object types", ByteFormattingUtil.bytesToHuman(heapBreakdown.getTotalHeapSize() - printedHeapBytes), (long)numHeapItems - printedHeapItems)).flushln();
    }

    private void printRecommendations() {
        if (!SubstrateOptions.BuildOutputRecommendations.getValue().booleanValue()) {
            return;
        }
        List<ProgressReporterFeature.UserRecommendation> recommendations = ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).getRecommendations();
        List<ProgressReporterFeature.UserRecommendation> topApplicableRecommendations = recommendations.stream().filter(r -> r.isApplicable().get()).limit(5L).toList();
        if (topApplicableRecommendations.isEmpty()) {
            return;
        }
        this.l().printLineSeparator();
        ((DirectPrinter)((DirectPrinter)this.l().yellowBold()).a("Recommendations:").reset()).println();
        for (ProgressReporterFeature.UserRecommendation r2 : topApplicableRecommendations) {
            String alignment = Utils.stringFilledWith(Math.max(1, 5 - r2.id().length()), " ");
            ((DirectPrinter)this.l().a(" ").doclink(r2.id(), "#recommendation-" + r2.id().toLowerCase())).a(":").a(alignment).a(r2.description()).println();
        }
    }

    public void printEpilog(Optional<String> optionalImageName, Optional<NativeImageGenerator> optionalGenerator, ImageClassLoader classLoader, boolean wasSuccessfulBuild, Optional<Throwable> optionalUnhandledThrowable, OptionValues parsedHostedOptions) {
        this.executor.shutdown();
        if (optionalUnhandledThrowable.isPresent()) {
            Path errorReportPath = NativeImageOptions.getErrorFilePath(parsedHostedOptions);
            Optional<FeatureHandler> featureHandler = optionalGenerator.map(nativeImageGenerator -> nativeImageGenerator.featureHandler);
            ReportUtils.report((String)"GraalVM Native Image Error Report", (Path)errorReportPath, p -> VMErrorReporter.generateErrorReport(p, this.buildOutputLog, classLoader, featureHandler, (Throwable)optionalUnhandledThrowable.get()), (boolean)false);
            if (ImageSingletonsSupport.isInstalled()) {
                BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, errorReportPath);
            }
        }
        if (optionalImageName.isEmpty() || optionalGenerator.isEmpty()) {
            this.printErrorMessage(optionalUnhandledThrowable, parsedHostedOptions);
            return;
        }
        String imageName = optionalImageName.get();
        NativeImageGenerator generator = optionalGenerator.get();
        this.l().printLineSeparator();
        this.printResourceStatistics();
        double totalSeconds = Utils.millisToSeconds(ProgressReporter.getTimer(TimerCollection.Registry.TOTAL).getTotalTime());
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.TOTAL_SECS, totalSeconds);
        this.createAdditionalArtifacts(imageName, generator, wasSuccessfulBuild, parsedHostedOptions);
        this.printArtifacts(generator.getBuildArtifacts());
        this.l().printHeadlineSeparator();
        String timeStats = totalSeconds < 60.0 ? String.format("%.1fs", totalSeconds) : String.format("%dm %ds", (int)totalSeconds / 60, (int)totalSeconds % 60);
        ((DirectPrinter)((DirectPrinter)this.l().a(wasSuccessfulBuild ? "Finished" : "Failed").a(" generating '").bold()).a(imageName).reset()).a("' ").a(wasSuccessfulBuild ? "in" : "after").a(" ").a(timeStats).a(".").println();
        this.printErrorMessage(optionalUnhandledThrowable, parsedHostedOptions);
    }

    private void printErrorMessage(Optional<Throwable> optionalUnhandledThrowable, OptionValues parsedHostedOptions) {
        if (optionalUnhandledThrowable.isEmpty()) {
            return;
        }
        Throwable unhandledThrowable = optionalUnhandledThrowable.get();
        this.l().println();
        ((DirectPrinter)((DirectPrinter)this.l().redBold()).a("The build process encountered an unexpected error:").reset()).println();
        if (((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            ((DirectPrinter)this.l().dim()).println();
            unhandledThrowable.printStackTrace(this.builderIO.getOut());
            ((DirectPrinter)this.l().reset()).println();
        } else {
            this.l().println();
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().dim()).a("> %s", unhandledThrowable)).reset()).println();
            this.l().println();
            this.l().a("Please inspect the generated error report at:").println();
            ((DirectPrinter)this.l().link(NativeImageOptions.getErrorFilePath(parsedHostedOptions))).println();
            this.l().println();
            this.l().a("If you are unable to resolve this problem, please file an issue with the error report at:").println();
            String supportUrl = VM.getSupportUrl();
            ((DirectPrinter)this.l().link(supportUrl, supportUrl)).println();
        }
    }

    private void createAdditionalArtifacts(String imageName, NativeImageGenerator generator, boolean wasSuccessfulBuild, OptionValues parsedHostedOptions) {
        BuildArtifacts artifacts = BuildArtifacts.singleton();
        if (wasSuccessfulBuild) {
            this.createAdditionalArtifactsOnSuccess(artifacts, generator, parsedHostedOptions);
        }
        BuildArtifactsExporter.run(imageName, artifacts, generator.getBuildArtifacts());
    }

    private void createAdditionalArtifactsOnSuccess(BuildArtifacts artifacts, NativeImageGenerator generator, OptionValues parsedHostedOptions) {
        Optional buildOutputJSONFile = ((LocatableMultiOptionValue.Paths)SubstrateOptions.BuildOutputJSONFile.getValue(parsedHostedOptions)).lastValue();
        if (buildOutputJSONFile.isPresent()) {
            artifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, this.reportBuildOutput((Path)buildOutputJSONFile.get()));
        }
        if (generator.getBigbang() != null && ((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
            artifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, ProgressReporter.reportImageBuildStatistics());
        }
        ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).createAdditionalArtifactsOnSuccess(artifacts);
    }

    private void printArtifacts(Map<BuildArtifacts.ArtifactType, List<Path>> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        this.l().printLineSeparator();
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().yellowBold()).doclink("Build artifacts", "#glossary-build-artifacts")).a(":").reset()).println();
        TreeMap<Path, List> pathToTypes = new TreeMap<Path, List>();
        artifacts.forEach((artifactType, paths) -> {
            for (Path path : paths) {
                pathToTypes.computeIfAbsent(path, p -> new ArrayList()).add(artifactType.name().toLowerCase());
            }
        });
        pathToTypes.forEach((path, typeNames) -> ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(" ").link((Path)path)).dim()).a(" (").a(String.join((CharSequence)", ", typeNames)).a(")").reset()).println());
    }

    private Path reportBuildOutput(Path jsonOutputFile) {
        String description = "image statistics in json";
        return ReportUtils.report((String)description, (Path)jsonOutputFile.toAbsolutePath(), out -> {
            try {
                this.jsonHelper.print(new JsonWriter((Writer)out));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Failed to create " + String.valueOf(jsonOutputFile), e);
            }
        }, (boolean)false);
    }

    private static Path reportImageBuildStatistics() {
        Consumer statsReporter = ((ImageBuildStatistics)ImageSingletons.lookup(ImageBuildStatistics.class)).getReporter();
        Path reportsPath = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton()).resolve("reports");
        return ReportUtils.report((String)"image build statistics", (Path)reportsPath.resolve("image_build_statistics.json"), (Consumer)statsReporter, (boolean)false);
    }

    private void printResourceStatistics() {
        double totalProcessTimeSeconds = Utils.millisToSeconds(System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime());
        GCStats gcStats = GCStats.getCurrent();
        double gcSeconds = Utils.millisToSeconds(gcStats.totalTimeMillis);
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.GC_COUNT, gcStats.totalCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.GC_SECS, gcSeconds);
        CenteredTextPrinter p = this.centered();
        ((CenteredTextPrinter)p.a("%.1fs (%.1f%% of total time) in %d ", gcSeconds, gcSeconds / totalProcessTimeSeconds * 100.0, gcStats.totalCount)).doclink("GCs", "#glossary-garbage-collections");
        long peakRSS = ProgressReporterCHelper.getPeakRSS();
        if (peakRSS >= 0L) {
            ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)p.a(" | ")).doclink("Peak RSS", "#glossary-peak-rss")).a(": ")).a("%.2fGB", ByteFormattingUtil.bytesToGiB(peakRSS));
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.PEAK_RSS, peakRSS >= 0L ? peakRSS : -1L);
        long processCPUTime = ProgressReporter.getOperatingSystemMXBean().getProcessCpuTime();
        double cpuLoad = -1.0;
        if (processCPUTime > 0L) {
            cpuLoad = Utils.nanosToSeconds(processCPUTime) / totalProcessTimeSeconds;
            ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)p.a(" | ")).doclink("CPU load", "#glossary-cpu-load")).a(": ")).a("%.2f", cpuLoad);
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.CPU_LOAD, cpuLoad);
        p.flushln();
    }

    private void checkForExcessiveGarbageCollection() {
        long current = System.currentTimeMillis();
        long timeDeltaMillis = current - this.lastGCCheckTimeMillis;
        this.lastGCCheckTimeMillis = current;
        GCStats currentGCStats = GCStats.getCurrent();
        long gcTimeDeltaMillis = currentGCStats.totalTimeMillis - this.lastGCStats.totalTimeMillis;
        double ratio = (double)gcTimeDeltaMillis / (double)timeDeltaMillis;
        if ((double)gcTimeDeltaMillis > 15000.0 && ratio > 0.5) {
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().redBold()).a("GC warning").reset()).a(": %.1fs spent in %d GCs during the last stage, taking up %.2f%% of the time.", Utils.millisToSeconds(gcTimeDeltaMillis), currentGCStats.totalCount - this.lastGCStats.totalCount, ratio * 100.0)).println();
            ((DirectPrinter)this.l().a("            Please ensure more than %.2fGB of memory is available for Native Image", ByteFormattingUtil.bytesToGiB(ProgressReporterCHelper.getPeakRSS()))).println();
            this.l().a("            to reduce GC overhead and improve image build time.").println();
        }
        this.lastGCStats = currentGCStats;
    }

    public void recordJsonMetric(ProgressReporterJsonHelper.JsonMetric metric, Object value) {
        if (this.jsonHelper != null) {
            metric.record(this.jsonHelper, value);
        }
    }

    private static Timer getTimer(TimerCollection.Registry type) {
        return TimerCollection.singleton().get(type);
    }

    private static OperatingSystemMXBean getOperatingSystemMXBean() {
        return (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    private void print(char text) {
        this.builderIO.getOut().print(text);
        this.buildOutputLog.append(text);
    }

    private void print(String text) {
        this.builderIO.getOut().print(text);
        this.buildOutputLog.append(text);
    }

    private void println() {
        this.builderIO.getOut().println();
        this.buildOutputLog.append(System.lineSeparator());
    }

    public DirectPrinter l() {
        return this.linePrinter.a(this.outputPrefix);
    }

    public CenteredTextPrinter centered() {
        return new CenteredTextPrinter();
    }

    public void reportStageProgress() {
        this.stagePrinter.reportProgress();
    }

    public void beforeNextStdioWrite() {
        this.stagePrinter.beforeNextStdioWrite();
    }

    public final class DirectPrinter
    extends AbstractPrinter<DirectPrinter> {
        @Override
        DirectPrinter getThis() {
            return this;
        }

        @Override
        public DirectPrinter a(String text) {
            ProgressReporter.this.print(text);
            return this;
        }

        public void println() {
            ProgressReporter.this.println();
        }

        void printHeadlineSeparator() {
            ((DirectPrinter)((DirectPrinter)this.dim()).a(HEADLINE_SEPARATOR).reset()).println();
        }

        public void printLineSeparator() {
            ((DirectPrinter)((DirectPrinter)this.dim()).a(LINE_SEPARATOR).reset()).println();
        }
    }

    private static class GCStats {
        private final long totalCount;
        private final long totalTimeMillis;

        private static GCStats getCurrent() {
            long totalCount = 0L;
            long totalTime = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long collectionTime;
                long collectionCount = bean.getCollectionCount();
                if (collectionCount > 0L) {
                    totalCount += collectionCount;
                }
                if ((collectionTime = bean.getCollectionTime()) <= 0L) continue;
                totalTime += collectionTime;
            }
            return new GCStats(totalCount, totalTime);
        }

        GCStats(long totalCount, long totalTime) {
            this.totalCount = totalCount;
            this.totalTimeMillis = totalTime;
        }
    }

    final class ColorfulStrategy
    implements ColorStrategy {
        ColorfulStrategy() {
        }

        @Override
        public void bold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1m");
        }

        @Override
        public void blue(AbstractPrinter<?> printer) {
            printer.a("\u001b[0;34m");
        }

        @Override
        public void blueBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;34m");
        }

        @Override
        public void magentaBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;35m");
        }

        @Override
        public void red(AbstractPrinter<?> printer) {
            printer.a("\u001b[0;31m");
        }

        @Override
        public void redBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;31m");
        }

        @Override
        public void yellowBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;33m");
        }

        @Override
        public void dim(AbstractPrinter<?> printer) {
            printer.a("\u001b[2m");
        }

        @Override
        public void reset(AbstractPrinter<?> printer) {
            printer.a("\u001b[0m");
        }

        @Override
        public void reset() {
            ProgressReporter.this.print("\u001b[0m");
        }
    }

    static final class ColorlessStrategy
    implements ColorStrategy {
        ColorlessStrategy() {
        }
    }

    private static interface ColorStrategy {
        default public void bold(AbstractPrinter<?> printer) {
        }

        default public void blue(AbstractPrinter<?> printer) {
        }

        default public void blueBold(AbstractPrinter<?> printer) {
        }

        default public void magentaBold(AbstractPrinter<?> printer) {
        }

        default public void red(AbstractPrinter<?> printer) {
        }

        default public void redBold(AbstractPrinter<?> printer) {
        }

        default public void yellowBold(AbstractPrinter<?> printer) {
        }

        default public void dim(AbstractPrinter<?> printer) {
        }

        default public void reset(AbstractPrinter<?> printer) {
        }

        default public void reset() {
        }
    }

    final class CharacterwiseStagePrinter
    extends StagePrinter<CharacterwiseStagePrinter> {
        CharacterwiseStagePrinter() {
        }

        @Override
        CharacterwiseStagePrinter getThis() {
            return this;
        }

        @Override
        public CharacterwiseStagePrinter a(String value) {
            ProgressReporter.this.print(value);
            return (CharacterwiseStagePrinter)super.a(value);
        }

        @Override
        void start(BuildStage stage) {
            super.start(stage);
            ProgressReporter.this.builderIO.progressReporter = ProgressReporter.this;
        }

        @Override
        void reportProgress() {
            this.reprintLineIfNecessary();
            ProgressReporter.this.builderIO.progressReporter = null;
            super.reportProgress();
            ProgressReporter.this.builderIO.progressReporter = ProgressReporter.this;
        }

        @Override
        void end(double totalTime) {
            this.reprintLineIfNecessary();
            ProgressReporter.this.builderIO.progressReporter = null;
            super.end(totalTime);
        }

        void reprintLineIfNecessary() {
            if (ProgressReporter.this.builderIO.progressReporter == null) {
                this.printLineParts();
            }
        }

        @Override
        void flushln() {
            this.lineParts.clear();
            ProgressReporter.this.println();
        }

        @Override
        void beforeNextStdioWrite() {
            ProgressReporter.this.colorStrategy.reset();
            ProgressReporter.this.print('\r');
            int textLength = this.getCurrentTextLength();
            assert (textLength > 0) : "linePrinter expected to hold current line content";
            for (int i = 0; i <= textLength; ++i) {
                ProgressReporter.this.print(' ');
            }
            ProgressReporter.this.print('\r');
        }
    }

    final class LinewiseStagePrinter
    extends StagePrinter<LinewiseStagePrinter> {
        LinewiseStagePrinter(ProgressReporter this$0) {
        }

        @Override
        LinewiseStagePrinter getThis() {
            return this;
        }

        @Override
        void beforeNextStdioWrite() {
            throw VMError.shouldNotReachHere("LinewiseStagePrinter not allowed to set builderIO.listenForNextStdioWrite");
        }
    }

    abstract class StagePrinter<T extends StagePrinter<T>>
    extends LinePrinter<T> {
        private int progressBarStart;
        private BuildStage activeBuildStage;
        private ScheduledFuture<?> periodicPrintingTask;
        private boolean isCancelled;

        StagePrinter() {
            this.progressBarStart = 30;
            this.activeBuildStage = null;
        }

        void start(BuildStage stage) {
            assert (this.activeBuildStage == null);
            this.activeBuildStage = stage;
            this.appendStageStart();
            if (this.activeBuildStage.hasProgressBar) {
                ((StagePrinter)((StagePrinter)this.a(this.progressBarStartPadding())).dim()).a("[");
            }
            if (this.activeBuildStage.hasPeriodicProgress) {
                this.startPeriodicProgress();
            }
        }

        private void startPeriodicProgress() {
            this.isCancelled = false;
            this.periodicPrintingTask = ProgressReporter.this.executor.scheduleAtFixedRate(new Runnable(){
                int countdown;
                int numPrints;

                @Override
                public void run() {
                    if (StagePrinter.this.isCancelled) {
                        return;
                    }
                    if (--this.countdown < 0) {
                        StagePrinter.this.reportProgress();
                        this.countdown = ++this.numPrints > 2 ? this.numPrints * 2 : this.numPrints;
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }

        private void appendStageStart() {
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(ProgressReporter.this.outputPrefix)).blue()).a(String.format("[%s/%s] ", 1 + this.activeBuildStage.ordinal(), BuildStage.NUM_STAGES))).reset()).blueBold()).doclink(this.activeBuildStage.message, "#stage-" + this.activeBuildStage.name().toLowerCase())).a("...")).reset();
        }

        final String progressBarStartPadding() {
            return Utils.stringFilledWith(this.progressBarStart - this.getCurrentTextLength(), " ");
        }

        void reportProgress() {
            this.a("*");
        }

        final void end(Timer timer) {
            this.end(timer.getTotalTime());
        }

        void end(double totalTime) {
            boolean optionsAvailable;
            if (this.activeBuildStage.hasPeriodicProgress) {
                this.isCancelled = true;
                this.periodicPrintingTask.cancel(false);
            }
            if (this.activeBuildStage.hasProgressBar) {
                ((StagePrinter)this.a("]")).reset();
            }
            String suffix = String.format("(%.1fs @ %.2fGB)", Utils.millisToSeconds(totalTime), Utils.getUsedMemory());
            int textLength = this.getCurrentTextLength();
            String padding = Utils.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - textLength - suffix.length()), " ");
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(padding)).dim()).a(suffix)).reset()).flushln();
            this.activeBuildStage = null;
            boolean bl = optionsAvailable = ImageSingletonsSupport.isInstalled() && ImageSingletons.contains(HostedOptionValues.class);
            if (optionsAvailable && SubstrateOptions.BuildOutputGCWarnings.getValue().booleanValue()) {
                ProgressReporter.this.checkForExcessiveGarbageCollection();
            }
        }

        abstract void beforeNextStdioWrite();
    }

    static final class LinkyStrategy
    implements LinkStrategy {
        LinkyStrategy() {
        }

        @Override
        public boolean isTerminalSupported() {
            return true;
        }

        @Override
        public void link(AbstractPrinter<?> printer, String text, String url) {
            ((AbstractPrinter)((AbstractPrinter)((AbstractPrinter)printer.a("\u001b]8;;" + url)).a("\u001b\\")).a(text)).a("\u001b]8;;\u001b\\");
        }

        @Override
        public String asDocLink(String text, String htmlAnchor) {
            return String.format("\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\", ProgressReporter.DOCS_BASE_URL + htmlAnchor, text);
        }
    }

    static final class LinklessStrategy
    implements LinkStrategy {
        LinklessStrategy() {
        }

        @Override
        public void link(AbstractPrinter<?> printer, String text, String url) {
            printer.a(text);
        }

        @Override
        public String asDocLink(String text, String htmlAnchor) {
            return text;
        }
    }

    public static interface LinkStrategy {
        default public boolean isTerminalSupported() {
            return false;
        }

        public void link(AbstractPrinter<?> var1, String var2, String var3);

        public String asDocLink(String var1, String var2);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        default public void link(AbstractPrinter<?> printer, Path path, boolean filenameOnly) {
            String name;
            Path normalized = path.normalize();
            if (filenameOnly) {
                Path filename = normalized.getFileName();
                if (filename == null) throw VMError.shouldNotReachHere("filename should never be null, illegal path: " + String.valueOf(path));
                name = filename.toString();
            } else {
                name = normalized.toString();
            }
            this.link(printer, name, normalized.toUri().toString());
        }

        default public void doclink(AbstractPrinter<?> printer, String text, String htmlAnchor) {
            this.link(printer, text, ProgressReporter.DOCS_BASE_URL + htmlAnchor);
        }
    }

    public abstract class AbstractPrinter<T extends AbstractPrinter<T>> {
        abstract T getThis();

        public abstract T a(String var1);

        public final T a(String text, Object ... args) {
            return this.a(String.format(text, args));
        }

        public final T a(int i) {
            return this.a(String.valueOf(i));
        }

        public final T a(long i) {
            return this.a(String.valueOf(i));
        }

        public final T bold() {
            ProgressReporter.this.colorStrategy.bold(this);
            return this.getThis();
        }

        public final T blue() {
            ProgressReporter.this.colorStrategy.blue(this);
            return this.getThis();
        }

        public final T blueBold() {
            ProgressReporter.this.colorStrategy.blueBold(this);
            return this.getThis();
        }

        public final T red() {
            ProgressReporter.this.colorStrategy.red(this);
            return this.getThis();
        }

        public final T redBold() {
            ProgressReporter.this.colorStrategy.redBold(this);
            return this.getThis();
        }

        public final T yellowBold() {
            ProgressReporter.this.colorStrategy.yellowBold(this);
            return this.getThis();
        }

        public final T dim() {
            ProgressReporter.this.colorStrategy.dim(this);
            return this.getThis();
        }

        public final T reset() {
            ProgressReporter.this.colorStrategy.reset(this);
            return this.getThis();
        }

        public final T link(String text, String url) {
            ProgressReporter.this.linkStrategy.link(this, text, url);
            return this.getThis();
        }

        public final T link(Path path) {
            return this.link(path, false);
        }

        public final T link(Path path, boolean filenameOnly) {
            ProgressReporter.this.linkStrategy.link(this, path, filenameOnly);
            return this.getThis();
        }

        public final T doclink(String text, String htmlAnchor) {
            ProgressReporter.this.linkStrategy.doclink(this, text, htmlAnchor);
            return this.getThis();
        }
    }

    private static enum BuildStage {
        INITIALIZING("Initializing"),
        ANALYSIS("Performing analysis", true, false),
        UNIVERSE("Building universe"),
        PARSING("Parsing methods", true, true),
        INLINING("Inlining methods", true, false),
        COMPILING("Compiling methods", true, true),
        LAYING_OUT("Laying out methods", true, true),
        CREATING("Creating image", true, true);

        private static final int NUM_STAGES;
        private final String message;
        private final boolean hasProgressBar;
        private final boolean hasPeriodicProgress;

        private BuildStage(String message) {
            this(message, false, false);
        }

        private BuildStage(String message, boolean hasProgressBar, boolean hasPeriodicProgress) {
            this.message = message;
            this.hasProgressBar = hasProgressBar;
            this.hasPeriodicProgress = hasPeriodicProgress;
        }

        static {
            NUM_STAGES = BuildStage.values().length;
        }
    }

    record ExperimentalOptionDetails(String migrationMessage, String alternatives, String origins) {
        public String toSuffix() {
            if (this.migrationMessage.isEmpty() && this.alternatives.isEmpty() && this.origins.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            if (!this.migrationMessage.isEmpty()) {
                sb.append(": ").append(this.migrationMessage);
            }
            if (!this.alternatives.isEmpty() || !this.origins.isEmpty()) {
                sb.append(" (");
                if (!this.alternatives.isEmpty()) {
                    sb.append("alternative API option(s): ").append(this.alternatives);
                }
                if (!this.origins.isEmpty()) {
                    if (!this.alternatives.isEmpty()) {
                        sb.append("; ");
                    }
                    sb.append("origin(s): ").append(this.origins);
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }

    private static class Utils {
        private static final double MILLIS_TO_SECONDS = 1000.0;
        private static final double NANOS_TO_SECONDS = 1.0E9;

        private Utils() {
        }

        private static double millisToSeconds(double millis) {
            return millis / 1000.0;
        }

        private static double nanosToSeconds(double nanos) {
            return nanos / 1.0E9;
        }

        private static double getUsedMemory() {
            return ByteFormattingUtil.bytesToGiB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        }

        private static String stringFilledWith(int size, String fill) {
            return new String(new char[size]).replace("\u0000", fill);
        }

        private static double toPercentage(long part, long total) {
            return (double)part / (double)total * 100.0;
        }

        private static String truncateClassOrPackageName(String classOrPackageName) {
            int maxLength;
            int classNameLength = classOrPackageName.length();
            if (classNameLength <= (maxLength = CHARACTERS_PER_LINE / 2 - 10)) {
                return classOrPackageName;
            }
            StringBuilder sb = new StringBuilder();
            int currentDot = -1;
            while (true) {
                int nextDot;
                if ((nextDot = classOrPackageName.indexOf(46, currentDot + 1)) < 0) {
                    int restLength;
                    String rest = classOrPackageName.substring(currentDot + 1);
                    int sbLength = sb.length();
                    if (sbLength + (restLength = rest.length()) <= maxLength) {
                        sb.append(rest);
                        break;
                    }
                    int remainingSpaceDivBy2 = (maxLength - sbLength) / 2;
                    sb.append(rest, 0, remainingSpaceDivBy2 - 1).append("~").append(rest, restLength - remainingSpaceDivBy2, restLength);
                    break;
                }
                sb.append(classOrPackageName.charAt(currentDot + 1)).append('.');
                if (sb.length() + (classNameLength - nextDot) <= maxLength) {
                    sb.append(classOrPackageName.substring(nextDot + 1));
                    break;
                }
                currentDot = nextDot;
            }
            return sb.toString();
        }
    }

    public static abstract class ReporterClosable
    implements AutoCloseable {
        @Override
        public void close() {
            this.closeAction();
        }

        abstract void closeAction();
    }

    final class TwoColumnPrinter
    extends LinePrinter<TwoColumnPrinter> {
        TwoColumnPrinter() {
        }

        @Override
        TwoColumnPrinter getThis() {
            return this;
        }

        @Override
        public TwoColumnPrinter a(String value) {
            super.a(value);
            return this;
        }

        TwoColumnPrinter jumpToMiddle() {
            int remaining = CHARACTERS_PER_LINE / 2 - this.getCurrentTextLength();
            assert (remaining >= 0) : "Column text too wide";
            this.a(Utils.stringFilledWith(remaining, " "));
            assert (this.getCurrentTextLength() == CHARACTERS_PER_LINE / 2);
            return this;
        }

        @Override
        void flushln() {
            ProgressReporter.this.print(ProgressReporter.this.outputPrefix);
            super.flushln();
        }
    }

    public abstract class LinePrinter<T extends LinePrinter<T>>
    extends AbstractPrinter<T> {
        protected final List<String> lineParts = new ArrayList<String>();

        @Override
        public T a(String value) {
            this.lineParts.add(value);
            return (T)((LinePrinter)this.getThis());
        }

        T l() {
            assert (this.lineParts.isEmpty());
            return (T)((LinePrinter)this.getThis());
        }

        final int getCurrentTextLength() {
            int textLength = 0;
            for (String text : this.lineParts) {
                if (text.startsWith("\u001b")) continue;
                textLength += text.length();
            }
            return textLength;
        }

        final void printLineParts() {
            for (String part : this.lineParts.toArray(new String[0])) {
                ProgressReporter.this.print(part);
            }
        }

        void flushln() {
            this.printLineParts();
            this.lineParts.clear();
            ProgressReporter.this.println();
        }
    }

    public final class CenteredTextPrinter
    extends LinePrinter<CenteredTextPrinter> {
        @Override
        CenteredTextPrinter getThis() {
            return this;
        }

        @Override
        public void flushln() {
            ProgressReporter.this.print(ProgressReporter.this.outputPrefix);
            String padding = Utils.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - this.getCurrentTextLength()) / 2, " ");
            ProgressReporter.this.print(padding);
            super.flushln();
        }
    }

    public static class ANSI {
        static final String ESCAPE = "\u001b";
        static final String RESET = "\u001b[0m";
        static final String BOLD = "\u001b[1m";
        static final String DIM = "\u001b[2m";
        static final String STRIP_COLORS = "\u001b\\[[;\\d]*m";
        static final String LINK_START = "\u001b]8;;";
        static final String LINK_TEXT = "\u001b\\";
        static final String LINK_END = "\u001b]8;;\u001b\\";
        static final String LINK_FORMAT = "\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\";
        static final String STRIP_LINKS = "\u001b]8;;https://\\S+\u001b\\\\([^\u001b]*)\u001b]8;;\u001b\\\\";
        static final String RED = "\u001b[0;31m";
        static final String BLUE = "\u001b[0;34m";
        static final String RED_BOLD = "\u001b[1;31m";
        static final String YELLOW_BOLD = "\u001b[1;33m";
        static final String BLUE_BOLD = "\u001b[1;34m";
        static final String MAGENTA_BOLD = "\u001b[1;35m";

        public static String strip(String string) {
            return string.replaceAll(STRIP_COLORS, "").replaceAll(STRIP_LINKS, "$1");
        }
    }
}

