/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.Safepoint;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CallStackFrameMethodInfo {
    protected static final int INITIAL_METHOD_ID = -1;
    private final Map<Integer, String> sampledMethods = new HashMap<Integer, String>();
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private int enterSafepointCheckId = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private int enterSafepointFromNativeId = -1;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addMethodInfo(ResolvedJavaMethod method, int methodId) {
        String formattedMethod = CallStackFrameMethodInfo.formatted(method);
        this.sampledMethods.put(methodId, formattedMethod);
        if (this.enterSafepointCheckId == -1 && formattedMethod.equals(CallStackFrameMethodInfo.formatted(Safepoint.ENTER_SLOW_PATH_SAFEPOINT_CHECK))) {
            this.enterSafepointCheckId = methodId;
        }
        if (this.enterSafepointFromNativeId == -1 && formattedMethod.equals(CallStackFrameMethodInfo.formatted(Safepoint.ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS))) {
            this.enterSafepointFromNativeId = methodId;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected static String formatted(ResolvedJavaMethod method) {
        return method.format("%H.%n");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected static String formatted(SnippetRuntime.SubstrateForeignCallDescriptor descriptor) {
        return String.format("%s.%s", descriptor.getDeclaringClass().getCanonicalName(), descriptor.getName());
    }

    public String methodFor(int methodId) {
        return this.sampledMethods.get(methodId);
    }

    public boolean isSamplingCodeEntry(int methodId) {
        return this.enterSafepointCheckId == methodId || this.enterSafepointFromNativeId == methodId;
    }
}

