/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.EncodedReflectionMetadataSupplier;
import com.oracle.svm.core.reflect.target.FieldOffsetComputer;
import com.oracle.svm.core.reflect.target.ReflectionMetadataComputer;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_FieldAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;
import sun.reflect.generics.repository.FieldRepository;

@TargetClass(value=Field.class)
public final class Target_java_lang_reflect_Field {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private FieldRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_FieldAccessor fieldAccessor;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_FieldAccessor overrideFieldAccessor;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotationsComputer.class)
    byte[] annotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldOffsetComputer.class)
    public int offset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldDeletionReasonComputer.class)
    String deletedReason;
    @Alias
    boolean override;
    @Alias
    Target_java_lang_reflect_Field root;

    @Alias
    native Target_java_lang_reflect_Field copy();

    @Alias
    native Target_jdk_internal_reflect_FieldAccessor acquireFieldAccessor();

    @Alias
    native Target_jdk_internal_reflect_FieldAccessor acquireOverrideFieldAccessor();

    @Alias
    @TargetElement(name="<init>")
    native void constructor(Class<?> var1, String var2, Class<?> var3, int var4, boolean var5, int var6, String var7, byte[] var8);

    @Substitute
    Target_jdk_internal_reflect_FieldAccessor getFieldAccessor() {
        Target_jdk_internal_reflect_FieldAccessor accessor = this.fieldAccessor;
        if (accessor != null) {
            return accessor;
        }
        if (this.deletedReason != null) {
            Field field = SubstrateUtil.cast(this, Field.class);
            throw VMError.unsupportedFeature("Unsupported field " + field.getDeclaringClass().getTypeName() + "." + field.getName() + " is reachable: " + this.deletedReason);
        }
        return this.acquireFieldAccessor();
    }

    @Substitute
    Target_jdk_internal_reflect_FieldAccessor getOverrideFieldAccessor() {
        Target_jdk_internal_reflect_FieldAccessor accessor = this.overrideFieldAccessor;
        if (accessor != null) {
            return accessor;
        }
        if (this.deletedReason != null) {
            Field field = SubstrateUtil.cast(this, Field.class);
            throw VMError.unsupportedFeature("Unsupported field " + field.getDeclaringClass().getTypeName() + "." + field.getName() + " is reachable: " + this.deletedReason);
        }
        return this.acquireOverrideFieldAccessor();
    }

    @Substitute
    private byte[] getTypeAnnotationBytes0() {
        return SubstrateUtil.cast((Object)this, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations;
    }

    static class AnnotationsComputer
    extends ReflectionMetadataComputer {
        AnnotationsComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedReflectionMetadataSupplier)ImageSingletons.lookup(EncodedReflectionMetadataSupplier.class)).getAnnotationsEncoding((AccessibleObject)receiver);
        }
    }

    public static final class FieldDeletionReasonComputer
    implements FieldValueTransformerWithAvailability {
        @Override
        public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
            return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
        }

        public Object transform(Object receiver, Object originalValue) {
            return ReflectionSubstitutionSupport.singleton().getDeletionReason((Field)receiver);
        }
    }
}

