/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.fieldaccessor;

import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticFieldAccessorImpl;
import java.lang.reflect.Field;

class UnsafeQualifiedStaticShortFieldAccessorImpl
extends UnsafeQualifiedStaticFieldAccessorImpl {
    UnsafeQualifiedStaticShortFieldAccessorImpl(Field field, boolean isReadOnly) {
        super(field, isReadOnly);
    }

    @Override
    public Object get(Object obj) throws IllegalArgumentException {
        return this.getShort(obj);
    }

    @Override
    public boolean getBoolean(Object obj) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object obj) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object obj) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object obj) throws IllegalArgumentException {
        return unsafe.getShortVolatile(this.base, this.fieldOffset);
    }

    @Override
    public int getInt(Object obj) throws IllegalArgumentException {
        return this.getShort(obj);
    }

    @Override
    public long getLong(Object obj) throws IllegalArgumentException {
        return this.getShort(obj);
    }

    @Override
    public float getFloat(Object obj) throws IllegalArgumentException {
        return this.getShort(obj);
    }

    @Override
    public double getDouble(Object obj) throws IllegalArgumentException {
        return this.getShort(obj);
    }

    @Override
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(value);
        }
        if (value == null) {
            this.throwSetIllegalArgumentException(value);
        }
        if (value instanceof Byte) {
            unsafe.putShortVolatile(this.base, this.fieldOffset, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            unsafe.putShortVolatile(this.base, this.fieldOffset, (Short)value);
            return;
        }
        this.throwSetIllegalArgumentException(value);
    }

    @Override
    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(z);
    }

    @Override
    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setShort(obj, b);
    }

    @Override
    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(c);
    }

    @Override
    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(s);
        }
        unsafe.putShortVolatile(this.base, this.fieldOffset, s);
    }

    @Override
    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(i);
    }

    @Override
    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(l);
    }

    @Override
    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(f);
    }

    @Override
    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

