/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.jni.JNIGlobalHandles;
import com.oracle.svm.core.jni.JNIImageHeapHandles;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.jni.headers.JNIObjectRefType;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.SignedWord;

public final class JNIObjectHandles {
    static final int NATIVE_CALL_MIN_LOCAL_HANDLE_CAPACITY = 16;
    private static final FastThreadLocalObject<ThreadLocalHandles> handles = FastThreadLocalFactory.createObject(ThreadLocalHandles.class, "JNIObjectHandles.handles");

    @Fold
    static boolean haveAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(JNIObjectHandles.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends SignedWord> T nullHandle() {
        return (T)ThreadLocalHandles.nullHandle();
    }

    @Fold
    static boolean useImageHeapHandles() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    private static ThreadLocalHandles<ObjectHandle> getOrCreateLocals() {
        ThreadLocalHandles<ObjectHandle> result = handles.get();
        if (result == null) {
            result = JNIObjectHandles.createLocals();
        }
        return result;
    }

    @NeverInline(value="slow path that is executed once per thread; do not bloat machine code by inlining the allocations")
    private static ThreadLocalHandles<ObjectHandle> createLocals() {
        ThreadLocalHandles<ObjectHandle> result = new ThreadLocalHandles<ObjectHandle>(16);
        handles.set(result);
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static ThreadLocalHandles<ObjectHandle> getExistingLocals() {
        return handles.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isInLocalRange(JNIObjectHandle handle) {
        return ThreadLocalHandles.isInRange((ObjectHandle)handle);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static ObjectHandle decodeLocal(JNIObjectHandle handle) {
        return (ObjectHandle)handle;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JNIObjectHandle encodeLocal(ObjectHandle handle) {
        return (JNIObjectHandle)handle;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> T getObject(JNIObjectHandle handle) {
        if (handle.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return null;
        }
        if (JNIObjectHandles.isInLocalRange(handle)) {
            return (T)JNIObjectHandles.getExistingLocals().getObject(JNIObjectHandles.decodeLocal(handle));
        }
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            return JNIImageHeapHandles.getObject(handle);
        }
        return JNIObjectHandles.getObjectSlow(handle);
    }

    @Uninterruptible(reason="Not really, but our caller is to allow inlining and we must be safe at this point.", calleeMustBe=false)
    private static <T> T getObjectSlow(JNIObjectHandle handle) {
        return JNIObjectHandles.getObjectSlow0(handle);
    }

    private static <T> T getObjectSlow0(JNIObjectHandle handle) {
        if (JNIGlobalHandles.isInRange(handle)) {
            return JNIGlobalHandles.getObject(handle);
        }
        throw JNIObjectHandles.throwIllegalArgumentException();
    }

    @NeverInline(value="Exception slow path")
    private static IllegalArgumentException throwIllegalArgumentException() {
        throw new IllegalArgumentException("Invalid object handle");
    }

    public static JNIObjectRefType getHandleType(JNIObjectHandle handle) {
        if (JNIObjectHandles.isInLocalRange(handle)) {
            return JNIObjectRefType.Local;
        }
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            return JNIImageHeapHandles.getHandleType(handle);
        }
        if (JNIGlobalHandles.isInRange(handle)) {
            return JNIGlobalHandles.getHandleType(handle);
        }
        return JNIObjectRefType.Invalid;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JNIObjectHandle createLocal(Object obj) {
        ObjectHandle handle;
        if (obj == null) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInImageHeap(obj)) {
            return JNIImageHeapHandles.asLocal(obj);
        }
        ThreadLocalHandles<ObjectHandle> locals = JNIObjectHandles.getExistingLocals();
        if (BranchProbabilityNode.probability((double)0.999, (locals != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.99, (boolean)(handle = locals.tryCreateNonNull(obj)).notEqual(JNIObjectHandles.nullHandle()))) {
            return JNIObjectHandles.encodeLocal(handle);
        }
        return JNIObjectHandles.createLocalSlow(obj);
    }

    @Uninterruptible(reason="Not really, but our caller is uninterruptible for inlining and we must be safe at this point.", calleeMustBe=false)
    private static JNIObjectHandle createLocalSlow(Object obj) {
        return JNIObjectHandles.createLocalSlow0(obj);
    }

    private static JNIObjectHandle createLocalSlow0(Object obj) {
        return JNIObjectHandles.encodeLocal(JNIObjectHandles.getOrCreateLocals().create(obj));
    }

    public static JNIObjectHandle newLocalRef(JNIObjectHandle ref) {
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(ref)) {
            return JNIImageHeapHandles.toLocal(ref);
        }
        return JNIObjectHandles.encodeLocal(JNIObjectHandles.getOrCreateLocals().create(JNIObjectHandles.getObject(ref)));
    }

    public static void deleteLocalRef(JNIObjectHandle localRef) {
        if (!JNIObjectHandles.useImageHeapHandles() || !JNIImageHeapHandles.isInRange(localRef)) {
            JNIObjectHandles.getOrCreateLocals().delete(JNIObjectHandles.decodeLocal(localRef));
        }
    }

    public static int pushLocalFrame(int capacity) {
        return JNIObjectHandles.getOrCreateLocals().pushFrame(capacity);
    }

    public static void popLocalFrame() {
        JNIObjectHandles.getExistingLocals().popFrame();
    }

    public static void popLocalFramesIncluding(int frame) {
        JNIObjectHandles.getExistingLocals().popFramesIncluding(frame);
    }

    public static void ensureLocalCapacity(int capacity) {
        JNIObjectHandles.getOrCreateLocals().ensureCapacity(capacity);
    }

    public static JNIObjectHandle newGlobalRef(JNIObjectHandle handle) {
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            result = JNIImageHeapHandles.toGlobal(handle);
        } else {
            Object obj = JNIObjectHandles.getObject(handle);
            if (obj != null) {
                result = JNIGlobalHandles.create(obj);
            }
        }
        return result;
    }

    public static void deleteGlobalRef(JNIObjectHandle globalRef) {
        if (!JNIObjectHandles.useImageHeapHandles() || !JNIImageHeapHandles.isInRange(globalRef)) {
            JNIGlobalHandles.destroy(globalRef);
        }
    }

    public static JNIObjectHandle newWeakGlobalRef(JNIObjectHandle handle) {
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            result = JNIImageHeapHandles.toWeakGlobal(handle);
        } else {
            Object obj = JNIObjectHandles.getObject(handle);
            if (obj != null) {
                result = JNIGlobalHandles.createWeak(obj);
            }
        }
        return result;
    }

    public static void deleteWeakGlobalRef(JNIObjectHandle weakRef) {
        if (!JNIObjectHandles.useImageHeapHandles() || !JNIImageHeapHandles.isInRange(weakRef)) {
            JNIGlobalHandles.destroyWeak(weakRef);
        }
    }

    static int getLocalHandleCount() {
        ThreadLocalHandles<ObjectHandle> locals = JNIObjectHandles.getExistingLocals();
        return locals == null ? 0 : locals.getHandleCount();
    }

    static long computeCurrentGlobalHandleCount() {
        return JNIGlobalHandles.computeCurrentCount();
    }
}

