/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heapdump;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class HeapDumpUtils {
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private byte[] fieldsMap;
    private final TestingBackDoor testingBackDoor = new TestingBackDoor(this);

    public static HeapDumpUtils getHeapDumpUtils() {
        return (HeapDumpUtils)ImageSingletons.lookup(HeapDumpUtils.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setFieldsMap(byte[] map) {
        this.fieldsMap = map;
    }

    public boolean walkHeapObjects(ObjectVisitor imageHeapVisitor, ObjectVisitor collectedHeapVisitor) {
        WalkHeapObjectsOperation operation = new WalkHeapObjectsOperation(imageHeapVisitor, collectedHeapVisitor);
        return this.walkHeapObjectsWithoutAllocating(operation);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Iterating the heap must not allocate in the heap.")
    boolean walkHeapObjectsWithoutAllocating(WalkHeapObjectsOperation operation) {
        operation.enqueue();
        return operation.getResult();
    }

    public int instanceSizeOf(Class<?> cls) {
        int encoding = DynamicHub.fromClass(cls).getLayoutEncoding();
        if (LayoutEncoding.isPureInstance(encoding)) {
            return (int)LayoutEncoding.getPureInstanceAllocationSize(encoding).rawValue();
        }
        return 0;
    }

    boolean isPrimitiveArray(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isPrimitiveArray(encoding);
    }

    public boolean isJavaPrimitiveArray(Object obj) {
        return this.isPrimitiveArray(obj) && (obj instanceof char[] || obj instanceof byte[] || obj instanceof int[] || obj instanceof long[] || obj instanceof boolean[] || obj instanceof short[] || obj instanceof double[] || obj instanceof float[]);
    }

    public Pointer objectToPointer(Object obj) {
        return Word.objectToUntrackedPointer((Object)obj);
    }

    public byte[] getFieldsMap() {
        return this.fieldsMap;
    }

    public boolean walkStacks(StacksSlotsVisitor stacksSlotsVisitor) {
        WalkStacksSlotsOperation walkStacksOperation = new WalkStacksSlotsOperation(stacksSlotsVisitor);
        walkStacksOperation.enqueue();
        return walkStacksOperation.getResult();
    }

    public TestingBackDoor getTestingBackDoor() {
        return this.testingBackDoor;
    }

    public static class TestingBackDoor {
        private final HeapDumpUtils heapDumpUtils;

        TestingBackDoor(HeapDumpUtils utils) {
            this.heapDumpUtils = utils;
        }

        public byte[] getFieldsMap() {
            return this.heapDumpUtils.getFieldsMap();
        }

        public int instanceSizeOf(Class<?> cls) {
            return this.heapDumpUtils.instanceSizeOf(cls);
        }

        public boolean isJavaPrimitiveArray(Object obj) {
            return this.heapDumpUtils.isJavaPrimitiveArray(obj);
        }

        public boolean isPrimitiveArray(Object obj) {
            return this.heapDumpUtils.isPrimitiveArray(obj);
        }

        public Pointer objectToPointer(Object obj) {
            return this.heapDumpUtils.objectToPointer(obj);
        }

        public long sizeOf(Object obj) {
            long result;
            if (obj == null) {
                result = 0L;
            } else {
                UnsignedWord objectSize = LayoutEncoding.getMomentarySizeFromObject(obj);
                result = objectSize.rawValue();
            }
            return result;
        }

        public boolean walkHeapObjects(ObjectVisitor imageHeapVisitor, ObjectVisitor collectedHeapVisitor) {
            return this.heapDumpUtils.walkHeapObjects(imageHeapVisitor, collectedHeapVisitor);
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Iterating the heap must not allocate in the heap.")
        public boolean walkInteriorReferences(Object obj, ObjectReferenceVisitor visitor) {
            return InteriorObjRefWalker.walkObject(obj, visitor);
        }

        public boolean walkStacks(StacksSlotsVisitor stacksSlotsVisitor) {
            return this.heapDumpUtils.walkStacks(stacksSlotsVisitor);
        }
    }

    private static final class WalkHeapObjectsOperation
    extends JavaVMOperation {
        private final ObjectVisitor imageHeapVisitor;
        private final ObjectVisitor collectedHeapVisitor;
        boolean result;

        WalkHeapObjectsOperation(ObjectVisitor imageHeapVisitor, ObjectVisitor collectedHeapVisitor) {
            super(VMOperationInfos.get(WalkHeapObjectsOperation.class, "Walk Java heap for heap dump", VMOperation.SystemEffect.SAFEPOINT));
            this.imageHeapVisitor = imageHeapVisitor;
            this.collectedHeapVisitor = collectedHeapVisitor;
        }

        @Override
        public void operate() {
            this.operateWithoutAllocation();
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Do not allocate while walking the heap.")
        private void operateWithoutAllocation() {
            this.result = Heap.getHeap().walkImageHeapObjects(this.imageHeapVisitor) && Heap.getHeap().walkCollectedHeapObjects(this.collectedHeapVisitor);
        }

        private boolean getResult() {
            return this.result;
        }
    }

    private static final class WalkStacksSlotsOperation
    extends JavaVMOperation {
        private final StacksSlotsVisitor stacksSlotsVisitor;
        private boolean result;

        WalkStacksSlotsOperation(StacksSlotsVisitor stacksSlotsVisitor) {
            super(VMOperationInfos.get(WalkStacksSlotsOperation.class, "Walk stack for heap dump", VMOperation.SystemEffect.SAFEPOINT));
            this.stacksSlotsVisitor = stacksSlotsVisitor;
        }

        @Override
        public void operate() {
            this.operateWithoutAllocation();
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Do not allocate while walking thread stacks.")
        private void operateWithoutAllocation() {
            this.result = this.stacksSlotsVisitor.visitStacksSlots();
        }

        private boolean getResult() {
            return this.result;
        }
    }

    public static abstract class StacksSlotsVisitor
    extends StackFrameVisitor
    implements ObjectReferenceVisitor {
        private IsolateThread currentVMThread;
        private Pointer currentStackSP;
        private Pointer currentFrameSP;
        private CodePointer currentFrameIP;
        private DeoptimizedFrame currentDeoptimizedFrame;

        protected IsolateThread getVMThread() {
            return this.currentVMThread;
        }

        protected Pointer getStackSP() {
            return this.currentStackSP;
        }

        protected Pointer getFrameSP() {
            return this.currentFrameSP;
        }

        protected CodePointer getFrameIP() {
            return this.currentFrameIP;
        }

        protected DeoptimizedFrame getDeoptimizedFrame() {
            return this.currentDeoptimizedFrame;
        }

        @NeverInline(value="Starting a stack walk in the caller frame")
        protected boolean visitStacksSlots() {
            this.currentVMThread = CurrentIsolate.getCurrentThread();
            this.currentStackSP = KnownIntrinsics.readCallerStackPointer();
            JavaStackWalker.walkCurrentThread(this.currentStackSP, this);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        this.currentVMThread = vmThread;
                        this.currentStackSP = (Pointer)WordFactory.nullPointer();
                        this.currentFrameSP = (Pointer)WordFactory.nullPointer();
                        this.currentFrameIP = (CodePointer)WordFactory.nullPointer();
                        this.currentDeoptimizedFrame = null;
                        JavaStackWalker.walkThread(vmThread, this);
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
            return true;
        }

        @Override
        public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            if (this.currentStackSP.isNull()) {
                this.currentStackSP = sp;
            }
            this.currentFrameSP = sp;
            this.currentFrameIP = ip;
            this.currentDeoptimizedFrame = deoptimizedFrame;
            return CodeInfoTable.visitObjectReferences(sp, ip, codeInfo, deoptimizedFrame, this);
        }
    }
}

