/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import java.util.HashMap;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.Phase;

public class StackValueSlotAssignmentPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        HashMap<RecursionAwareStackSlotIdentity, LoweredStackValueNode.StackSlotHolder> slots = new HashMap<RecursionAwareStackSlotIdentity, LoweredStackValueNode.StackSlotHolder>();
        for (LoweredStackValueNode node : graph.getNodes(LoweredStackValueNode.TYPE)) {
            RecursionAwareStackSlotIdentity slotIdentity = new RecursionAwareStackSlotIdentity(node.slotIdentity, node.getRecursionDepth());
            LoweredStackValueNode.StackSlotHolder slotHolder = (LoweredStackValueNode.StackSlotHolder)slots.get(slotIdentity);
            if (slotHolder == null) {
                slotHolder = new LoweredStackValueNode.StackSlotHolder();
                slots.put(slotIdentity, slotHolder);
            }
            assert (node.stackSlotHolder == null);
            node.stackSlotHolder = slotHolder;
        }
    }

    private static class RecursionAwareStackSlotIdentity {
        private final StackValueNode.StackSlotIdentity slotIdentity;
        private final int recursionDepth;

        RecursionAwareStackSlotIdentity(StackValueNode.StackSlotIdentity slotIdentity, int recursionDepth) {
            this.slotIdentity = slotIdentity;
            this.recursionDepth = recursionDepth;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.slotIdentity.hashCode();
            result = 31 * result + Integer.hashCode(this.recursionDepth);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecursionAwareStackSlotIdentity) {
                RecursionAwareStackSlotIdentity other = (RecursionAwareStackSlotIdentity)obj;
                return this.slotIdentity == other.slotIdentity && this.recursionDepth == other.recursionDepth;
            }
            return false;
        }
    }
}

