/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippetCounters;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.StoredContinuation;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrier;
import jdk.graal.compiler.nodes.gc.WriteBarrier;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class BarrierSnippets
extends SubstrateTemplates
implements Snippets {
    public static final LocationIdentity CARD_REMEMBERED_SET_LOCATION = NamedLocationIdentity.mutable((String)"CardRememberedSet");
    private final SnippetTemplate.SnippetInfo postWriteBarrierSnippet;

    @Fold
    static BarrierSnippetCounters counters() {
        return (BarrierSnippetCounters)ImageSingletons.lookup(BarrierSnippetCounters.class);
    }

    BarrierSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.postWriteBarrierSnippet = this.snippet(providers, BarrierSnippets.class, "postWriteBarrierSnippet", new LocationIdentity[]{CARD_REMEMBERED_SET_LOCATION});
    }

    public void registerLowerings(MetaAccessProvider metaAccess, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        PostWriteBarrierLowering lowering = new PostWriteBarrierLowering(metaAccess);
        lowerings.put(SerialWriteBarrier.class, lowering);
        lowerings.put(SerialArrayRangeWriteBarrier.class, lowering);
    }

    @Snippet
    public static void postWriteBarrierSnippet(Object object, @Snippet.ConstantParameter boolean alwaysAlignedChunk, @Snippet.ConstantParameter boolean verifyOnly) {
        boolean unaligned;
        boolean needsBarrier;
        BarrierSnippets.counters().postWriteBarrier.inc();
        Object fixedObject = FixedValueAnchorNode.getObject((Object)object);
        Word objectHeader = ObjectHeader.readHeaderFromObject(fixedObject);
        if (SerialGCOptions.VerifyWriteBarriers.getValue().booleanValue() && alwaysAlignedChunk) {
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader))) {
                BreakpointNode.breakpoint();
            }
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (object == null ? 1 : 0) != 0)) {
                BreakpointNode.breakpoint();
            }
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)object.getClass().isArray())) {
                BreakpointNode.breakpoint();
            }
        }
        if (BranchProbabilityNode.probability((double)0.9, (!(needsBarrier = RememberedSet.get().hasRememberedSet((UnsignedWord)objectHeader)) ? 1 : 0) != 0)) {
            return;
        }
        if (!alwaysAlignedChunk && BranchProbabilityNode.probability((double)0.4, (boolean)(unaligned = ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader)))) {
            BarrierSnippets.counters().postWriteBarrierUnaligned.inc();
            RememberedSet.get().dirtyCardForUnalignedObject(fixedObject, verifyOnly);
            return;
        }
        BarrierSnippets.counters().postWriteBarrierAligned.inc();
        RememberedSet.get().dirtyCardForAlignedObject(fixedObject, verifyOnly);
    }

    private class PostWriteBarrierLowering
    implements NodeLoweringProvider<WriteBarrier> {
        private final ResolvedJavaType storedContinuationType;

        PostWriteBarrierLowering(MetaAccessProvider metaAccess) {
            this.storedContinuationType = metaAccess.lookupJavaType(StoredContinuation.class);
        }

        @Override
        public void lower(WriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(BarrierSnippets.this.postWriteBarrierSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            ResolvedJavaType baseType = StampTool.typeOrNull((ValueNode)address.getBase());
            assert (baseType == null || !this.storedContinuationType.isAssignableFrom(baseType)) : "StoredContinuation should be effectively immutable and references only be written by GC";
            boolean alwaysAlignedChunk = baseType != null && !baseType.isArray() && !baseType.isJavaLangObject() && !baseType.isInterface();
            args.add("object", (Object)address.getBase());
            args.addConst("alwaysAlignedChunk", (Object)alwaysAlignedChunk);
            args.addConst("verifyOnly", (Object)this.getVerifyOnly(barrier));
            BarrierSnippets.this.template((CoreProviders)tool, (ValueNode)barrier, args).instantiate(tool.getMetaAccess(), (FixedNode)barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private boolean getVerifyOnly(WriteBarrier barrier) {
            if (barrier instanceof SerialWriteBarrier) {
                return ((SerialWriteBarrier)barrier).getVerifyOnly();
            }
            return false;
        }
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getPostWriteBarrierCount() {
            return BarrierSnippets.counters().postWriteBarrier.getValue();
        }

        public static long getPostWriteBarrierAlignedCount() {
            return BarrierSnippets.counters().postWriteBarrierAligned.getValue();
        }

        public static long getPostWriteBarrierUnalignedCount() {
            return BarrierSnippets.counters().postWriteBarrierUnaligned.getValue();
        }
    }
}

