/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.bootstrap;

import com.oracle.svm.core.bootstrap.BootstrapMethodInfo;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatFactory;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticallyRegisteredFeature
public class BootstrapMethodConfiguration
implements InternalFeature {
    private final ConcurrentMap<BootstrapMethodRecord, BootstrapMethodInfo> bootstrapMethodInfoCache = new ConcurrentHashMap<BootstrapMethodRecord, BootstrapMethodInfo>();
    private final Set<Executable> indyBuildTimeAllowList;
    private final Set<Executable> condyBuildTimeAllowList;
    private final Set<Executable> trustedCondy;

    public static BootstrapMethodConfiguration singleton() {
        return (BootstrapMethodConfiguration)ImageSingletons.lookup(BootstrapMethodConfiguration.class);
    }

    public BootstrapMethodConfiguration() {
        Method metafactory = ReflectionUtil.lookupMethod(LambdaMetafactory.class, (String)"metafactory", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class});
        Method altMetafactory = ReflectionUtil.lookupMethod(LambdaMetafactory.class, (String)"altMetafactory", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class});
        Method makeConcat = ReflectionUtil.lookupMethod(StringConcatFactory.class, (String)"makeConcat", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class});
        Method makeConcatWithConstants = ReflectionUtil.lookupMethod(StringConcatFactory.class, (String)"makeConcatWithConstants", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Object[].class});
        Method bootstrap = ReflectionUtil.lookupMethod(ObjectMethods.class, (String)"bootstrap", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, TypeDescriptor.class, Class.class, String.class, MethodHandle[].class});
        Method typeSwitch = ReflectionUtil.lookupMethod(SwitchBootstraps.class, (String)"typeSwitch", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class});
        Method enumSwitch = ReflectionUtil.lookupMethod(SwitchBootstraps.class, (String)"enumSwitch", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class});
        this.indyBuildTimeAllowList = Set.of(metafactory, altMetafactory, makeConcat, makeConcatWithConstants, bootstrap, typeSwitch, enumSwitch);
        Method nullConstant = ReflectionUtil.lookupMethod(ConstantBootstraps.class, (String)"nullConstant", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class});
        Method primitiveClass = ReflectionUtil.lookupMethod(ConstantBootstraps.class, (String)"primitiveClass", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class});
        Method enumConstant = ReflectionUtil.lookupMethod(ConstantBootstraps.class, (String)"enumConstant", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class});
        Method getStaticFinal = ReflectionUtil.lookupMethod(ConstantBootstraps.class, (String)"getStaticFinal", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class, Class.class});
        Method invoke = ReflectionUtil.lookupMethod(ConstantBootstraps.class, (String)"invoke", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class, MethodHandle.class, Object[].class});
        Method explicitCast = ReflectionUtil.lookupMethod(ConstantBootstraps.class, (String)"explicitCast", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class, Object.class});
        Method classData = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"classData", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class});
        Method classDataAt = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"classDataAt", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE});
        this.condyBuildTimeAllowList = Set.of();
        this.trustedCondy = Set.of(nullConstant, primitiveClass, enumConstant, getStaticFinal, invoke, explicitCast, classData, classDataAt);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        Class stringConcatHelper = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.StringConcatHelper");
        Class formatConcatItem = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.util.FormatConcatItem");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)stringConcatHelper, (String)"prepend", (Class[])new Class[]{Long.TYPE, byte[].class, formatConcatItem, String.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)stringConcatHelper, (String)"mix", (Class[])new Class[]{Long.TYPE, formatConcatItem})});
    }

    public boolean isIndyAllowedAtBuildTime(Executable method) {
        return this.indyBuildTimeAllowList.contains(method);
    }

    public boolean isCondyAllowedAtBuildTime(Executable method) {
        return this.condyBuildTimeAllowList.contains(method);
    }

    public boolean isCondyTrusted(Executable method) {
        return this.trustedCondy.contains(method);
    }

    public ConcurrentMap<BootstrapMethodRecord, BootstrapMethodInfo> getBootstrapMethodInfoCache() {
        return this.bootstrapMethodInfoCache;
    }

    public record BootstrapMethodRecord(int bci, int cpi, ResolvedJavaMethod method) {
    }
}

