/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.thread.AddressOfVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.CompareAndSetVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.LoadVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.StoreVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.VMThreadLocalSTHolderNode;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.threadlocal.VMThreadLocalSTSupport;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public class VMThreadSTFeature
implements InternalFeature {
    private final VMThreadLocalCollector threadLocalCollector = new VMThreadLocalCollector();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue() == false;
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        ImageSingletons.add(VMThreadLocalSTSupport.class, (Object)new VMThreadLocalSTSupport());
        config.registerObjectReplacer((Function)this.threadLocalCollector);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, final SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        Class[] typesWithGetAddress;
        for (Class<? extends FastThreadLocal> threadLocalClass : VMThreadLocalInfo.THREAD_LOCAL_CLASSES) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), threadLocalClass);
            Class<?> valueClass = VMThreadLocalInfo.getValueClass(threadLocalClass);
            this.registerAccessors(r, snippetReflection, valueClass, false);
            this.registerAccessors(r, snippetReflection, valueClass, true);
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "compareAndSet", new Type[]{InvocationPlugin.Receiver.class, valueClass, valueClass}){
                final /* synthetic */ VMThreadSTFeature this$0;
                {
                    this.this$0 = this$0;
                    super(name, argumentTypes);
                }

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode expect, ValueNode update) {
                    return this.this$0.handleCompareAndSet(b, snippetReflection, targetMethod, receiver, expect, update);
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "compareAndSet", new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class, valueClass, valueClass}){
                final /* synthetic */ VMThreadSTFeature this$0;
                {
                    this.this$0 = this$0;
                    super(name, argumentTypes);
                }

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode expect, ValueNode update) {
                    return this.this$0.handleCompareAndSet(b, snippetReflection, targetMethod, receiver, expect, update);
                }
            });
        }
        for (Class type : typesWithGetAddress = new Class[]{FastThreadLocalBytes.class, FastThreadLocalWord.class}) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)type);
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getAddress", new Type[]{InvocationPlugin.Receiver.class}){
                final /* synthetic */ VMThreadSTFeature this$0;
                {
                    this.this$0 = this$0;
                    super(name, argumentTypes);
                }

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    return this.this$0.handleGetAddress(b, snippetReflection, targetMethod, receiver);
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getAddress", new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class}){
                final /* synthetic */ VMThreadSTFeature this$0;
                {
                    this.this$0 = this$0;
                    super(name, argumentTypes);
                }

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                    return this.this$0.handleGetAddress(b, snippetReflection, targetMethod, receiver);
                }
            });
        }
    }

    private void registerAccessors(InvocationPlugins.Registration r, final SnippetReflectionProvider snippetReflection, Class<?> valueClass, boolean isVolatile) {
        String suffix = isVolatile ? "Volatile" : "";
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "get" + suffix, new Type[]{InvocationPlugin.Receiver.class}){
            final /* synthetic */ VMThreadSTFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return this.this$0.handleGet(b, snippetReflection, targetMethod, receiver);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "get" + suffix, new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class}){
            final /* synthetic */ VMThreadSTFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                return this.this$0.handleGet(b, snippetReflection, targetMethod, receiver);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "set" + suffix, new Type[]{InvocationPlugin.Receiver.class, valueClass}){
            final /* synthetic */ VMThreadSTFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode valueNode) {
                return this.this$0.handleSet(b, snippetReflection, receiver, valueNode);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "set" + suffix, new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class, valueClass}){
            final /* synthetic */ VMThreadSTFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode valueNode) {
                return this.this$0.handleSet(b, snippetReflection, receiver, valueNode);
            }
        });
    }

    private boolean handleGet(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
        VMThreadLocalInfo info = this.threadLocalCollector.findInfo(b, snippetReflection, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((Node)new VMThreadLocalSTHolderNode(info));
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new LoadVMThreadLocalNode(b.getMetaAccess(), info, (ValueNode)holder, BarrierType.NONE, MemoryOrderMode.PLAIN));
        return true;
    }

    private boolean handleSet(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, InvocationPlugin.Receiver receiver, ValueNode valueNode) {
        VMThreadLocalInfo info = this.threadLocalCollector.findInfo(b, snippetReflection, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((Node)new VMThreadLocalSTHolderNode(info));
        StoreVMThreadLocalNode store = new StoreVMThreadLocalNode(info, (ValueNode)holder, valueNode, BarrierType.ARRAY, MemoryOrderMode.PLAIN);
        b.add((Node)store);
        assert (store.stateAfter() != null) : String.valueOf(store) + " has no state after with graph builder context " + String.valueOf(b);
        return true;
    }

    private boolean handleCompareAndSet(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode expect, ValueNode update) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, snippetReflection, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((Node)new VMThreadLocalSTHolderNode(threadLocalInfo));
        CompareAndSetVMThreadLocalNode cas = new CompareAndSetVMThreadLocalNode(threadLocalInfo, (ValueNode)holder, expect, update);
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)cas);
        assert (cas.stateAfter() != null) : String.valueOf(cas) + " has no state after with graph builder context " + String.valueOf(b);
        return true;
    }

    private boolean handleGetAddress(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, snippetReflection, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((Node)new VMThreadLocalSTHolderNode(threadLocalInfo));
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new AddressOfVMThreadLocalNode(threadLocalInfo, (ValueNode)holder));
        return true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        List<VMThreadLocalInfo> sortedThreadLocalInfos = this.threadLocalCollector.sortThreadLocals();
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int nextObject = 0;
        int nextPrimitive = 0;
        for (VMThreadLocalInfo info : sortedThreadLocalInfos) {
            if (info.isObject) {
                info.offset = NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Object, nextObject));
                ++nextObject;
                continue;
            }
            assert (nextPrimitive % Math.min(8, info.sizeInBytes) == 0) : "alignment mismatch: " + info.sizeInBytes + ", " + nextPrimitive;
            info.offset = NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Byte, nextPrimitive));
            nextPrimitive += info.sizeInBytes;
        }
        VMThreadLocalSTSupport support = (VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class);
        support.objectThreadLocals = new Object[nextObject];
        support.primitiveThreadLocals = new byte[nextPrimitive];
        VMThreadLocalInfos.setInfos(sortedThreadLocalInfos);
    }
}

