/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.ReadableJavaField;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.substitute.FieldValueTransformation;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Objects;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public final class ComputedValueField
extends FieldValueTransformation
implements ReadableJavaField,
OriginalFieldProvider,
AnnotationWrapper {
    private static final EnumSet<RecomputeFieldValue.Kind> offsetComputationKinds = EnumSet.of(RecomputeFieldValue.Kind.FieldOffset, RecomputeFieldValue.Kind.TranslateFieldOffset, RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset);
    private final ResolvedJavaField original;
    private final ResolvedJavaField annotated;
    private final RecomputeFieldValue.Kind kind;
    private final Class<?> targetClass;
    private final Field targetField;
    private final boolean isFinal;
    private final boolean isValueAvailableBeforeAnalysis;
    private final boolean isValueAvailableOnlyAfterAnalysis;
    private final boolean isValueAvailableOnlyAfterCompilation;
    private JavaConstant constantValue;

    public static ComputedValueField create(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> targetClass, String targetName, boolean isFinal) {
        return ComputedValueField.create(original, annotated, kind, null, null, targetClass, targetName, isFinal, false);
    }

    public static ComputedValueField create(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> transformedValueAllowedType, FieldValueTransformer initialTransformer, Class<?> targetClass, String targetName, boolean isFinal, boolean disableCaching) {
        assert (original != null);
        assert (initialTransformer != null || targetClass != null);
        boolean customValueAvailableBeforeAnalysis = true;
        boolean customValueAvailableOnlyAfterAnalysis = false;
        boolean customValueAvailableOnlyAfterCompilation = false;
        FieldValueTransformer transformer = null;
        Field f = null;
        JavaConstant constantValue = null;
        switch (kind) {
            case Reset: {
                constantValue = JavaConstant.defaultForKind((JavaKind)original.getType().getJavaKind());
                break;
            }
            case FieldOffset: {
                f = ComputedValueField.getField(annotated, targetClass, targetName);
                break;
            }
            case StaticFieldBase: {
                f = ComputedValueField.getField(annotated, targetClass, targetName);
                Object[] args = new Object[]{};
                if (Modifier.isStatic(f.getModifiers())) break;
                throw UserError.abort("Target field must be static for " + String.valueOf(RecomputeFieldValue.Kind.StaticFieldBase) + " computation of field " + original.format("%H.%n") + (String)(annotated != null ? " specified by alias " + annotated.format("%H.%n") : ""), new Object[0]);
            }
            case Custom: {
                transformer = initialTransformer != null ? initialTransformer : (FieldValueTransformer)ReflectionUtil.newInstance(targetClass);
                if (!(transformer instanceof FieldValueTransformerWithAvailability)) break;
                FieldValueTransformerWithAvailability.ValueAvailability valueAvailability = ((FieldValueTransformerWithAvailability)transformer).valueAvailability();
                customValueAvailableBeforeAnalysis = valueAvailability == FieldValueTransformerWithAvailability.ValueAvailability.BeforeAnalysis;
                customValueAvailableOnlyAfterAnalysis = valueAvailability == FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
                customValueAvailableOnlyAfterCompilation = valueAvailability == FieldValueTransformerWithAvailability.ValueAvailability.AfterCompilation;
            }
        }
        boolean isOffsetField = ComputedValueField.isOffsetRecomputation(kind);
        boolean isStaticFieldBase = kind == RecomputeFieldValue.Kind.StaticFieldBase;
        VMError.guarantee(!isFinal || !isOffsetField);
        boolean isValueAvailableBeforeAnalysis = customValueAvailableBeforeAnalysis && !isOffsetField && !isStaticFieldBase;
        boolean isValueAvailableOnlyAfterAnalysis = customValueAvailableOnlyAfterAnalysis || isOffsetField || isStaticFieldBase;
        boolean isValueAvailableOnlyAfterCompilation = customValueAvailableOnlyAfterCompilation;
        return new ComputedValueField(original, annotated, kind, transformedValueAllowedType, transformer, isFinal, disableCaching, targetClass, f, isValueAvailableBeforeAnalysis, isValueAvailableOnlyAfterAnalysis, isValueAvailableOnlyAfterCompilation, constantValue);
    }

    private static Field getField(ResolvedJavaField annotated, Class<?> targetClass, String targetName) {
        try {
            return ReflectionUtil.lookupField(targetClass, (String)targetName);
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            throw UserError.abort("Could not find target field %s.%s for alias %s.", targetClass.getName(), targetName, annotated == null ? null : annotated.format("%H.%n"));
        }
    }

    public static boolean isOffsetRecomputation(RecomputeFieldValue.Kind kind) {
        return offsetComputationKinds.contains(kind);
    }

    private ComputedValueField(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> transformedValueAllowedType, FieldValueTransformer fieldValueTransformer, boolean isFinal, boolean disableCaching, Class<?> targetClass, Field targetField, boolean isValueAvailableBeforeAnalysis, boolean isValueAvailableOnlyAfterAnalysis, boolean isValueAvailableOnlyAfterCompilation, JavaConstant constantValue) {
        super(transformedValueAllowedType, fieldValueTransformer, disableCaching);
        this.original = original;
        this.annotated = annotated;
        this.kind = kind;
        this.targetClass = targetClass;
        this.targetField = targetField;
        this.isFinal = isFinal;
        this.isValueAvailableBeforeAnalysis = isValueAvailableBeforeAnalysis;
        this.isValueAvailableOnlyAfterAnalysis = isValueAvailableOnlyAfterAnalysis;
        this.isValueAvailableOnlyAfterCompilation = isValueAvailableOnlyAfterCompilation;
        this.constantValue = constantValue;
    }

    @Override
    public boolean isValueAvailable() {
        return this.constantValue != null || this.isValueAvailableBeforeAnalysis || this.isValueAvailableOnlyAfterAnalysis && BuildPhaseProvider.isHostedUniverseBuilt() || this.isValueAvailableOnlyAfterCompilation && BuildPhaseProvider.isCompilationFinished();
    }

    public ResolvedJavaField getAnnotated() {
        return this.annotated;
    }

    Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Field getTargetField() {
        return this.targetField;
    }

    public RecomputeFieldValue.Kind getRecomputeValueKind() {
        return this.kind;
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        int result = this.original.getModifiers();
        result = this.isFinal ? (result |= 0x10) : (result &= 0xFFFFFFEF);
        return result;
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public void processAnalysis(AnalysisMetaAccess aMetaAccess) {
        switch (this.kind) {
            case FieldOffset: {
                AnalysisField target = aMetaAccess.lookupJavaField(this.targetField);
                target.registerAsAccessed((Object)this);
            }
        }
    }

    private JavaConstant asConstant(int value) {
        switch (this.getJavaKind()) {
            case Int: {
                return JavaConstant.forInt((int)value);
            }
            case Long: {
                return JavaConstant.forLong((long)value);
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(this.getJavaKind());
    }

    public void processSubstrate(HostedMetaAccess metaAccess) {
        switch (this.kind) {
            case FieldOffset: {
                this.constantValue = this.asConstant(metaAccess.lookupJavaField(this.targetField).getLocation());
            }
        }
    }

    @Override
    public JavaConstant readValue(ClassInitializationSupport classInitializationSupport, JavaConstant receiver) {
        if (this.constantValue != null) {
            return this.constantValue;
        }
        switch (this.kind) {
            case None: 
            case Manual: {
                return ReadableJavaField.readFieldValue(classInitializationSupport, this.original, receiver);
            }
            case FromAlias: {
                assert (Modifier.isStatic(this.annotated.getModifiers())) : "Cannot use " + String.valueOf(this.kind) + " on non-static alias " + this.annotated.format("%H.%n");
                this.annotated.getDeclaringClass().initialize();
                this.constantValue = ReadableJavaField.readFieldValue(classInitializationSupport, this.annotated, null);
                return this.constantValue;
            }
            case ArrayBaseOffset: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case ArrayIndexScale: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayIndexScale(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case ArrayIndexShift: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayIndexShift(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case StaticFieldBase: {
                Object staticFieldsArray = this.targetField.getType().isPrimitive() ? StaticFieldsSupport.getStaticPrimitiveFields() : StaticFieldsSupport.getStaticObjectFields();
                this.constantValue = GraalAccess.getOriginalSnippetReflection().forObject(staticFieldsArray);
                return this.constantValue;
            }
        }
        return super.readValue(classInitializationSupport, this.original, receiver);
    }

    @Override
    protected JavaConstant computeValue(ClassInitializationSupport classInitializationSupport, ResolvedJavaField field, JavaConstant receiver) {
        assert (this.isValueAvailable()) : "Field " + this.format("%H.%n") + " value not available for reading.";
        return switch (this.kind) {
            case RecomputeFieldValue.Kind.NewInstanceWhenNotNull -> this.fetchOriginalValue(classInitializationSupport, field, receiver) == null ? JavaConstant.NULL_POINTER : this.createNewInstance();
            case RecomputeFieldValue.Kind.NewInstance -> this.createNewInstance();
            case RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset -> this.computeAtomicFieldUpdaterOffset(classInitializationSupport, receiver);
            case RecomputeFieldValue.Kind.TranslateFieldOffset -> this.translateFieldOffset(classInitializationSupport, receiver, this.targetClass);
            case RecomputeFieldValue.Kind.Custom -> super.computeValue(classInitializationSupport, field, receiver);
            default -> throw VMError.shouldNotReachHere("Field recomputation of kind " + String.valueOf(this.kind) + " for field " + this.original.format("%H.%n") + (String)(this.annotated != null ? " specified by alias " + this.annotated.format("%H.%n") : "") + " not yet supported");
        };
    }

    private JavaConstant createNewInstance() {
        JavaConstant result;
        try {
            result = GraalAccess.getOriginalSnippetReflection().forObject(ReflectionUtil.newInstance(this.targetClass));
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw VMError.shouldNotReachHere("Error performing field recomputation for alias " + this.annotated.format("%H.%n"), ex.getCause());
        }
        return result;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        if (this.original.isFinal()) {
            return true;
        }
        return ReadableJavaField.injectFinalForRuntimeCompilation(this.original);
    }

    private JavaConstant translateFieldOffset(ClassInitializationSupport classInitializationSupport, JavaConstant receiver, Class<?> tclass) {
        long searchOffset = ReadableJavaField.readFieldValue(classInitializationSupport, this.original, receiver).asLong();
        for (Field f : tclass.getDeclaredFields()) {
            long fieldOffset;
            if (Modifier.isStatic(f.getModifiers()) || (fieldOffset = Unsafe.getUnsafe().objectFieldOffset(f)) != searchOffset) continue;
            int location = ((ReflectionSubstitutionSupport)ImageSingletons.lookup(ReflectionSubstitutionSupport.class)).getFieldOffset(f, true);
            VMError.guarantee(location > 0, "Location is missing for field whose offset is stored: %s.", f);
            return JavaConstant.forLong((long)location);
        }
        throw VMError.shouldNotReachHere("unknown field offset class: " + String.valueOf(tclass) + ", offset = " + searchOffset);
    }

    private JavaConstant computeAtomicFieldUpdaterOffset(ClassInitializationSupport classInitializationSupport, JavaConstant receiver) {
        assert (!Modifier.isStatic(this.original.getModifiers()));
        assert (receiver.isNonNull());
        ResolvedJavaField tclassField = ComputedValueField.findField(this.original.getDeclaringClass(), "tclass");
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        Class tclass = (Class)originalSnippetReflection.asObject(Class.class, ReadableJavaField.readFieldValue(classInitializationSupport, tclassField, receiver));
        return this.translateFieldOffset(classInitializationSupport, receiver, tclass);
    }

    private static ResolvedJavaField findField(ResolvedJavaType declaringClass, String name) {
        for (ResolvedJavaField field : declaringClass.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Field not found: " + declaringClass.toJavaName(true) + "." + name);
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    public boolean isCompatible(ResolvedJavaField o) {
        if (this.equals(o)) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputedValueField that = (ComputedValueField)o;
        return this.isFinal == that.isFinal && this.disableCaching == that.disableCaching && this.original.equals((Object)that.original) && this.kind == that.kind && Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.targetField, that.targetField) && Objects.equals(this.constantValue, that.constantValue);
    }

    public String toString() {
        return "RecomputeValueField<original " + this.original.toString() + ", kind " + String.valueOf(this.kind) + ">";
    }

    public ResolvedJavaField unwrapTowardsOriginalField() {
        return this.original;
    }

    public JavaConstant getConstantValue() {
        return this.original.getConstantValue();
    }
}

