/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.function.RelocatedPointer;

public class RelocatableConstant
implements JavaConstant,
TypedConstant {
    private final RelocatedPointer pointer;

    public RelocatableConstant(RelocatedPointer pointer) {
        this.pointer = pointer;
    }

    public RelocatedPointer getPointer() {
        return this.pointer;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        throw new IllegalArgumentException();
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public ResolvedJavaType getType(MetaAccessProvider provider) {
        return provider.lookupJavaType(this.pointer.getClass());
    }

    public int getIdentityHashCode() {
        return 0;
    }

    public int hashCode() {
        return this.pointer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelocatableConstant) {
            RelocatableConstant rc = (RelocatableConstant)obj;
            return this.pointer == rc.pointer;
        }
        return false;
    }
}

